"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolverResourceIDs = void 0;
const util_1 = require("./util");
class ResolverResourceIDs {
    static DynamoDBCreateResolverResourceID(typeName) {
        return `Create${util_1.resourceName(typeName)}Resolver`;
    }
    static DynamoDBUpdateResolverResourceID(typeName) {
        return `Update${util_1.resourceName(typeName)}Resolver`;
    }
    static DynamoDBDeleteResolverResourceID(typeName) {
        return `Delete${util_1.resourceName(typeName)}Resolver`;
    }
    static DynamoDBGetResolverResourceID(typeName) {
        return `Get${util_1.resourceName(typeName)}Resolver`;
    }
    static DynamoDBListResolverResourceID(typeName) {
        return `List${util_1.resourceName(typeName)}Resolver`;
    }
    static ElasticsearchSearchResolverResourceID(typeName) {
        return `Search${util_1.resourceName(typeName)}Resolver`;
    }
    static SyncResolverResourceID(typeName) {
        return `Sync${util_1.resourceName(typeName)}Resolver`;
    }
    static ResolverResourceID(typeName, fieldName) {
        return `${util_1.resourceName(`${typeName}${fieldName}`)}Resolver`;
    }
}
exports.ResolverResourceIDs = ResolverResourceIDs;
//# sourceMappingURL=ResolverResourceIDs.js.map