"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionResourceIDs = void 0;
const util_1 = require("./util");
const md5_1 = __importDefault(require("md5"));
class FunctionResourceIDs {
    static FunctionDataSourceID(name, region) {
        return `${util_1.simplifyName(name)}${util_1.simplifyName(region || '')}LambdaDataSource`;
    }
    static FunctionIAMRoleID(name, region) {
        return `${FunctionResourceIDs.FunctionDataSourceID(name, region)}Role`;
    }
    static FunctionIAMRoleName(name, withEnv = false) {
        if (withEnv) {
            return `${util_1.simplifyName(name).slice(0, 22)}${md5_1.default(name).slice(0, 4)}`;
        }
        return `${util_1.simplifyName(name).slice(0, 32)}${md5_1.default(name).slice(0, 4)}`;
    }
    static FunctionAppSyncFunctionConfigurationID(name, region) {
        return `Invoke${FunctionResourceIDs.FunctionDataSourceID(name, region)}`;
    }
}
exports.FunctionResourceIDs = FunctionResourceIDs;
//# sourceMappingURL=FunctionResourceIDs.js.map