"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticsearchMappingTemplate = void 0;
const print_1 = require("./print");
const ast_1 = require("./ast");
const RESOLVER_VERSION_ID = '2018-05-29';
class ElasticsearchMappingTemplate {
    static genericTemplte({ operation, path, params, }) {
        return ast_1.obj({
            version: ast_1.str(RESOLVER_VERSION_ID),
            operation,
            path,
            params,
        });
    }
    static searchItem({ query, size, search_after, from, path, sort, version = ast_1.bool(false), }) {
        return ast_1.obj({
            version: ast_1.str(RESOLVER_VERSION_ID),
            operation: ast_1.str('GET'),
            path,
            params: ast_1.obj({
                body: ast_1.raw(`{
                #if( $context.args.nextToken )"search_after": ${print_1.print(search_after)}, #end
                #if( $context.args.from )"from": ${print_1.print(from)}, #end
                "size": ${print_1.print(size)},
                "sort": ${print_1.print(sort)},
                "version": ${print_1.print(version)},
                "query": ${print_1.print(query)}
                }`),
            }),
        });
    }
}
exports.ElasticsearchMappingTemplate = ElasticsearchMappingTemplate;
//# sourceMappingURL=elasticsearch.js.map