import { Expression, ReferenceNode, StringNode, ObjectNode, CompoundExpressionNode } from './ast';
export declare const RESOLVER_VERSION_ID = "2018-05-29";
export declare class DynamoDBMappingTemplate {
    static putItem({ key, attributeValues, condition, }: {
        key: ObjectNode | Expression;
        attributeValues: Expression;
        condition?: ObjectNode | ReferenceNode;
    }, version?: string): ObjectNode;
    static getItem({ key, isSyncEnabled }: {
        key: ObjectNode | Expression;
        isSyncEnabled?: boolean;
    }): ObjectNode;
    static query({ query, scanIndexForward, filter, limit, nextToken, index, }: {
        query: ObjectNode | Expression;
        scanIndexForward: Expression;
        filter: ObjectNode | Expression;
        limit: Expression;
        nextToken?: Expression;
        index?: StringNode;
    }): ObjectNode;
    static listItem({ filter, limit, nextToken, scanIndexForward, query, index, }: {
        filter: ObjectNode | Expression;
        limit: Expression;
        nextToken?: Expression;
        scanIndexForward?: Expression;
        query?: ObjectNode | Expression;
        index?: StringNode;
    }, version?: string): ObjectNode;
    static syncItem({ filter, limit, nextToken, lastSync, }: {
        filter?: ObjectNode | Expression;
        limit?: Expression;
        nextToken?: Expression;
        lastSync?: Expression;
    }): CompoundExpressionNode;
    static deleteItem({ key, condition, isSyncEnabled, }: {
        key: ObjectNode | Expression;
        condition: ObjectNode | ReferenceNode;
        isSyncEnabled: boolean;
    }): ObjectNode;
    static updateItem({ key, condition, objectKeyVariable, nameOverrideMap, isSyncEnabled, }: {
        key: ObjectNode | Expression;
        condition: ObjectNode | ReferenceNode;
        objectKeyVariable: string;
        nameOverrideMap?: string;
        isSyncEnabled?: boolean;
    }): CompoundExpressionNode;
    static dynamoDBResponse(isSyncEnabled: boolean, returnExpression?: Expression): CompoundExpressionNode;
    static stringAttributeValue(value: Expression): ObjectNode;
    static numericAttributeValue(value: Expression): ObjectNode;
    static binaryAttributeValue(value: Expression): ObjectNode;
    static paginatedResponse(): ObjectNode;
}
//# sourceMappingURL=dynamodb.d.ts.map