"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnknownDirectiveError = exports.InvalidDirectiveError = exports.InvalidMigrationError = exports.TransformerContractError = exports.SchemaValidationError = exports.InvalidTransformerError = void 0;
class InvalidTransformerError extends Error {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, InvalidTransformerError.prototype);
        this.name = 'InvalidTransformerError';
        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, InvalidTransformerError);
        }
    }
}
exports.InvalidTransformerError = InvalidTransformerError;
class SchemaValidationError extends Error {
    constructor(errors) {
        super(`Schema Errors:\n\n${errors.join('\n')}`);
        Object.setPrototypeOf(this, SchemaValidationError.prototype);
        this.name = 'SchemaValidationError';
        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, SchemaValidationError);
        }
    }
}
exports.SchemaValidationError = SchemaValidationError;
class TransformerContractError extends Error {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, TransformerContractError.prototype);
        this.name = 'TransformerContractError';
        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, TransformerContractError);
        }
    }
}
exports.TransformerContractError = TransformerContractError;
class InvalidMigrationError extends Error {
    constructor(message, cause, fix) {
        super(message);
        Object.setPrototypeOf(this, InvalidMigrationError.prototype);
        this.name = 'InvalidMigrationError';
        this.fix = fix;
        this.cause = cause;
    }
}
exports.InvalidMigrationError = InvalidMigrationError;
InvalidMigrationError.prototype.toString = function () {
    return `${this.message}\nCause: ${this.cause}\nHow to fix: ${this.fix}`;
};
class InvalidDirectiveError extends Error {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, InvalidDirectiveError.prototype);
        this.name = 'InvalidDirectiveError';
        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, InvalidDirectiveError);
        }
    }
}
exports.InvalidDirectiveError = InvalidDirectiveError;
class UnknownDirectiveError extends Error {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, UnknownDirectiveError.prototype);
        this.name = 'UnknownDirectiveError';
        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, UnknownDirectiveError);
        }
    }
}
exports.UnknownDirectiveError = UnknownDirectiveError;
//# sourceMappingURL=errors.js.map