import { DirectiveNode, ObjectTypeDefinitionNode } from 'graphql';
import { Transformer, TransformerContext, SyncConfig } from 'graphql-transformer-core';
import { ResourceFactory } from './resources';
export interface DynamoDBModelTransformerOptions {
    EnableDeletionProtection?: boolean;
    SyncConfig?: SyncConfig;
}
export declare const CONDITIONS_MINIMUM_VERSION = 5;
export declare const directiveDefinition: import("graphql").DocumentNode;
export declare class DynamoDBModelTransformer extends Transformer {
    resources: ResourceFactory;
    opts: DynamoDBModelTransformerOptions;
    constructor(opts?: DynamoDBModelTransformerOptions);
    before: (ctx: TransformerContext) => void;
    after: (ctx: TransformerContext) => void;
    object: (def: ObjectTypeDefinitionNode, directive: DirectiveNode, ctx: TransformerContext) => void;
    private addTimestampFields;
    private addIdField;
    private createMutations;
    private createQueries;
    private createSubscriptions;
    private typeExist;
    private generateModelXConnectionType;
    private generateFilterInputs;
    private generateConditionInputs;
    private getOpts;
    private setSyncConfig;
    private updateMutationConditionInput;
    private supportsConditions;
    private static isTimestampCompatibleField;
    private addInitalizationMetadata;
}
//# sourceMappingURL=DynamoDBModelTransformer.d.ts.map