"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redactor = void 0;
const containsToRedact = ['key', 'id', 'password', 'name', 'arn', 'address', 'app', 'bucket', 'token'];
const quotes = '\\\\?"';
const keyMatcher = `\\w*?(${containsToRedact.join('|')})\\w*?`;
const completeMatch = `${quotes}(${keyMatcher})${quotes}:\\s?${quotes}([^!\\\\?"]+)${quotes}`;
function Redactor(arg) {
    if (!arg)
        return '';
    const jsonregex = new RegExp(completeMatch, 'gmi');
    if (jsonregex.test(arg)) {
        jsonregex.lastIndex = 0;
        let m;
        const valuestToRedact = [];
        do {
            m = jsonregex.exec(arg);
            if (m !== null) {
                valuestToRedact.push(m[3]);
            }
        } while (m !== null);
        valuestToRedact.forEach(val => {
            arg = arg === null || arg === void 0 ? void 0 : arg.replace(val, stringMasker);
        });
    }
    return arg;
}
exports.Redactor = Redactor;
function stringMasker(s) {
    if (!s.includes('-') && !s.includes('/'))
        return redactPart(s);
    if (s.includes('/') && !s.includes('-'))
        return redactBySlashSplit(s);
    const newString = s
        .split('-')
        .map(part => {
        if (part.includes('/')) {
            return redactBySlashSplit(part);
        }
        else {
            return redactPart(part);
        }
    })
        .join('-');
    return newString;
}
function redactBySlashSplit(s) {
    return s
        .split('/')
        .map(redactPart)
        .join('/');
}
function redactPart(s) {
    const length = s.length;
    const maskPercentage = 60 / 100;
    const replaceLength = Math.floor(length * maskPercentage);
    return '[***]' + s.substring(replaceLength, length);
}
//# sourceMappingURL=Redactor.js.map