import logging

logging.basicConfig(level=logging.INFO)


def record_mouse() -> None:
    """
    Public function to start recording of mouse input
    """
    from gameart.inputs import mousetracker

    mousetracker._record_mouse()


def draw_mouse_tracks(csv_file: str = "") -> None:
    """
    Public function to draw mousetracking-art based on csv file input
    which was generated by the method 'record_mouse'

    Args:
        csv_file (str): argument to provide path to csv file.
    """
    from gameart.draw import art
    from gameart.FileHandler import FileHandlerSingleton

    file_handler = FileHandlerSingleton()

    if csv_file:
        file_handler.csv_file = csv_file

    if file_handler.csv_file:
        art._draw_mouse_tracks()
    else:
        logging.error(
            """No csv file selected! Either select one (GUI) or specify the
            csv file with `gameart record --csv-file path/to/csv/file` (CLI)"""
        )


def start_gui() -> None:
    """
    Public function to start the GUI of gameart.
    """
    from gameart import gui

    gui._start_gui()
