import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectFreezePeriodConfig extends cdktf.TerraformMetaArguments {
    /**
    * The timezone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_freeze_period#cron_timezone ProjectFreezePeriod#cron_timezone}
    */
    readonly cronTimezone?: string;
    /**
    * End of the Freeze Period in cron format (e.g. `0 2 * * *`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_freeze_period#freeze_end ProjectFreezePeriod#freeze_end}
    */
    readonly freezeEnd: string;
    /**
    * Start of the Freeze Period in cron format (e.g. `0 1 * * *`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_freeze_period#freeze_start ProjectFreezePeriod#freeze_start}
    */
    readonly freezeStart: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_freeze_period#id ProjectFreezePeriod#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The id of the project to add the schedule to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_freeze_period#project_id ProjectFreezePeriod#project_id}
    */
    readonly projectId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_freeze_period gitlab_project_freeze_period}
*/
export declare class ProjectFreezePeriod extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_freeze_period";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_freeze_period gitlab_project_freeze_period} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectFreezePeriodConfig
    */
    constructor(scope: Construct, id: string, config: ProjectFreezePeriodConfig);
    private _cronTimezone?;
    get cronTimezone(): string;
    set cronTimezone(value: string);
    resetCronTimezone(): void;
    get cronTimezoneInput(): string | undefined;
    private _freezeEnd?;
    get freezeEnd(): string;
    set freezeEnd(value: string);
    get freezeEndInput(): string | undefined;
    private _freezeStart?;
    get freezeStart(): string;
    set freezeStart(value: string);
    get freezeStartInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=project-freeze-period.d.ts.map