import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectBadgeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_badge#id ProjectBadge#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The image url which will be presented on project overview.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_badge#image_url ProjectBadge#image_url}
    */
    readonly imageUrl: string;
    /**
    * The url linked with the badge.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_badge#link_url ProjectBadge#link_url}
    */
    readonly linkUrl: string;
    /**
    * The id of the project to add the badge to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_badge#project ProjectBadge#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_badge gitlab_project_badge}
*/
export declare class ProjectBadge extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_badge";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_badge gitlab_project_badge} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectBadgeConfig
    */
    constructor(scope: Construct, id: string, config: ProjectBadgeConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    get imageUrlInput(): string | undefined;
    private _linkUrl?;
    get linkUrl(): string;
    set linkUrl(value: string);
    get linkUrlInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get renderedImageUrl(): string;
    get renderedLinkUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=project-badge.d.ts.map