import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DeployTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Time the token will expire it, RFC3339 format. Will not expire per default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_token#expires_at DeployToken#expires_at}
    */
    readonly expiresAt?: string;
    /**
    * The name or id of the group to add the deploy token to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_token#group DeployToken#group}
    */
    readonly group?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_token#id DeployToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A name to describe the deploy token with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_token#name DeployToken#name}
    */
    readonly name: string;
    /**
    * The name or id of the project to add the deploy token to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_token#project DeployToken#project}
    */
    readonly project?: string;
    /**
    * Valid values: `read_repository`, `read_registry`, `read_package_registry`, `write_registry`, `write_package_registry`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_token#scopes DeployToken#scopes}
    */
    readonly scopes: string[];
    /**
    * A username for the deploy token. Default is `gitlab+deploy-token-{n}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_token#username DeployToken#username}
    */
    readonly username?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_token gitlab_deploy_token}
*/
export declare class DeployToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_deploy_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_token gitlab_deploy_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DeployTokenConfig
    */
    constructor(scope: Construct, id: string, config: DeployTokenConfig);
    private _expiresAt?;
    get expiresAt(): string;
    set expiresAt(value: string);
    resetExpiresAt(): void;
    get expiresAtInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    get token(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=deploy-token.d.ts.map