import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DeployKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allow this deploy key to be used to push changes to the project. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key#can_push DeployKey#can_push}
    */
    readonly canPush?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key#id DeployKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The public ssh key body.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key#key DeployKey#key}
    */
    readonly key: string;
    /**
    * The name or id of the project to add the deploy key to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key#project DeployKey#project}
    */
    readonly project: string;
    /**
    * A title to describe the deploy key with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key#title DeployKey#title}
    */
    readonly title: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key gitlab_deploy_key}
*/
export declare class DeployKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_deploy_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key gitlab_deploy_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DeployKeyConfig
    */
    constructor(scope: Construct, id: string, config: DeployKeyConfig);
    private _canPush?;
    get canPush(): boolean | cdktf.IResolvable;
    set canPush(value: boolean | cdktf.IResolvable);
    resetCanPush(): void;
    get canPushInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=deploy-key.d.ts.map