import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DeployKeyEnableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Can deploy key push to the project's repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key_enable#can_push DeployKeyEnable#can_push}
    */
    readonly canPush?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key_enable#id DeployKeyEnable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Deploy key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key_enable#key DeployKeyEnable#key}
    */
    readonly key?: string;
    /**
    * The Gitlab key id for the pre-existing deploy key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key_enable#key_id DeployKeyEnable#key_id}
    */
    readonly keyId: string;
    /**
    * The name or id of the project to add the deploy key to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key_enable#project DeployKeyEnable#project}
    */
    readonly project: string;
    /**
    * Deploy key's title.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key_enable#title DeployKeyEnable#title}
    */
    readonly title?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key_enable gitlab_deploy_key_enable}
*/
export declare class DeployKeyEnable extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_deploy_key_enable";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/deploy_key_enable gitlab_deploy_key_enable} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DeployKeyEnableConfig
    */
    constructor(scope: Construct, id: string, config: DeployKeyEnableConfig);
    private _canPush?;
    get canPush(): boolean | cdktf.IResolvable;
    set canPush(value: boolean | cdktf.IResolvable);
    resetCanPush(): void;
    get canPushInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=deploy-key-enable.d.ts.map