<h4 align="center">
  <a href="https://uptrain.ai">
   <img alt="Logo of UpTrain - an open-source platform to evaluate and improve LLM applications" src="https://github.com/uptrain-ai/uptrain/assets/108270398/b6a4905f-63fd-47ab-a894-1026a6669c86"/>
  </a>
</h4>

<p align="center">
    <a href="https://demo.uptrain.ai/evals_demo/">
        <img alt="Try out Evaluation" src="https://img.shields.io/badge/Try%20Evaluations-uptrain?logo=data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAACXBIWXMAAAsTAAALEwEAmpwYAAAEl0lEQVR4nO2dS8gWVQCGPzMvZVmWXRZ2VwuxolpIq8BMzDAqyChLQnBjpC76iVbZQvorSgqjsILoBgWFQQbhohICVwVJEbgwMu1C%2FaaRpWZPHP4jfQ1zZuab%2Bc6ZMzPvA7M792eu5za9nhBCCCGEEEIIIYQQHQOYBFwDrAYe7six2tZ5Ui8WgMuBV4BDdJdDwMvA3DpFTAGeAI7V3RoRYdpiFJgcWsaZwKd11z5iPgbOCCVjKrCj7ho3gE%2FMXSSEkGfrrmmDeNq3jKuB4wXuo7uAPQUK%2FAPwOfAX7eQ4cKVPIW%2FnFOALYHZf%2BMXAmEPaqr5wM4FttJO3fMmYnnMmH%2BuX0RdvVUrYpxzp%2F0j7%2BNPUzYeQhTkZ73LEM2d%2FkhtKXoFNZaEPISM5me5xxLskJewtjrDbaCcjPoRsKpDx4pR4j6eE25oSbi5wmHayyYeQzQUyHrPPjJn2yjAy%2FnaEfR2YZz6ggFsLvpU1lc11CRHpSEhkSEhkSEhkSEhkSEiXhZhxkUU6WJQxRhRUyDtDz6yhmLaQkIiQkMiQkMiQkMiQkMiQkMiQkAAA5wArgPuAs3PC6rXXJ8BNwC993xYHgOszwkuIL4AldoJCkq8z4khIYBknmNFYIcAE4KpAfV3XAhNzynOxnUFzXkkZB1zLD6IXAlwKfElYdgPzHSfGi8A%2FNtyR5GyQAjIMj2TUN3ohn1EP3wAnJcpyvyPshgFkPG%2FENlKIY4JcSK4o2FiGN6vKaIKQ02pezHNBojxbKqSVKyN6ITbOq9TDBylluQ446ktGU4ScCjwH%2FEoYDtr1jqmrl4C7MybuVZLRCCExAtxZ8Fa6ZRAZNm0J8SRlYBk2XQnxIKWUDJumhFQBWAp8b0X8YTcDmFAhPQmpiv2CnzWM3RgkJDIkJDIkJADAMtu1Yp4Py3LC6hniE7tvSZIHMsJLiC%2BAJzOW7aWOuUhIeBknOMsRT1fIINge6DXAM8A9wMklZOx2fas0QghwEfBgoB3e1gNzMraU%2BipR9u3AtAFkmN7iGzPqGrcQu9eJ%2BQIOyRFgeUpZNmTsbTWtoIzbctooXiFmCBX4lnoYA05JlOe9jPB7q8pogpDzqZf5ifJsLJlOIRlNEDLZDhjVwdHkmxBwLvBdiXRuH6CN4hVi4zxEPYw6ymP2U9nnQ0YjhNh4dwDv2jca38dWYGXOVJ0iUgaW0RghMQLM6RsHGYoMm66ElMVxpZSWYdOUkCqY%2Bb3AS3a66%2FtmbnDF9CQkJiQkMiQkMiSk40LMnxDS%2BHDomTUU0xaDfKhWzWxdRsdc6blMbYHx6USuD861PjK8GTdLex2H8ckQLpb4%2Bk3F744MTafdrF5HYXyi3d6Mv%2B%2F4%2BW0F8EbGWWAu1%2BVpw6It%2F%2B%2FWXcD%2BjHZ5zXcfUN6il9%2BAnYE6E7fXeOwsMLxgRi8v8yYkY66SSGejVxlWyESzZMxRAPEfH%2BWtmR%2BmlOkt%2FpPBMDAn7OlBZCSulMcKLCfuEoeBR5Nr5EOLuRB4AfiZ7vKTXSD6v6XYtWKvmAXAvfbnL6MtP0ZsXRcEe1YIIYQQQgghhBBCCNGLh38BZfHpULZhNcAAAAAASUVORK5CYII%3D&labelColor=CC766E&color=6A6A6A">
    </a>
    <a href="https://docs.uptrain.ai/getting-started/quickstart">
        <img alt="Read Docs" src="https://img.shields.io/badge/Read%20Docs-uptrain?logo=data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAACXBIWXMAAAsTAAALEwEAmpwYAAAC%2FklEQVR4nO3dO2sUURiH8SPipVAhKngJWggKolZ%2BAEGQIFiaL2CICNoLBmJAsBAbKxEREcTAYq%2BFYKGx8orxFkmhEltNY6P4yIEjs5FlJ4k7s%2B975v%2BD6ZJhD0%2FenZnsMhOCiIiIiIhIQwFbgFHgCjAJtPq83QF2hqYBNgNXgZ%2FYMwvsCE0B7E2LtuwjMBga8hb1CR9mso8C3MWXGWB7yBFwAPiNP2%2FjZIfcABfw6z2wLeQEuIdv74CtIRfA85IFv%2BnDdceTJUZ5FU%2FZQw6A6ZLFTvThNQ2zdC%2BBTcG7jIJEL9xHySzI3ygbg1cZBiEdF31GyTRI9AwYCN5kHIR0trYheJJ5kGgKWB%2B8aECQ6HHfogBHgJvpX%2BlPF%2FHzTQgSnat7EYPAAxaaXsTvNSXIRJ0L2APMdXgRClJ3kHgWAXygMwXpQ5Bu%2Fz73GmQAOLjEbbbv6wBWA99zC7IcJtaRzqi6UZCag5ymOwWpOcg43SlIzUEm6E5BCgrSxIO6JiRRkIXfBz5b8TYSSihIAuyjej6OhRbeslAQBelEE5JoQtroLaugCUk0IW00IQVNSALsip%2FdV7y1QgkFMUZBjFEQYxTEGAVJdNrbRqe9BU1IoglpowkpaEISTUgbTUhBE5JoQtpoQgqakIXfvh%2BueBsKJRTEGAUxRkGMURBjFMQYBTFGQYzJKcjrkn20arjO6MX2uWQd416CPKQZTnkJco1mOOwlyDHy9w1Y5SXIykUcR7w7X3mMXgVJ%2Bzlk9IkIvboD9jpXQdK%2BRoBf5OULsLvaChUFSfsbcvSUhDL3a78Nea%2BDpH2uBU6mW5DPOZqaH%2Bn5IjdqOaOqK4j8BwUxRkGMURBjFMQYBTFGQYxREGPi3ZpLrkPmDTw2tbWM7UzwCDhBni4Fj4D95Ol48Co9RS0n864eL%2FGv%2BNdEXsaCd8B18jAFrAnexUWkB9F79iibh0NGwApgFPiKv2PGWLyPfchRmpajwEXgloFrilaH7TZwOX3BrZ7Pu0VERERERIJ9fwBA%2FZMtFhwT0AAAAABJRU5ErkJggg%3D%3D&labelColor=976DA5&color=6A6A6A">
    </a>
    </a>
    <a href="https://join.slack.com/t/uptraincommunity/shared_invite/zt-1yih3aojn-CEoR_gAh6PDSknhFmuaJeg">
        <img alt="Slack Community" src="https://img.shields.io/badge/Slack%20Community-uptrain?logo=data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAACXBIWXMAAAsTAAALEwEAmpwYAAADFklEQVR4nO2cPW4TURSFLaWBhg6xACs9YhEsISiLiIzoUkGNRIV3kDSxhJVVBArKrCBUSCnCTyTc8KGRphomjsfv3vGBdz7JpY%2Bu5iQz9v3kN5kYY4wxxhhjjDHG%2FAXwGDgGPgJfgRXwBfgAHAJ7u8yrCuAI%2BM56LoFnu8irCuA9m3MLPB8zryrav%2BSh3AD7Y%2BRVRXuP%2F8Z2nGfnVUf7wC1hmplXHcBF4QWcZeZVB3BdeAHnmXnVAfwqvIBnnbzfkXnVAVwVXsBFJ4%2FIvOoAli5EiHZ94f8QFZpdUru%2B8C1LBeAp8NPPECGaXVK7vhiKH%2BqJpew36wtciBbAFHjZbmwX97xedd5bSt0fe6PBhWiBC9GC2gvpcdbRrIY48OxCpB39hs46mst1DjyzEGlHP9BZR3N7lwPPKkTa0W%2FprKO56XPgGYVIO%2FpCZx3NeXYh8o4%2BwFlHM00uRNvRBzjraGbJhWg7%2BgBnHc08uRBtRx%2FgwKM56czXfC8o4TTY0Z%2BoO%2FBo3gbP180LnU%2FRgUdzEDxfNy90PkUHHskP4FHgfH15ofMpOvBIXgfP15cXOp%2BiA4%2FiM%2FAwcL7evIz51Bx4BJ%2BAJ4Hz3ZmXNZ%2BSAy%2B9J78BHgTNd29e5nwqDnzo6xR4B7zY9gHZmW9Q3hjzGWNMrWzh1Ed11og5f0WnPpqzRtD5Kzr1UZw1os5f0amnO2uEnb%2BiU0911og7%2F4xCjpWdNeLOP6OQC2VnjbjzzyjkWtlZI%2B78FZ16tLM%2BC54vGnmnHu2sF8HzRSPv1A%2BSC1mihbRTj3bWfYVIO%2F%2BMQpScdV8h0s4%2FqxQFZ73um7%2B0888qZZfOepPdmLTzT2EHznro9lja%2BadR6KzTf6SJuPOXYoxCzABciBgu5D8vhH%2FJgSuyg0K6%2BOx3sUIafPa7WCENPvtdrJAGn%2F1OOYvgW2D1Z7%2BrFTKb1IxgIfNJzST8rnwl7cDVSXD0V5F51ZHg6JeRedWR4OgPI%2FOqI8HR70XmVUmko8%2FIq5IoR5%2BVVyURjj4zr1oocPRj5BljjDHGGGOMMcYYY8xElT9jEHRBpJyhuQAAAABJRU5ErkJggg%3D%3D&labelColor=6565d8&color=6A6A6A">
    </a>
    <a href="https://github.com/uptrain-ai/uptrain/issues/new?assignees=&labels=enhancement&template=feature_request.md&title=">
        <img alt="Request New Feature" src="https://img.shields.io/badge/Request%20New%20Feature-uptrain?logo=data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAACXBIWXMAAAsTAAALEwEAmpwYAAAG%2BElEQVR4nO2da6gWRRjHN1NLKy1Tu2B5CjEsMiO0wEiqoxhmZQUJ5YfyQ5FhdLEiIiItLQtRIswiMIvKNDOTCosyCzsVGWiXLykVdrESQz1aXn7xcObAsmdmdvc9715md37wftAzszuz%2F3eemX3mmecNAo%2FH4%2FF4PKUF6AmMBxYDG4E1wLii21VXEZYAf9KV%2F4BLim5n3UWIsqboNlcO0osQ5sui218J6J4IYRYX3RdnAY4ELgYWAr%2FRHFqL7pdTkI0IncjI6ll0H%2BsuQpjn8ujIWGAacA9wf0GfmcCwBuaEVnlI3ZwTOtkNvAq8YCkzPishzlQ3%2FoviaAdWADcAxxQswrVAH3UP%2BXc%2B5kp16EngX%2BotwmvAdZ0ihO7VR%2F1dx5Jmi3EC8AHFsAd4ADi%2BbCJE7isjJXtzBfQCPqIYfgHOSTif5S5CpA35mCu1%2BiiCfcDIHEXYk1aE3M0VMAI4GNORA8BmYFuCTsuy8mtgf4KyszXt6VGECMD54hgE%2Bhr%2BLvVzMVfSWBubwktOYAKw0yDaLaFyA4G1luseAk6KtGU48B05jgRgMPBpqK58CS5N8ZyaZ67UMNxr6dgB3fpfHrym7HxNuX7A74Zrf6MpL%2BLnZo7kCwF8a3jIfYswV5NiOrnZUE%2B%2B%2FVG0mzPA64Zrr46UG0K%2Bc4KIscVy7XFFmKs7Yzq8zVDvDE3ZSYayaw3XXh8pd6IyY0mR0TsbGNRAv%2BPEEM7L1VypGz2RoOMTNPXmasq9pSk3XL3s6djZwHymQxYPS4HRTRTjk4Tmqrm%2BK%2BCZBB3eqeaMgWpkzLWsypYBZwP9gasSrMouirTnWLVH3ainoE353Y6yTOBxYsjfB%2BdurlIIkiXvWL7F4lT8qcHr%2FgHMA4ZGxJClu43vgVMSzoGZ%2BK6KFkS4LcaDIH6tDTTGAeUbm5xwZESX4X1zM1clEuQgMD1BW0cBz1vmpO7QRYwE5qq1qoJ08n6SuCZgADAL2EqGYuS6uiqpIJ38oJbjVvd7yMUiAWqHaYwuc0ZCc5VNIENJBenkH%2BXPGpGgH8PUJK5z6aQWQ13zekvdy5suRowg69W3rwyfy0wOP01%2FjgNmJPSHTY65lslc7cgskMEiyPLAYYAjlJirLOZshaV%2BvqurqgsSRoliWt0NLY25qpEgrZaHO8dQJ7%2BXwboJIlje0GU%2BODooenVVQ0FmWEbJtFKYK9cFoSPyZApwl0QlJlh9yTJaR1vhqyvXBaHDrHweafOimDqLLN%2F8MYWuriogyEOGdo%2B11DnLsgRemtZ3JRExWXTMVUHeNrT77ph64i8zbXINSmOu5IU1i465KshCQ7uviaknbngTc9Qefay5Uhtp87PomKuCnK7xW22Mm3SVQ3KrZe8kqbmaKs8ui445KYgAnKZGymrgwRShP%2FeSDp25WlkbQejYar1dPeRRGVx%2FQEwsWhJz1V4LQejYFZT98LC%2F6dYM7mM7dJPEXFEXQT7UtGVvUvd7SuEbNVcr6iTILkN7Rmdwrw3dMFe1EaTNkK5icAb3kmiWtOYqXMddQYALgPtkPpAgOku5KzXLT62LvAltkhCj7Q2aK3cFoeOo2qHIiakWS%2FkLVbiPnFaa2qx2GO71cIPmyk1BZEcOfdjpsqAEACdbwlZt5spZQaYYrr8lKAkqlrhL%2B6LOw4i5claQkYbrd4mULwqJ%2F1LmsdOsfhU9pKSOSrQ7L4hhf7pdzvMFJUO9wZuC5h7RPCNnBemltlDfBJ6VMyOBQ6gV4r7KCOI6lj2S8gmiDnVKYpjHgKslQC2oGMByJwRRXtkfI%2FVerJooOCSI6XyiNQLENVwS5F1D3TuCCoFDgixIemrXZVwSZIjyS4WR%2FQw%2FhxS4yhJf0KPAS2KqgN5BxcCVEVIX8IKUCy9IyfCClIzSC6I2nU4NagJlFUQlnvkissRtevBB2SizIJ9pyq0MKg5lFEQ5Ek1h%2FJV793BBkH6GbG9y2qhHUGEooyCq7Bu5NKpklFmQ%2FipIeZdK0r8gbeJJFymtIKE6lXIelk2Qp9IKUjcw7%2FvMy%2BJmEubpBbEfgfvV8IxmBs0GuMIL0lDkpTAxaDZqotbFHNXeZAEtlt%2Br2h3NkdJMUXS%2FiVFbQYDewI2Ro3VRXsmyAedqItS1gqjELBI49rJpyKqFwjpHP22WnCjhA0TZRl8CT8cJYlgA3KwpV9Qv9eRF8xMGGIap5Fk0uU56G%2FLlbq%2BZIOty%2B%2BFIlcLoY3XjVZpD%2BjoOaxKA6bzCVeA923G8LHNQPS4nVDVJJXXn8TZprvEz1WK%2FyoPS%2FOw%2FaXKJaP5vYiQ5y9%2BaXzdo6UZS47KxQ%2BUN1ibKLFPSFzlJO92QK32MSmjs6mcWcJM6eFrciPB4PB6Px%2BPxeDwej8fj8XiCYvgfmdGLzXmrOA4AAAAASUVORK5CYII%3D&labelColor=5B92E9&color=6A6A6A">
    </a>
    <a href="https://demo.uptrain.ai/benchmark">
      <img alt="Daily Monitoring" src="https://img.shields.io/badge/Daily%20Monitoring-uptrain?logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAACXBIWXMAAAsTAAALEwEAmpwYAAAFUUlEQVR4nO2daahVVRTHt2WDls3RQDYXRUZBkRkRjdAraPjSAJUUKVSE0QuiQZ4FmRj2lMwwqGgitZTq5cvEIipKpGgymogwCrKs7IOkDf5i9ZYorzvsM+99zvrB/XjWXfv+z9ln7zXs65xhGIZhGIZhGIZRCsD2wOXAIuA94P2MH7HxLHBBOSOoEcBewJsUx/PATlWPMxqAQYpnXtXjjALgDMrhb+CwqscbPMAMymNy1eMNHuDxEgXpq3q8wQP0lSjIPVWPN3iAY4HNJkhAAHNMkIAAdgBml/Ck2JSVBOAo4HbgYWD+sM9KEyQQZP8ArDVBAgDYDfjUpqwAAEYCy+0dEgjAPHupBwJwq62yAgHo0WCgLXurBjgOWG/7kAAA9gfW2MYwAIDRwKoUYkiq9pdG7NQZSq3eD3wCrANWAwuBOyRXDRyU0/dsB7yQQoxvgf2AH2svCHCO50BFqBXALGAicCKwY8Lvmp5CjN+BcXp9fQXRu3VqxlXOn8DHwFNAL3AusG+b7xMRkyK+9Wxj42vP625zMQHsAyyjOH4AXtW07RXAZcCmFHZuHub3y57XxVMSBEwAviN85rbw/SKP62T1NtLFADBFp5nQWdbuRwWe6HDdRqlucZFEUqWILAZWi79d3n13tdhUfgSMd6EDnAB8RRys9a2pAnbRWq+Lt6zCgge4BthAHPwBnObqCLCzpkNjYTNwlasjwNG6N8jCr/opi2mujuh8+lvGH2cVcKjaO1A3e1N08/dZAeFyaUsY4eqEhDC0vCbrtDFLSnU8XqbjpX5Wq0be0fBGGt6V6dXVCWCsRkKzsB64NIMPI4DDxYZMP8AS4Jsu9VeDnZa3UQKcD/ycUYwPgSML3P+cDtykT5NMT/3Aea5O6B0phWb/ZBRD3gujqx5P1Ghg8LUc1vzXVz2W6AGO0GRNFr4AjneRA+ypwcZrgbOS5mby6l6VeE0WJAs4xsVfVDddA4nb8n2WhUkaRy7JIMSm4bmFWAGe6TBOWdVdGXpvxZoooqAeABd6jFciDHu4ogEeTSGGrPX3djWBoWWzDxNDK7mU8MbdkjtwNQL/GN2MMpw5RJer3ZDKjLNdDQG+9BRkdlkO3dLFkbckIOhqCqEJok5NalHBt0HTmnEk9+skiDq2q1YUTtaA3u6uARCqIE0FEyQsTJDAaIwgDFWWS/X7B5pYegO4ofSAXRcaIYiWlq5rM7CVIe30ay+I5lZ+6jK4V1wgNEEQ3yOTTnEB0ARB3vYc4J0uAJogyOcxDZAGCCLpXB/muAAwQbZigtTpCWGobUCqIhcAD0pRQko7NmVlEUSDoFLF2IqBpEFREyS7IC/SmUETpKQpCzjT03ZP9FOWtglcJ/sDzYmMDVCQfk/b86MVRBse723R8y2dtQ8kzRgWLMgiT9uDMQvSn9fdVoIgSzxtL49SEKnH9ax2PzWBTRMkLcB9ed/NJkgGgOc8BVmawKY9IWkBFnsKsiKBTRMkLSaIC+6lbk8IJsgWbNlrT8j/sSdkK/aEtLg7JJeQdyhCTiH1YWaB/g4U4G8p/SEzPZ15JIFN3zMMbyzwb/IeSmDzpWD+Nk9CIp7OeJ+SAFztYe8v4IAU/p7s6a/3kXzS0Olhb2O7k1FzR09e6MRAkpN1tNX69S42p2bw97EuthekiHZ3OzSh15UFMAp4uo0ji9P0oOup1kvb9ClOy9KnKH8ULFNom0No5DDLUSlsjtF++1ZPRnliDHPqJA02PqlF0hNymhL75HhWPRT54Hy8/c/2MXps+Vzt9BqXU/S7V3+HSaVNU4ZhGIZhGIZhGIZhGIbhquVfiiAaCf/Kq/8AAAAASUVORK5CYII=&labelColor=35B9D2&color=6A6A6A">
    </a>
</p>

<p align="center">
  <a href="https://github.com/uptrain-ai/uptrain/releases">
    <img alt="GitHub Release" src="https://img.shields.io/github/v/release/uptrain-ai/uptrain?labelColor=6A6A6A&color=CC766E">
  </a>
  <a href="https://github.com/uptrain-ai/uptrain/graphs/commit-activity">
    <img alt="GitHub commit activity" src="https://img.shields.io/github/commit-activity/m/uptrain-ai/uptrain?labelColor=6A6A6A&color=976DA5">
  </a>
  <a href="https://github.com/uptrain-ai/uptrain/blob/main/LICENSE">
    <img alt="GitHub License" src="https://img.shields.io/github/license/uptrain-ai/uptrain?labelColor=6A6A6A&color=6565d8">
  </a>
  <a href="https://pypistats.org/packages/uptrain">
    <img alt="PyPI - Downloads" src="https://img.shields.io/pypi/dm/uptrain?labelColor=6A6A6A&color=3E93C4">
  </a>
</p>

<h4 align="center">
  <video src="https://github.com/uptrain-ai/uptrain/assets/43818888/68a3b169-2217-446b-93b2-96b48ec7201d" alt="Demo of UpTrain's LLM evaluations with scores for hallucinations, retrieved-context quality, response tonality for a customer support chatbot" autoplay>
</h4>


**[UpTrain](https://uptrain.ai)** is an open-source unified platform to evaluate and improve Generative AI applications. We provide grades for [20+ preconfigured evaluations](https://github.com/uptrain-ai/uptrain?tab=readme-ov-file#pre-built-evaluations-we-offer-) (covering language, code, embedding use cases), perform [root cause analysis](https://github.com/uptrain-ai/uptrain/blob/main/examples/root_cause_analysis/rag_with_citation.ipynb) on failure cases and give insights on how to resolve them.    

<br />

# Key Features 🔑

<img width="1088" alt="Interactive Dashboards" src="https://github.com/uptrain-ai/uptrain/assets/36454110/eb1c8239-dd99-4e66-ba8a-cbaee2beec10">

UpTrain Dashboard is a web-based interface that runs on your **local machine**. You can use the dashboard to evaluate your LLM applications, view the results, and perform a root cause analysis.

<img width="1088" alt="20+ Pre-configured Evaluations" src="https://github.com/uptrain-ai/uptrain/assets/43818888/2700fe70-1ff6-4fa8-b85d-320e6245852f">

Support for **20+ pre-configured evaluations** such as Response Completeness, Factual Accuracy, Context Conciseness etc.

<img width="1088" alt="Data Security" src="https://github.com/uptrain-ai/uptrain/assets/43818888/7b737bfc-b061-4f87-b51e-5bad67879332">

All the evaluations and analysis run locally on your system, ensuring that the data never leaves your secure environment (except for LLM calls while using model grading checks)

<img width="1088" alt="Experimentation" src="https://github.com/uptrain-ai/uptrain/assets/43818888/fd9c5c7f-3951-4d69-9b77-4fece6ff0830">

**Experiment with different embedding models** like text-embedding-3-large/small, text-embedding-3-ada, baai/bge-large, etc. UpTrain supports HuggingFace models, Replicate endpoints, or custom models hosted on your endpoint.

<img width="1088" alt="Root Cause Analysis" src="https://github.com/uptrain-ai/uptrain/assets/43818888/32df049c-c0a4-4377-a807-f74e2efa57b5">

You can **perform root cause analysis** on cases with either negative user feedback or low evaluation scores to understand which part of your LLM pipeline is giving suboptimal results. Check out the supported RCA templates.

<img width="1088" alt="Select from a Variety of Evaluation LLMs" src="https://github.com/uptrain-ai/uptrain/assets/43818888/4c778006-5f93-4901-8ab8-620d908a7003">

We allow you to use any of OpenAI, Anthropic, Mistral, Azure's Openai endpoints or open-source LLMs hosted on Anyscale to be used as evaluators.

<img width="1088" alt="Customize Evaluations" src="https://github.com/uptrain-ai/uptrain/assets/43818888/167488ec-9feb-48a7-9659-7bb9478584f9">

UpTrain provides tons of ways to **customize evaluations**. You can customize the evaluation method (chain of thought vs classify), few-shot examples, and scenario description. You can also create custom evaluators.

### Coming Soon:

1. Collaborate with your team
2. Embedding visualization via UMAP and Clustering
3. Pattern recognition among failure cases
4. Prompt improvement suggestions

<br />


# Getting Started 🙌

## Method 1: Using the Locally Hosted Dashboard

The UpTrain dashboard is a web-based interface that allows you to evaluate your LLM applications. It is a self-hosted dashboard that runs on your local machine.
You don't need to write any code to use the dashboard. You can use the dashboard to evaluate your LLM applications, view the results, and perform a root cause analysis.

Before you start, ensure you have docker installed on your machine. If not, you can install it from [here](https://docs.docker.com/get-docker/).

The following commands will download the UpTrain dashboard and start it on your local machine.

```bash
# Clone the repository
git clone https://github.com/uptrain-ai/uptrain
cd uptrain

# Run UpTrain
bash run_uptrain.sh
```
> **NOTE:**  UpTrain Dashboard is currently in **Beta version**. We would love your feedback to improve it.

## Method 2: Using the UpTrain package

If you are a developer and want to integrate UpTrain evaluations into your application, you can use the UpTrain package. This allows for a more programmatic way to evaluate your LLM applications.

### Install the package through pip:
```bash
pip install uptrain
```

### How to use UpTrain:

You can evaluate your responses via the open-source version by providing your OpenAI API key to run evaluations.

```python
from uptrain import EvalLLM, Evals
import json

OPENAI_API_KEY = "sk-***************"

data = [{
    'question': 'Which is the most popular global sport?',
    'context': "The popularity of sports can be measured in various ways, including TV viewership, social media presence, number of participants, and economic impact. Football is undoubtedly the world's most popular sport with major events like the FIFA World Cup and sports personalities like Ronaldo and Messi, drawing a followership of more than 4 billion people. Cricket is particularly popular in countries like India, Pakistan, Australia, and England. The ICC Cricket World Cup and Indian Premier League (IPL) have substantial viewership. The NBA has made basketball popular worldwide, especially in countries like the USA, Canada, China, and the Philippines. Major tennis tournaments like Wimbledon, the US Open, French Open, and Australian Open have large global audiences. Players like Roger Federer, Serena Williams, and Rafael Nadal have boosted the sport's popularity. Field Hockey is very popular in countries like India, Netherlands, and Australia. It has a considerable following in many parts of the world.",
    'response': 'Football is the most popular sport with around 4 billion followers worldwide'
}]

eval_llm = EvalLLM(openai_api_key=OPENAI_API_KEY)

results = eval_llm.evaluate(
    data=data,
    checks=[Evals.CONTEXT_RELEVANCE, Evals.FACTUAL_ACCURACY, Evals.RESPONSE_COMPLETENESS]
)

print(json.dumps(results, indent=3))
```
If you have any questions, please join our [Slack community](https://join.slack.com/t/uptraincommunity/shared_invite/zt-1yih3aojn-CEoR_gAh6PDSknhFmuaJeg)

Speak directly with the maintainers of UpTrain by [booking a call here](https://calendly.com/uptrain-sourabh/30min).

<br />


# Pre-built Evaluations We Offer 📝
<img width="1088" alt="quality of your responses" src="https://github.com/uptrain-ai/uptrain/assets/43818888/654b2289-2799-4310-84be-fcdd071f3e2e">

| Eval | Description |
| ---- | ----------- |
|[Response Completeness](https://docs.uptrain.ai/predefined-evaluations/response-quality/response-completeness) | Grades whether the response has answered all the aspects of the question specified. |
|[Response Conciseness](https://docs.uptrain.ai/predefined-evaluations/response-quality/response-conciseness) | Grades how concise the generated response is or if it has any additional irrelevant information for the question asked. |
|[Response Relevance](https://docs.uptrain.ai/predefined-evaluations/response-quality/response-relevance)| Grades how relevant the generated context was to the question specified.|
|[Response Validity](https://docs.uptrain.ai/predefined-evaluations/response-quality/response-validity)| Grades if the response generated is valid or not. A response is considered to be valid if it contains any information.|
|[Response Consistency](https://docs.uptrain.ai/predefined-evaluations/response-quality/response-consistency)| Grades how consistent the response is with the question asked as well as with the context provided.|

<img width="1088" alt="quality of retrieved context and response groundedness" src="https://github.com/uptrain-ai/uptrain/assets/43818888/a7e384a3-c857-4a71-a938-7a2a70f8db1e">


| Eval | Description |
| ---- | ----------- |
|[Context Relevance](https://docs.uptrain.ai/predefined-evaluations/context-awareness/context-relevance) | Grades how relevant the context was to the question specified. |
|[Context Utilization](https://docs.uptrain.ai/predefined-evaluations/context-awareness/context-utilization) | Grades how complete the generated response was for the question specified, given the information provided in the context. |
|[Factual Accuracy](https://docs.uptrain.ai/predefined-evaluations/context-awareness/factual-accuracy)| Grades whether the response generated is factually correct and grounded by the provided context.|
|[Context Conciseness](https://docs.uptrain.ai/predefined-evaluations/context-awareness/context-conciseness)| Evaluates the concise context cited from an original context for irrelevant information.
|[Context Reranking](https://docs.uptrain.ai/predefined-evaluations/context-awareness/context-reranking)| Evaluates how efficient the reranked context is compared to the original context.|

<img width="1088" alt="language quality of the response" src="https://github.com/uptrain-ai/uptrain/assets/43818888/776cbc6d-bb4c-4ed1-a892-7a1df38d12d5">

| Eval | Description |
| ---- | ----------- |
|[Language Features](https://docs.uptrain.ai/predefined-evaluations/language-quality/fluency-and-coherence) | Grades the quality and effectiveness of language in a response, focusing on factors such as clarity, coherence, conciseness, and overall communication. |
|[Tonality](https://docs.uptrain.ai/predefined-evaluations/code-evals/code-hallucination) | Grades whether the generated response matches the required persona's tone  |

<img width="1088" alt="language quality of the response" src="https://github.com/uptrain-ai/uptrain/assets/36454110/2fba9f0b-71b3-4d90-90f8-16ef38cef3ab">

| Eval | Description |
| ---- | ----------- |
|[Code Hallucination](https://docs.uptrain.ai/predefined-evaluations/code-evals/code-hallucination) | Grades whether the code present in the generated response is grounded by the context. |

<img width="1088" alt="conversation as a whole" src="https://github.com/uptrain-ai/uptrain/assets/43818888/194f8dd7-26ca-48eb-bdff-028212db9e25">

| Eval | Description |
| ---- | ----------- |
|[User Satisfaction](https://docs.uptrain.ai/predefined-evaluations/conversation-evals/user-satisfaction) | Grades how well the user's concerns are addressed and assesses their satisfaction based on provided conversation. |

<img width="1088" alt="custom evaluations and others" src="https://github.com/uptrain-ai/uptrain/assets/43818888/0bbc2d82-0f96-49ab-969c-4eec29fef988">

 Eval | Description |
| ---- | ----------- |
|[Custom Guideline](https://docs.uptrain.ai/predefined-evaluations/custom-evals/custom-guideline) | Allows you to specify a guideline and grades how well the LLM adheres to the provided guideline when giving a response. |
|[Custom Prompts](https://docs.uptrain.ai/predefined-evaluations/custom-evals/custom-prompt-eval) | Allows you to create your own set of evaluations. |

<img width="1088" alt="compare responses with ground truth" src="https://github.com/uptrain-ai/uptrain/assets/36454110/e3ee22f4-9984-47a5-a7d2-9d8688a090fb">

| Eval | Description |
| ---- | ----------- |
|[Response Matching](https://docs.uptrain.ai/predefined-evaluations/ground-truth-comparison/response-matching) | Compares and grades how well the response generated by the LLM aligns with the provided ground truth. |

<img width="1088" alt="safeguard system prompts and avoid LLM mis-use" src="https://github.com/uptrain-ai/uptrain/assets/43818888/4fcdb1e8-f356-443b-88f0-94146e08829e">

| Eval | Description |
| ---- | ----------- |
|[Prompt Injection](https://docs.uptrain.ai/predefined-evaluations/safeguarding/prompt-injection) | Grades whether the user's prompt is an attempt to make the LLM reveal its system prompts. |
|[Jailbreak Detection](https://docs.uptrain.ai/predefined-evaluations/safeguarding/jailbreak) | Grades whether the user's prompt is an attempt to jailbreak (i.e. generate illegal or harmful responses). |

<img width="1088" alt="evaluate the clarity of user queries" src="https://github.com/uptrain-ai/uptrain/assets/36454110/50ed622f-0b92-468c-af48-2391ff6ab8e0">

| Eval | Description |
| ---- | ----------- |
|[Sub-Query Completeness](https://docs.uptrain.ai/predefined-evaluations/query-quality/sub-query-completeness) | Evaluate whether all of the sub-questions generated from a user's query, taken together, cover all aspects of the user's query or not |
| [Multi-Query Accuracy](https://docs.uptrain.ai/predefined-evaluations/query-quality/multi-query-accuracy) | Evaluate whether the variants generated accurately represent the original query |


<br />

# Integrations 🤝

| Eval Frameworks  | LLM Providers | LLM Packages | Serving frameworks | LLM Observability | Vector DBs |
| ------------- | ------------- | ------------- | ------------- | ------------- |  ------------- |
| [OpenAI Evals](https://docs.uptrain.ai/tutorials/openai-evals) | [OpenAI](https://docs.uptrain.ai/llms/openai) | [LlamaIndex](https://docs.uptrain.ai/integrations/framework/llamaindex-methods/overview) | [Ollama](https://docs.uptrain.ai/llms/ollama) | [Langfuse](https://docs.uptrain.ai/integrations/observation-tools/langfuse) | [Qdrant](https://docs.uptrain.ai/integrations/vector_db/qdrant) |
| | [Azure](https://docs.uptrain.ai/llms/azure) | |  [Together AI](https://docs.uptrain.ai/llms/together_ai) | [Helicone](https://docs.uptrain.ai/integrations/observation-tools/helicone) | [FAISS](https://docs.uptrain.ai/integrations/vector_db/faiss) |
| | [Claude](https://docs.uptrain.ai/llms/claude) | |  [Anyscale](https://docs.uptrain.ai/llms/anyscale) | [Zeno](https://docs.uptrain.ai/integrations/observation-tools/zeno) | [Chroma](https://docs.uptrain.ai/integrations/vector_db/chroma) |
| | [Mistral](https://docs.uptrain.ai/llms/mistral) | | Replicate  |
| |  | |  HuggingFace  |

More integrations are coming soon. If you have a specific integration in mind, please let us know by [creating an issue](https://github.com/uptrain-ai/uptrain/issues).

<br />

# Monitoring Prompt Drift in LLMs: Benchmark by UpTrain

Most popular LLMs like GPT-4, GPT-3.5-turbo, Claude-2.1 etc., are closed-source, i.e. exposed via an API with very little visibility on what happens under the hood. There are many reported instances of prompt drift (or GPT-4 becoming lazy) and research work exploring the degradation in model quality. This benchmark is an attempt to track the change in model behaviour by evaluating its response on a fixed dataset.

<img width="1316" alt="image" src="https://github.com/uptrain-ai/uptrain/assets/43818888/65b7e8c3-3f5e-48bb-98c1-88208520945b">

You can find the benchmark [here](https://demo.uptrain.ai/benchmark).


# Resources 💡

1. [How to evaluate your LLM application](https://blog.uptrain.ai/how-to-evaluate-your-llm-applications)
1. [How to detect jailbreaks](https://blog.uptrain.ai/llm-jailbreak/)
1. [Dealing with hallucinations](https://blog.uptrain.ai/dealing-with-hallucinations-in-llms-a-deep-dive/)

<br />

# Why we are building UpTrain 🤔

Having worked with ML and NLP models for the last 8 years, we were continuosly frustated with numerous hidden failures in our models which led to us building UpTrain. UpTrain was initially started as an ML observability tool with checks to identify regression in accuracy. 

However we soon released that LLM developers face an even bigger problem -- there is no good way to measure accuracy of their LLM applications, let alone identify regression.

We also saw release of [OpenAI evals](https://github.com/openai/evals), where they proposed the use of LLMs to grade the model responses. Furthermore, we gained confidence to approach this after reading [how Anthropic leverages RLAIF](https://arxiv.org/pdf/2212.08073.pdf) and dived right into the LLM evaluations research (We are soon releasing a repository of awesome evaluations research). 

So, come today, UpTrain is our attempt to bring order to LLM chaos and contribute back to the community. While a majority of developers still rely on intuition and productionise prompt changes by reviewing a couple of cases, we have heard enough regression stories to believe "evaluations and improvement" will be a key part of LLM ecosystem as the space matures.

1. Robust evaluations allows you to systematically experiment with different configurations and prevent any regressions by helping objectively select the best choice.

1. It helps you understand where your systems are going wrong, find the root cause(s) and fix them - long before your end users complain and potentially churn out.

1. Evaluations like prompt injection and jailbreak detection are essential to maintain safety and security of your LLM applications.

1. Evaluations help you provide transparency and build trust with your end-users - especially relevant if you are selling to enterprises.

<br />

# Why open-source? 

1. We understand that there is **no one-size-fits-all solution** when it come to evaluations. We are increasingly seeing the desire from developers to modify the evaluation prompt or set of choices or the few shot examples, etc. We believe the best developer experience lies in open-source, instead of exposing 20 different parameters.

1. **Foster innovation**: The field of LLM evaluations and using LLM-as-a-judge is still pretty nascent. We see a lot of exciting research happening, almost on a daily basis and being open-source provides the right platform to us and our community to implement those techniques and innovate faster.

<br />

## How You Can Help 🙏

We are continuously striving to enhance UpTrain, and there are several ways you can contribute:

1. **Notice any issues or areas for improvement:** If you spot anything wrong or have ideas for enhancements, please [create an issue](https://github.com/uptrain-ai/uptrain/issues) on our GitHub repository.

1. **Contribute directly:** If you see an issue you can fix or have code improvements to suggest, feel free to contribute directly to the [repository](https://github.com/uptrain-ai/uptrain/blob/main/CONTRIBUTING.md).

1. **Request custom evaluations:** If your application requires a tailored evaluation, [let us know]((https://join.slack.com/t/uptraincommunity/shared_invite/zt-1yih3aojn-CEoR_gAh6PDSknhFmuaJeg)), and we'll add it to the repository.

1. **Integrate with your tools:** Need integration with your existing tools? [Reach out]((https://join.slack.com/t/uptraincommunity/shared_invite/zt-1yih3aojn-CEoR_gAh6PDSknhFmuaJeg)), and we'll work on it.

1. **Assistance with evaluations:** If you need assistance with evaluations, post your query on our [Slack channel](https://join.slack.com/t/uptraincommunity/shared_invite/zt-1yih3aojn-CEoR_gAh6PDSknhFmuaJeg), and we'll resolve it promptly.

1. **Show your support:** Show your support by starring us ⭐ on GitHub to track our progress.

1. **Spread the word:** If you like what we've built, give us a shoutout on Twitter!

Your contributions and support are greatly appreciated! Thank you for being a part of UpTrain's journey.

<br />

# License 💻

This repo is published under Apache 2.0 license and we are committed to adding more functionalities to the UpTrain open-source repo. We also have a managed version if you just want a more hands-off experience. Please book a [demo call here](https://calendly.com/uptrain-sourabh/30min).

<br />

# Provide feedback (Harsher the better 😉) 

We are building UpTrain in public. Help us improve by giving your feedback **[here](https://docs.google.com/forms/d/e/1FAIpQLSezGUkkC0JoEvx-0gCrRSmGutA-jqyb7kl2lomXv302_C3MnQ/viewform?usp=sf_link)**.

<br />

# Contributors 🖥️

We welcome contributions to UpTrain. Please see our [contribution guide](https://github.com/uptrain-ai/uptrain/blob/main/CONTRIBUTING.md) for details.

<a href="https://github.com/uptrain-ai/uptrain/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=uptrain-ai/uptrain" />
</a>
