'''
# `vsphere_vnic`

Refer to the Terraform Registory for docs: [`vsphere_vnic`](https://www.terraform.io/docs/providers/vsphere/r/vnic).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf
import constructs


class Vnic(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-vsphere.vnic.Vnic",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/vnic vsphere_vnic}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id_: builtins.str,
        *,
        host: builtins.str,
        distributed_port_group: typing.Optional[builtins.str] = None,
        distributed_switch_port: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        ipv4: typing.Optional[typing.Union["VnicIpv4", typing.Dict[str, typing.Any]]] = None,
        ipv6: typing.Optional[typing.Union["VnicIpv6", typing.Dict[str, typing.Any]]] = None,
        mac: typing.Optional[builtins.str] = None,
        mtu: typing.Optional[jsii.Number] = None,
        netstack: typing.Optional[builtins.str] = None,
        portgroup: typing.Optional[builtins.str] = None,
        connection: typing.Optional[typing.Union[typing.Union[cdktf.SSHProvisionerConnection, typing.Dict[str, typing.Any]], typing.Union[cdktf.WinrmProvisionerConnection, typing.Dict[str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        for_each: typing.Optional[cdktf.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[cdktf.TerraformResourceLifecycle, typing.Dict[str, typing.Any]]] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[cdktf.FileProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.LocalExecProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.RemoteExecProvisioner, typing.Dict[str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/vnic vsphere_vnic} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param host: ESX host the interface belongs to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#host Vnic#host}
        :param distributed_port_group: Key of the distributed portgroup the nic will connect to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#distributed_port_group Vnic#distributed_port_group}
        :param distributed_switch_port: UUID of the DVSwitch the nic will be attached to. Do not set if you set portgroup. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#distributed_switch_port Vnic#distributed_switch_port}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#id Vnic#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param ipv4: ipv4 block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#ipv4 Vnic#ipv4}
        :param ipv6: ipv6 block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#ipv6 Vnic#ipv6}
        :param mac: MAC address of the interface. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#mac Vnic#mac}
        :param mtu: MTU of the interface. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#mtu Vnic#mtu}
        :param netstack: TCP/IP stack setting for this interface. Possible values are 'defaultTcpipStack', 'vmotion', 'provisioning'. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#netstack Vnic#netstack}
        :param portgroup: portgroup to attach the nic to. Do not set if you set distributed_switch_port. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#portgroup Vnic#portgroup}
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(Vnic.__init__)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = VnicConfig(
            host=host,
            distributed_port_group=distributed_port_group,
            distributed_switch_port=distributed_switch_port,
            id=id,
            ipv4=ipv4,
            ipv6=ipv6,
            mac=mac,
            mtu=mtu,
            netstack=netstack,
            portgroup=portgroup,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="putIpv4")
    def put_ipv4(
        self,
        *,
        dhcp: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        gw: typing.Optional[builtins.str] = None,
        ip: typing.Optional[builtins.str] = None,
        netmask: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param dhcp: Use DHCP to configure the interface's IPv4 stack. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#dhcp Vnic#dhcp}
        :param gw: IP address of the default gateway, if DHCP is not set. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#gw Vnic#gw}
        :param ip: address of the interface, if DHCP is not set. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#ip Vnic#ip}
        :param netmask: netmask of the interface, if DHCP is not set. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#netmask Vnic#netmask}
        '''
        value = VnicIpv4(dhcp=dhcp, gw=gw, ip=ip, netmask=netmask)

        return typing.cast(None, jsii.invoke(self, "putIpv4", [value]))

    @jsii.member(jsii_name="putIpv6")
    def put_ipv6(
        self,
        *,
        addresses: typing.Optional[typing.Sequence[builtins.str]] = None,
        autoconfig: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        dhcp: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        gw: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param addresses: List of IPv6 addresses. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#addresses Vnic#addresses}
        :param autoconfig: Use IPv6 Autoconfiguration (RFC2462). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#autoconfig Vnic#autoconfig}
        :param dhcp: Use DHCP to configure the interface's IPv4 stack. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#dhcp Vnic#dhcp}
        :param gw: IP address of the default gateway, if DHCP or autoconfig is not set. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#gw Vnic#gw}
        '''
        value = VnicIpv6(addresses=addresses, autoconfig=autoconfig, dhcp=dhcp, gw=gw)

        return typing.cast(None, jsii.invoke(self, "putIpv6", [value]))

    @jsii.member(jsii_name="resetDistributedPortGroup")
    def reset_distributed_port_group(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDistributedPortGroup", []))

    @jsii.member(jsii_name="resetDistributedSwitchPort")
    def reset_distributed_switch_port(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDistributedSwitchPort", []))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetIpv4")
    def reset_ipv4(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIpv4", []))

    @jsii.member(jsii_name="resetIpv6")
    def reset_ipv6(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIpv6", []))

    @jsii.member(jsii_name="resetMac")
    def reset_mac(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMac", []))

    @jsii.member(jsii_name="resetMtu")
    def reset_mtu(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMtu", []))

    @jsii.member(jsii_name="resetNetstack")
    def reset_netstack(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNetstack", []))

    @jsii.member(jsii_name="resetPortgroup")
    def reset_portgroup(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPortgroup", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="ipv4")
    def ipv4(self) -> "VnicIpv4OutputReference":
        return typing.cast("VnicIpv4OutputReference", jsii.get(self, "ipv4"))

    @builtins.property
    @jsii.member(jsii_name="ipv6")
    def ipv6(self) -> "VnicIpv6OutputReference":
        return typing.cast("VnicIpv6OutputReference", jsii.get(self, "ipv6"))

    @builtins.property
    @jsii.member(jsii_name="distributedPortGroupInput")
    def distributed_port_group_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "distributedPortGroupInput"))

    @builtins.property
    @jsii.member(jsii_name="distributedSwitchPortInput")
    def distributed_switch_port_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "distributedSwitchPortInput"))

    @builtins.property
    @jsii.member(jsii_name="hostInput")
    def host_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "hostInput"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="ipv4Input")
    def ipv4_input(self) -> typing.Optional["VnicIpv4"]:
        return typing.cast(typing.Optional["VnicIpv4"], jsii.get(self, "ipv4Input"))

    @builtins.property
    @jsii.member(jsii_name="ipv6Input")
    def ipv6_input(self) -> typing.Optional["VnicIpv6"]:
        return typing.cast(typing.Optional["VnicIpv6"], jsii.get(self, "ipv6Input"))

    @builtins.property
    @jsii.member(jsii_name="macInput")
    def mac_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "macInput"))

    @builtins.property
    @jsii.member(jsii_name="mtuInput")
    def mtu_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "mtuInput"))

    @builtins.property
    @jsii.member(jsii_name="netstackInput")
    def netstack_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "netstackInput"))

    @builtins.property
    @jsii.member(jsii_name="portgroupInput")
    def portgroup_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "portgroupInput"))

    @builtins.property
    @jsii.member(jsii_name="distributedPortGroup")
    def distributed_port_group(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "distributedPortGroup"))

    @distributed_port_group.setter
    def distributed_port_group(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(Vnic, "distributed_port_group").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "distributedPortGroup", value)

    @builtins.property
    @jsii.member(jsii_name="distributedSwitchPort")
    def distributed_switch_port(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "distributedSwitchPort"))

    @distributed_switch_port.setter
    def distributed_switch_port(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(Vnic, "distributed_switch_port").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "distributedSwitchPort", value)

    @builtins.property
    @jsii.member(jsii_name="host")
    def host(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "host"))

    @host.setter
    def host(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(Vnic, "host").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "host", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(Vnic, "id").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="mac")
    def mac(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "mac"))

    @mac.setter
    def mac(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(Vnic, "mac").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "mac", value)

    @builtins.property
    @jsii.member(jsii_name="mtu")
    def mtu(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "mtu"))

    @mtu.setter
    def mtu(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(Vnic, "mtu").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "mtu", value)

    @builtins.property
    @jsii.member(jsii_name="netstack")
    def netstack(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "netstack"))

    @netstack.setter
    def netstack(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(Vnic, "netstack").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "netstack", value)

    @builtins.property
    @jsii.member(jsii_name="portgroup")
    def portgroup(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "portgroup"))

    @portgroup.setter
    def portgroup(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(Vnic, "portgroup").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "portgroup", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-vsphere.vnic.VnicConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "host": "host",
        "distributed_port_group": "distributedPortGroup",
        "distributed_switch_port": "distributedSwitchPort",
        "id": "id",
        "ipv4": "ipv4",
        "ipv6": "ipv6",
        "mac": "mac",
        "mtu": "mtu",
        "netstack": "netstack",
        "portgroup": "portgroup",
    },
)
class VnicConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[cdktf.SSHProvisionerConnection, typing.Dict[str, typing.Any]], typing.Union[cdktf.WinrmProvisionerConnection, typing.Dict[str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        for_each: typing.Optional[cdktf.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[cdktf.TerraformResourceLifecycle, typing.Dict[str, typing.Any]]] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[cdktf.FileProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.LocalExecProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.RemoteExecProvisioner, typing.Dict[str, typing.Any]]]]] = None,
        host: builtins.str,
        distributed_port_group: typing.Optional[builtins.str] = None,
        distributed_switch_port: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        ipv4: typing.Optional[typing.Union["VnicIpv4", typing.Dict[str, typing.Any]]] = None,
        ipv6: typing.Optional[typing.Union["VnicIpv6", typing.Dict[str, typing.Any]]] = None,
        mac: typing.Optional[builtins.str] = None,
        mtu: typing.Optional[jsii.Number] = None,
        netstack: typing.Optional[builtins.str] = None,
        portgroup: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param host: ESX host the interface belongs to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#host Vnic#host}
        :param distributed_port_group: Key of the distributed portgroup the nic will connect to. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#distributed_port_group Vnic#distributed_port_group}
        :param distributed_switch_port: UUID of the DVSwitch the nic will be attached to. Do not set if you set portgroup. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#distributed_switch_port Vnic#distributed_switch_port}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#id Vnic#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param ipv4: ipv4 block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#ipv4 Vnic#ipv4}
        :param ipv6: ipv6 block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#ipv6 Vnic#ipv6}
        :param mac: MAC address of the interface. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#mac Vnic#mac}
        :param mtu: MTU of the interface. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#mtu Vnic#mtu}
        :param netstack: TCP/IP stack setting for this interface. Possible values are 'defaultTcpipStack', 'vmotion', 'provisioning'. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#netstack Vnic#netstack}
        :param portgroup: portgroup to attach the nic to. Do not set if you set distributed_switch_port. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#portgroup Vnic#portgroup}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(ipv4, dict):
            ipv4 = VnicIpv4(**ipv4)
        if isinstance(ipv6, dict):
            ipv6 = VnicIpv6(**ipv6)
        if __debug__:
            type_hints = typing.get_type_hints(VnicConfig.__init__)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument distributed_port_group", value=distributed_port_group, expected_type=type_hints["distributed_port_group"])
            check_type(argname="argument distributed_switch_port", value=distributed_switch_port, expected_type=type_hints["distributed_switch_port"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument ipv4", value=ipv4, expected_type=type_hints["ipv4"])
            check_type(argname="argument ipv6", value=ipv6, expected_type=type_hints["ipv6"])
            check_type(argname="argument mac", value=mac, expected_type=type_hints["mac"])
            check_type(argname="argument mtu", value=mtu, expected_type=type_hints["mtu"])
            check_type(argname="argument netstack", value=netstack, expected_type=type_hints["netstack"])
            check_type(argname="argument portgroup", value=portgroup, expected_type=type_hints["portgroup"])
        self._values: typing.Dict[str, typing.Any] = {
            "host": host,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if distributed_port_group is not None:
            self._values["distributed_port_group"] = distributed_port_group
        if distributed_switch_port is not None:
            self._values["distributed_switch_port"] = distributed_switch_port
        if id is not None:
            self._values["id"] = id
        if ipv4 is not None:
            self._values["ipv4"] = ipv4
        if ipv6 is not None:
            self._values["ipv6"] = ipv6
        if mac is not None:
            self._values["mac"] = mac
        if mtu is not None:
            self._values["mtu"] = mtu
        if netstack is not None:
            self._values["netstack"] = netstack
        if portgroup is not None:
            self._values["portgroup"] = portgroup

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[cdktf.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[cdktf.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]], result)

    @builtins.property
    def host(self) -> builtins.str:
        '''ESX host the interface belongs to.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#host Vnic#host}
        '''
        result = self._values.get("host")
        assert result is not None, "Required property 'host' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def distributed_port_group(self) -> typing.Optional[builtins.str]:
        '''Key of the distributed portgroup the nic will connect to.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#distributed_port_group Vnic#distributed_port_group}
        '''
        result = self._values.get("distributed_port_group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def distributed_switch_port(self) -> typing.Optional[builtins.str]:
        '''UUID of the DVSwitch the nic will be attached to. Do not set if you set portgroup.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#distributed_switch_port Vnic#distributed_switch_port}
        '''
        result = self._values.get("distributed_switch_port")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#id Vnic#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ipv4(self) -> typing.Optional["VnicIpv4"]:
        '''ipv4 block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#ipv4 Vnic#ipv4}
        '''
        result = self._values.get("ipv4")
        return typing.cast(typing.Optional["VnicIpv4"], result)

    @builtins.property
    def ipv6(self) -> typing.Optional["VnicIpv6"]:
        '''ipv6 block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#ipv6 Vnic#ipv6}
        '''
        result = self._values.get("ipv6")
        return typing.cast(typing.Optional["VnicIpv6"], result)

    @builtins.property
    def mac(self) -> typing.Optional[builtins.str]:
        '''MAC address of the interface.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#mac Vnic#mac}
        '''
        result = self._values.get("mac")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def mtu(self) -> typing.Optional[jsii.Number]:
        '''MTU of the interface.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#mtu Vnic#mtu}
        '''
        result = self._values.get("mtu")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def netstack(self) -> typing.Optional[builtins.str]:
        '''TCP/IP stack setting for this interface. Possible values are 'defaultTcpipStack', 'vmotion', 'provisioning'.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#netstack Vnic#netstack}
        '''
        result = self._values.get("netstack")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def portgroup(self) -> typing.Optional[builtins.str]:
        '''portgroup to attach the nic to. Do not set if you set distributed_switch_port.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#portgroup Vnic#portgroup}
        '''
        result = self._values.get("portgroup")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VnicConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-vsphere.vnic.VnicIpv4",
    jsii_struct_bases=[],
    name_mapping={"dhcp": "dhcp", "gw": "gw", "ip": "ip", "netmask": "netmask"},
)
class VnicIpv4:
    def __init__(
        self,
        *,
        dhcp: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        gw: typing.Optional[builtins.str] = None,
        ip: typing.Optional[builtins.str] = None,
        netmask: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param dhcp: Use DHCP to configure the interface's IPv4 stack. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#dhcp Vnic#dhcp}
        :param gw: IP address of the default gateway, if DHCP is not set. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#gw Vnic#gw}
        :param ip: address of the interface, if DHCP is not set. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#ip Vnic#ip}
        :param netmask: netmask of the interface, if DHCP is not set. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#netmask Vnic#netmask}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(VnicIpv4.__init__)
            check_type(argname="argument dhcp", value=dhcp, expected_type=type_hints["dhcp"])
            check_type(argname="argument gw", value=gw, expected_type=type_hints["gw"])
            check_type(argname="argument ip", value=ip, expected_type=type_hints["ip"])
            check_type(argname="argument netmask", value=netmask, expected_type=type_hints["netmask"])
        self._values: typing.Dict[str, typing.Any] = {}
        if dhcp is not None:
            self._values["dhcp"] = dhcp
        if gw is not None:
            self._values["gw"] = gw
        if ip is not None:
            self._values["ip"] = ip
        if netmask is not None:
            self._values["netmask"] = netmask

    @builtins.property
    def dhcp(self) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Use DHCP to configure the interface's IPv4 stack.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#dhcp Vnic#dhcp}
        '''
        result = self._values.get("dhcp")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def gw(self) -> typing.Optional[builtins.str]:
        '''IP address of the default gateway, if DHCP is not set.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#gw Vnic#gw}
        '''
        result = self._values.get("gw")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ip(self) -> typing.Optional[builtins.str]:
        '''address of the interface, if DHCP is not set.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#ip Vnic#ip}
        '''
        result = self._values.get("ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def netmask(self) -> typing.Optional[builtins.str]:
        '''netmask of the interface, if DHCP is not set.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#netmask Vnic#netmask}
        '''
        result = self._values.get("netmask")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VnicIpv4(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VnicIpv4OutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-vsphere.vnic.VnicIpv4OutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(VnicIpv4OutputReference.__init__)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetDhcp")
    def reset_dhcp(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDhcp", []))

    @jsii.member(jsii_name="resetGw")
    def reset_gw(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGw", []))

    @jsii.member(jsii_name="resetIp")
    def reset_ip(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIp", []))

    @jsii.member(jsii_name="resetNetmask")
    def reset_netmask(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNetmask", []))

    @builtins.property
    @jsii.member(jsii_name="dhcpInput")
    def dhcp_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "dhcpInput"))

    @builtins.property
    @jsii.member(jsii_name="gwInput")
    def gw_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "gwInput"))

    @builtins.property
    @jsii.member(jsii_name="ipInput")
    def ip_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "ipInput"))

    @builtins.property
    @jsii.member(jsii_name="netmaskInput")
    def netmask_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "netmaskInput"))

    @builtins.property
    @jsii.member(jsii_name="dhcp")
    def dhcp(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "dhcp"))

    @dhcp.setter
    def dhcp(self, value: typing.Union[builtins.bool, cdktf.IResolvable]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv4OutputReference, "dhcp").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dhcp", value)

    @builtins.property
    @jsii.member(jsii_name="gw")
    def gw(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "gw"))

    @gw.setter
    def gw(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv4OutputReference, "gw").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "gw", value)

    @builtins.property
    @jsii.member(jsii_name="ip")
    def ip(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "ip"))

    @ip.setter
    def ip(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv4OutputReference, "ip").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "ip", value)

    @builtins.property
    @jsii.member(jsii_name="netmask")
    def netmask(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "netmask"))

    @netmask.setter
    def netmask(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv4OutputReference, "netmask").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "netmask", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[VnicIpv4]:
        return typing.cast(typing.Optional[VnicIpv4], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(self, value: typing.Optional[VnicIpv4]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv4OutputReference, "internal_value").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-vsphere.vnic.VnicIpv6",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "autoconfig": "autoconfig",
        "dhcp": "dhcp",
        "gw": "gw",
    },
)
class VnicIpv6:
    def __init__(
        self,
        *,
        addresses: typing.Optional[typing.Sequence[builtins.str]] = None,
        autoconfig: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        dhcp: typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]] = None,
        gw: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param addresses: List of IPv6 addresses. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#addresses Vnic#addresses}
        :param autoconfig: Use IPv6 Autoconfiguration (RFC2462). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#autoconfig Vnic#autoconfig}
        :param dhcp: Use DHCP to configure the interface's IPv4 stack. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#dhcp Vnic#dhcp}
        :param gw: IP address of the default gateway, if DHCP or autoconfig is not set. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#gw Vnic#gw}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(VnicIpv6.__init__)
            check_type(argname="argument addresses", value=addresses, expected_type=type_hints["addresses"])
            check_type(argname="argument autoconfig", value=autoconfig, expected_type=type_hints["autoconfig"])
            check_type(argname="argument dhcp", value=dhcp, expected_type=type_hints["dhcp"])
            check_type(argname="argument gw", value=gw, expected_type=type_hints["gw"])
        self._values: typing.Dict[str, typing.Any] = {}
        if addresses is not None:
            self._values["addresses"] = addresses
        if autoconfig is not None:
            self._values["autoconfig"] = autoconfig
        if dhcp is not None:
            self._values["dhcp"] = dhcp
        if gw is not None:
            self._values["gw"] = gw

    @builtins.property
    def addresses(self) -> typing.Optional[typing.List[builtins.str]]:
        '''List of IPv6 addresses.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#addresses Vnic#addresses}
        '''
        result = self._values.get("addresses")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def autoconfig(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Use IPv6 Autoconfiguration (RFC2462).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#autoconfig Vnic#autoconfig}
        '''
        result = self._values.get("autoconfig")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def dhcp(self) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        '''Use DHCP to configure the interface's IPv4 stack.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#dhcp Vnic#dhcp}
        '''
        result = self._values.get("dhcp")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], result)

    @builtins.property
    def gw(self) -> typing.Optional[builtins.str]:
        '''IP address of the default gateway, if DHCP or autoconfig is not set.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/vnic#gw Vnic#gw}
        '''
        result = self._values.get("gw")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VnicIpv6(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VnicIpv6OutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-vsphere.vnic.VnicIpv6OutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(VnicIpv6OutputReference.__init__)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAddresses")
    def reset_addresses(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAddresses", []))

    @jsii.member(jsii_name="resetAutoconfig")
    def reset_autoconfig(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutoconfig", []))

    @jsii.member(jsii_name="resetDhcp")
    def reset_dhcp(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDhcp", []))

    @jsii.member(jsii_name="resetGw")
    def reset_gw(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGw", []))

    @builtins.property
    @jsii.member(jsii_name="addressesInput")
    def addresses_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "addressesInput"))

    @builtins.property
    @jsii.member(jsii_name="autoconfigInput")
    def autoconfig_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "autoconfigInput"))

    @builtins.property
    @jsii.member(jsii_name="dhcpInput")
    def dhcp_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, cdktf.IResolvable]], jsii.get(self, "dhcpInput"))

    @builtins.property
    @jsii.member(jsii_name="gwInput")
    def gw_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "gwInput"))

    @builtins.property
    @jsii.member(jsii_name="addresses")
    def addresses(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "addresses"))

    @addresses.setter
    def addresses(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv6OutputReference, "addresses").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "addresses", value)

    @builtins.property
    @jsii.member(jsii_name="autoconfig")
    def autoconfig(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "autoconfig"))

    @autoconfig.setter
    def autoconfig(self, value: typing.Union[builtins.bool, cdktf.IResolvable]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv6OutputReference, "autoconfig").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "autoconfig", value)

    @builtins.property
    @jsii.member(jsii_name="dhcp")
    def dhcp(self) -> typing.Union[builtins.bool, cdktf.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, cdktf.IResolvable], jsii.get(self, "dhcp"))

    @dhcp.setter
    def dhcp(self, value: typing.Union[builtins.bool, cdktf.IResolvable]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv6OutputReference, "dhcp").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dhcp", value)

    @builtins.property
    @jsii.member(jsii_name="gw")
    def gw(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "gw"))

    @gw.setter
    def gw(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv6OutputReference, "gw").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "gw", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[VnicIpv6]:
        return typing.cast(typing.Optional[VnicIpv6], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(self, value: typing.Optional[VnicIpv6]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(VnicIpv6OutputReference, "internal_value").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


__all__ = [
    "Vnic",
    "VnicConfig",
    "VnicIpv4",
    "VnicIpv4OutputReference",
    "VnicIpv6",
    "VnicIpv6OutputReference",
]

publication.publish()
