import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HostConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the vSphere cluster the host will belong to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#cluster Host#cluster}
    */
    readonly cluster?: string;
    /**
    * Must be set if host is a member of a managed compute_cluster resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#cluster_managed Host#cluster_managed}
    */
    readonly clusterManaged?: boolean | cdktf.IResolvable;
    /**
    * Set the state of the host. If set to false then the host will be asked to disconnect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#connected Host#connected}
    */
    readonly connected?: boolean | cdktf.IResolvable;
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#custom_attributes Host#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * ID of the vSphere datacenter the host will belong to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#datacenter Host#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Force add the host to the vSphere inventory even if it's already managed by a different vCenter Server instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#force Host#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * FQDN or IP address of the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#hostname Host#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#id Host#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * License key that will be applied to this host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#license Host#license}
    */
    readonly license?: string;
    /**
    * Set the host's lockdown status. Default is disabled. Valid options are 'disabled', 'normal', 'strict'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#lockdown Host#lockdown}
    */
    readonly lockdown?: string;
    /**
    * Set the host's maintenance mode. Default is false
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#maintenance Host#maintenance}
    */
    readonly maintenance?: boolean | cdktf.IResolvable;
    /**
    * Password of the administration account of the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#password Host#password}
    */
    readonly password: string;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#tags Host#tags}
    */
    readonly tags?: string[];
    /**
    * Host's certificate SHA-1 thumbprint. If not set then the CA that signed the host's certificate must be trusted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#thumbprint Host#thumbprint}
    */
    readonly thumbprint?: string;
    /**
    * Username of the administration account of the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host#username Host#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/host vsphere_host}
*/
export declare class Host extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_host";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/host vsphere_host} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostConfig
    */
    constructor(scope: Construct, id: string, config: HostConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    resetCluster(): void;
    get clusterInput(): string | undefined;
    private _clusterManaged?;
    get clusterManaged(): boolean | cdktf.IResolvable;
    set clusterManaged(value: boolean | cdktf.IResolvable);
    resetClusterManaged(): void;
    get clusterManagedInput(): boolean | cdktf.IResolvable | undefined;
    private _connected?;
    get connected(): boolean | cdktf.IResolvable;
    set connected(value: boolean | cdktf.IResolvable);
    resetConnected(): void;
    get connectedInput(): boolean | cdktf.IResolvable | undefined;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _license?;
    get license(): string;
    set license(value: string);
    resetLicense(): void;
    get licenseInput(): string | undefined;
    private _lockdown?;
    get lockdown(): string;
    set lockdown(value: string);
    resetLockdown(): void;
    get lockdownInput(): string | undefined;
    private _maintenance?;
    get maintenance(): boolean | cdktf.IResolvable;
    set maintenance(value: boolean | cdktf.IResolvable);
    resetMaintenance(): void;
    get maintenanceInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    resetThumbprint(): void;
    get thumbprintInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
