import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DistributedPortGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of active uplinks used for load balancing, matching the names of the uplinks assigned in the DVS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#active_uplinks DistributedPortGroup#active_uplinks}
    */
    readonly activeUplinks?: string[];
    /**
    * Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than that of its own.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#allow_forged_transmits DistributedPortGroup#allow_forged_transmits}
    */
    readonly allowForgedTransmits?: boolean | cdktf.IResolvable;
    /**
    * Controls whether or not the Media Access Control (MAC) address can be changed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#allow_mac_changes DistributedPortGroup#allow_mac_changes}
    */
    readonly allowMacChanges?: boolean | cdktf.IResolvable;
    /**
    * Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#allow_promiscuous DistributedPortGroup#allow_promiscuous}
    */
    readonly allowPromiscuous?: boolean | cdktf.IResolvable;
    /**
    * Auto-expands the port group beyond the port count configured in number_of_ports when necessary.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#auto_expand DistributedPortGroup#auto_expand}
    */
    readonly autoExpand?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether to block all ports by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#block_all_ports DistributedPortGroup#block_all_ports}
    */
    readonly blockAllPorts?: boolean | cdktf.IResolvable;
    /**
    * Allow the blocked setting of an individual port to override the setting in the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#block_override_allowed DistributedPortGroup#block_override_allowed}
    */
    readonly blockOverrideAllowed?: boolean | cdktf.IResolvable;
    /**
    * Enable beacon probing on the ports this policy applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#check_beacon DistributedPortGroup#check_beacon}
    */
    readonly checkBeacon?: boolean | cdktf.IResolvable;
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#custom_attributes DistributedPortGroup#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * The description of the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#description DistributedPortGroup#description}
    */
    readonly description?: string;
    /**
    * Allow VMDirectPath Gen2 on the ports this policy applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#directpath_gen2_allowed DistributedPortGroup#directpath_gen2_allowed}
    */
    readonly directpathGen2Allowed?: boolean | cdktf.IResolvable;
    /**
    * The UUID of the DVS to attach this port group to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#distributed_virtual_switch_uuid DistributedPortGroup#distributed_virtual_switch_uuid}
    */
    readonly distributedVirtualSwitchUuid: string;
    /**
    * The average egress bandwidth in bits per second if egress shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#egress_shaping_average_bandwidth DistributedPortGroup#egress_shaping_average_bandwidth}
    */
    readonly egressShapingAverageBandwidth?: number;
    /**
    * The maximum egress burst size allowed in bytes if egress shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#egress_shaping_burst_size DistributedPortGroup#egress_shaping_burst_size}
    */
    readonly egressShapingBurstSize?: number;
    /**
    * True if the traffic shaper is enabled for egress traffic on the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#egress_shaping_enabled DistributedPortGroup#egress_shaping_enabled}
    */
    readonly egressShapingEnabled?: boolean | cdktf.IResolvable;
    /**
    * The peak egress bandwidth during bursts in bits per second if egress traffic shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#egress_shaping_peak_bandwidth DistributedPortGroup#egress_shaping_peak_bandwidth}
    */
    readonly egressShapingPeakBandwidth?: number;
    /**
    * If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#failback DistributedPortGroup#failback}
    */
    readonly failback?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#id DistributedPortGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The average ingress bandwidth in bits per second if ingress shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#ingress_shaping_average_bandwidth DistributedPortGroup#ingress_shaping_average_bandwidth}
    */
    readonly ingressShapingAverageBandwidth?: number;
    /**
    * The maximum ingress burst size allowed in bytes if ingress shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#ingress_shaping_burst_size DistributedPortGroup#ingress_shaping_burst_size}
    */
    readonly ingressShapingBurstSize?: number;
    /**
    * True if the traffic shaper is enabled for ingress traffic on the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#ingress_shaping_enabled DistributedPortGroup#ingress_shaping_enabled}
    */
    readonly ingressShapingEnabled?: boolean | cdktf.IResolvable;
    /**
    * The peak ingress bandwidth during bursts in bits per second if ingress traffic shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#ingress_shaping_peak_bandwidth DistributedPortGroup#ingress_shaping_peak_bandwidth}
    */
    readonly ingressShapingPeakBandwidth?: number;
    /**
    * Whether or not to enable LACP on all uplink ports.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#lacp_enabled DistributedPortGroup#lacp_enabled}
    */
    readonly lacpEnabled?: boolean | cdktf.IResolvable;
    /**
    * The uplink LACP mode to use. Can be one of active or passive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#lacp_mode DistributedPortGroup#lacp_mode}
    */
    readonly lacpMode?: string;
    /**
    * Allow a live port to be moved in and out of the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#live_port_moving_allowed DistributedPortGroup#live_port_moving_allowed}
    */
    readonly livePortMovingAllowed?: boolean | cdktf.IResolvable;
    /**
    * The name of the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#name DistributedPortGroup#name}
    */
    readonly name: string;
    /**
    * Indicates whether to enable netflow on all ports.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#netflow_enabled DistributedPortGroup#netflow_enabled}
    */
    readonly netflowEnabled?: boolean | cdktf.IResolvable;
    /**
    * Allow the enabling or disabling of Netflow on a port, contrary to the policy in the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#netflow_override_allowed DistributedPortGroup#netflow_override_allowed}
    */
    readonly netflowOverrideAllowed?: boolean | cdktf.IResolvable;
    /**
    * The key of a network resource pool to associate with this portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#network_resource_pool_key DistributedPortGroup#network_resource_pool_key}
    */
    readonly networkResourcePoolKey?: string;
    /**
    * Allow the network resource pool of an individual port to override the setting in the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#network_resource_pool_override_allowed DistributedPortGroup#network_resource_pool_override_allowed}
    */
    readonly networkResourcePoolOverrideAllowed?: boolean | cdktf.IResolvable;
    /**
    * If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#notify_switches DistributedPortGroup#notify_switches}
    */
    readonly notifySwitches?: boolean | cdktf.IResolvable;
    /**
    * The number of ports in this portgroup. The DVS will expand and shrink by modifying this setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#number_of_ports DistributedPortGroup#number_of_ports}
    */
    readonly numberOfPorts?: number;
    /**
    * Reset the setting of any ports in this portgroup back to the default setting when the port disconnects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#port_config_reset_at_disconnect DistributedPortGroup#port_config_reset_at_disconnect}
    */
    readonly portConfigResetAtDisconnect?: boolean | cdktf.IResolvable;
    /**
    * A template string to use when creating ports in the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#port_name_format DistributedPortGroup#port_name_format}
    */
    readonly portNameFormat?: string;
    /**
    * The secondary VLAN ID for this port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#port_private_secondary_vlan_id DistributedPortGroup#port_private_secondary_vlan_id}
    */
    readonly portPrivateSecondaryVlanId?: number;
    /**
    * Allow security policy settings on a port to override those on the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#security_policy_override_allowed DistributedPortGroup#security_policy_override_allowed}
    */
    readonly securityPolicyOverrideAllowed?: boolean | cdktf.IResolvable;
    /**
    * Allow the traffic shaping policies of an individual port to override the settings in the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#shaping_override_allowed DistributedPortGroup#shaping_override_allowed}
    */
    readonly shapingOverrideAllowed?: boolean | cdktf.IResolvable;
    /**
    * List of standby uplinks used for load balancing, matching the names of the uplinks assigned in the DVS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#standby_uplinks DistributedPortGroup#standby_uplinks}
    */
    readonly standbyUplinks?: string[];
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#tags DistributedPortGroup#tags}
    */
    readonly tags?: string[];
    /**
    * The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, failover_explicit, or loadbalance_loadbased.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#teaming_policy DistributedPortGroup#teaming_policy}
    */
    readonly teamingPolicy?: string;
    /**
    * Allow any filter policies set on the individual port to override those in the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#traffic_filter_override_allowed DistributedPortGroup#traffic_filter_override_allowed}
    */
    readonly trafficFilterOverrideAllowed?: boolean | cdktf.IResolvable;
    /**
    * If true, a copy of packets sent to the switch will always be forwarded to an uplink in addition to the regular packet forwarded done by the switch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#tx_uplink DistributedPortGroup#tx_uplink}
    */
    readonly txUplink?: boolean | cdktf.IResolvable;
    /**
    * The type of portgroup. Can be one of earlyBinding (static) or ephemeral.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#type DistributedPortGroup#type}
    */
    readonly type?: string;
    /**
    * Allow the uplink teaming policies on a port to override those on the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#uplink_teaming_override_allowed DistributedPortGroup#uplink_teaming_override_allowed}
    */
    readonly uplinkTeamingOverrideAllowed?: boolean | cdktf.IResolvable;
    /**
    * The VLAN ID for single VLAN mode. 0 denotes no VLAN.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#vlan_id DistributedPortGroup#vlan_id}
    */
    readonly vlanId?: number;
    /**
    * Allow the VLAN configuration on a port to override those on the portgroup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#vlan_override_allowed DistributedPortGroup#vlan_override_allowed}
    */
    readonly vlanOverrideAllowed?: boolean | cdktf.IResolvable;
    /**
    * vlan_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#vlan_range DistributedPortGroup#vlan_range}
    */
    readonly vlanRange?: DistributedPortGroupVlanRange[] | cdktf.IResolvable;
}
export interface DistributedPortGroupVlanRange {
    /**
    * The minimum VLAN to use in the range.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#max_vlan DistributedPortGroup#max_vlan}
    */
    readonly maxVlan: number;
    /**
    * The minimum VLAN to use in the range.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group#min_vlan DistributedPortGroup#min_vlan}
    */
    readonly minVlan: number;
}
export declare function distributedPortGroupVlanRangeToTerraform(struct?: DistributedPortGroupVlanRange | cdktf.IResolvable): any;
export declare class DistributedPortGroupVlanRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DistributedPortGroupVlanRange | cdktf.IResolvable | undefined;
    set internalValue(value: DistributedPortGroupVlanRange | cdktf.IResolvable | undefined);
    private _maxVlan?;
    get maxVlan(): number;
    set maxVlan(value: number);
    get maxVlanInput(): number | undefined;
    private _minVlan?;
    get minVlan(): number;
    set minVlan(value: number);
    get minVlanInput(): number | undefined;
}
export declare class DistributedPortGroupVlanRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DistributedPortGroupVlanRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DistributedPortGroupVlanRangeOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group vsphere_distributed_port_group}
*/
export declare class DistributedPortGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_distributed_port_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group vsphere_distributed_port_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DistributedPortGroupConfig
    */
    constructor(scope: Construct, id: string, config: DistributedPortGroupConfig);
    private _activeUplinks?;
    get activeUplinks(): string[];
    set activeUplinks(value: string[]);
    resetActiveUplinks(): void;
    get activeUplinksInput(): string[] | undefined;
    private _allowForgedTransmits?;
    get allowForgedTransmits(): boolean | cdktf.IResolvable;
    set allowForgedTransmits(value: boolean | cdktf.IResolvable);
    resetAllowForgedTransmits(): void;
    get allowForgedTransmitsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowMacChanges?;
    get allowMacChanges(): boolean | cdktf.IResolvable;
    set allowMacChanges(value: boolean | cdktf.IResolvable);
    resetAllowMacChanges(): void;
    get allowMacChangesInput(): boolean | cdktf.IResolvable | undefined;
    private _allowPromiscuous?;
    get allowPromiscuous(): boolean | cdktf.IResolvable;
    set allowPromiscuous(value: boolean | cdktf.IResolvable);
    resetAllowPromiscuous(): void;
    get allowPromiscuousInput(): boolean | cdktf.IResolvable | undefined;
    private _autoExpand?;
    get autoExpand(): boolean | cdktf.IResolvable;
    set autoExpand(value: boolean | cdktf.IResolvable);
    resetAutoExpand(): void;
    get autoExpandInput(): boolean | cdktf.IResolvable | undefined;
    private _blockAllPorts?;
    get blockAllPorts(): boolean | cdktf.IResolvable;
    set blockAllPorts(value: boolean | cdktf.IResolvable);
    resetBlockAllPorts(): void;
    get blockAllPortsInput(): boolean | cdktf.IResolvable | undefined;
    private _blockOverrideAllowed?;
    get blockOverrideAllowed(): boolean | cdktf.IResolvable;
    set blockOverrideAllowed(value: boolean | cdktf.IResolvable);
    resetBlockOverrideAllowed(): void;
    get blockOverrideAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _checkBeacon?;
    get checkBeacon(): boolean | cdktf.IResolvable;
    set checkBeacon(value: boolean | cdktf.IResolvable);
    resetCheckBeacon(): void;
    get checkBeaconInput(): boolean | cdktf.IResolvable | undefined;
    get configVersion(): string;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _directpathGen2Allowed?;
    get directpathGen2Allowed(): boolean | cdktf.IResolvable;
    set directpathGen2Allowed(value: boolean | cdktf.IResolvable);
    resetDirectpathGen2Allowed(): void;
    get directpathGen2AllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _distributedVirtualSwitchUuid?;
    get distributedVirtualSwitchUuid(): string;
    set distributedVirtualSwitchUuid(value: string);
    get distributedVirtualSwitchUuidInput(): string | undefined;
    private _egressShapingAverageBandwidth?;
    get egressShapingAverageBandwidth(): number;
    set egressShapingAverageBandwidth(value: number);
    resetEgressShapingAverageBandwidth(): void;
    get egressShapingAverageBandwidthInput(): number | undefined;
    private _egressShapingBurstSize?;
    get egressShapingBurstSize(): number;
    set egressShapingBurstSize(value: number);
    resetEgressShapingBurstSize(): void;
    get egressShapingBurstSizeInput(): number | undefined;
    private _egressShapingEnabled?;
    get egressShapingEnabled(): boolean | cdktf.IResolvable;
    set egressShapingEnabled(value: boolean | cdktf.IResolvable);
    resetEgressShapingEnabled(): void;
    get egressShapingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _egressShapingPeakBandwidth?;
    get egressShapingPeakBandwidth(): number;
    set egressShapingPeakBandwidth(value: number);
    resetEgressShapingPeakBandwidth(): void;
    get egressShapingPeakBandwidthInput(): number | undefined;
    private _failback?;
    get failback(): boolean | cdktf.IResolvable;
    set failback(value: boolean | cdktf.IResolvable);
    resetFailback(): void;
    get failbackInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingressShapingAverageBandwidth?;
    get ingressShapingAverageBandwidth(): number;
    set ingressShapingAverageBandwidth(value: number);
    resetIngressShapingAverageBandwidth(): void;
    get ingressShapingAverageBandwidthInput(): number | undefined;
    private _ingressShapingBurstSize?;
    get ingressShapingBurstSize(): number;
    set ingressShapingBurstSize(value: number);
    resetIngressShapingBurstSize(): void;
    get ingressShapingBurstSizeInput(): number | undefined;
    private _ingressShapingEnabled?;
    get ingressShapingEnabled(): boolean | cdktf.IResolvable;
    set ingressShapingEnabled(value: boolean | cdktf.IResolvable);
    resetIngressShapingEnabled(): void;
    get ingressShapingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ingressShapingPeakBandwidth?;
    get ingressShapingPeakBandwidth(): number;
    set ingressShapingPeakBandwidth(value: number);
    resetIngressShapingPeakBandwidth(): void;
    get ingressShapingPeakBandwidthInput(): number | undefined;
    get key(): string;
    private _lacpEnabled?;
    get lacpEnabled(): boolean | cdktf.IResolvable;
    set lacpEnabled(value: boolean | cdktf.IResolvable);
    resetLacpEnabled(): void;
    get lacpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _lacpMode?;
    get lacpMode(): string;
    set lacpMode(value: string);
    resetLacpMode(): void;
    get lacpModeInput(): string | undefined;
    private _livePortMovingAllowed?;
    get livePortMovingAllowed(): boolean | cdktf.IResolvable;
    set livePortMovingAllowed(value: boolean | cdktf.IResolvable);
    resetLivePortMovingAllowed(): void;
    get livePortMovingAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _netflowEnabled?;
    get netflowEnabled(): boolean | cdktf.IResolvable;
    set netflowEnabled(value: boolean | cdktf.IResolvable);
    resetNetflowEnabled(): void;
    get netflowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _netflowOverrideAllowed?;
    get netflowOverrideAllowed(): boolean | cdktf.IResolvable;
    set netflowOverrideAllowed(value: boolean | cdktf.IResolvable);
    resetNetflowOverrideAllowed(): void;
    get netflowOverrideAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _networkResourcePoolKey?;
    get networkResourcePoolKey(): string;
    set networkResourcePoolKey(value: string);
    resetNetworkResourcePoolKey(): void;
    get networkResourcePoolKeyInput(): string | undefined;
    private _networkResourcePoolOverrideAllowed?;
    get networkResourcePoolOverrideAllowed(): boolean | cdktf.IResolvable;
    set networkResourcePoolOverrideAllowed(value: boolean | cdktf.IResolvable);
    resetNetworkResourcePoolOverrideAllowed(): void;
    get networkResourcePoolOverrideAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _notifySwitches?;
    get notifySwitches(): boolean | cdktf.IResolvable;
    set notifySwitches(value: boolean | cdktf.IResolvable);
    resetNotifySwitches(): void;
    get notifySwitchesInput(): boolean | cdktf.IResolvable | undefined;
    private _numberOfPorts?;
    get numberOfPorts(): number;
    set numberOfPorts(value: number);
    resetNumberOfPorts(): void;
    get numberOfPortsInput(): number | undefined;
    private _portConfigResetAtDisconnect?;
    get portConfigResetAtDisconnect(): boolean | cdktf.IResolvable;
    set portConfigResetAtDisconnect(value: boolean | cdktf.IResolvable);
    resetPortConfigResetAtDisconnect(): void;
    get portConfigResetAtDisconnectInput(): boolean | cdktf.IResolvable | undefined;
    private _portNameFormat?;
    get portNameFormat(): string;
    set portNameFormat(value: string);
    resetPortNameFormat(): void;
    get portNameFormatInput(): string | undefined;
    private _portPrivateSecondaryVlanId?;
    get portPrivateSecondaryVlanId(): number;
    set portPrivateSecondaryVlanId(value: number);
    resetPortPrivateSecondaryVlanId(): void;
    get portPrivateSecondaryVlanIdInput(): number | undefined;
    private _securityPolicyOverrideAllowed?;
    get securityPolicyOverrideAllowed(): boolean | cdktf.IResolvable;
    set securityPolicyOverrideAllowed(value: boolean | cdktf.IResolvable);
    resetSecurityPolicyOverrideAllowed(): void;
    get securityPolicyOverrideAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _shapingOverrideAllowed?;
    get shapingOverrideAllowed(): boolean | cdktf.IResolvable;
    set shapingOverrideAllowed(value: boolean | cdktf.IResolvable);
    resetShapingOverrideAllowed(): void;
    get shapingOverrideAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _standbyUplinks?;
    get standbyUplinks(): string[];
    set standbyUplinks(value: string[]);
    resetStandbyUplinks(): void;
    get standbyUplinksInput(): string[] | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _teamingPolicy?;
    get teamingPolicy(): string;
    set teamingPolicy(value: string);
    resetTeamingPolicy(): void;
    get teamingPolicyInput(): string | undefined;
    private _trafficFilterOverrideAllowed?;
    get trafficFilterOverrideAllowed(): boolean | cdktf.IResolvable;
    set trafficFilterOverrideAllowed(value: boolean | cdktf.IResolvable);
    resetTrafficFilterOverrideAllowed(): void;
    get trafficFilterOverrideAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _txUplink?;
    get txUplink(): boolean | cdktf.IResolvable;
    set txUplink(value: boolean | cdktf.IResolvable);
    resetTxUplink(): void;
    get txUplinkInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _uplinkTeamingOverrideAllowed?;
    get uplinkTeamingOverrideAllowed(): boolean | cdktf.IResolvable;
    set uplinkTeamingOverrideAllowed(value: boolean | cdktf.IResolvable);
    resetUplinkTeamingOverrideAllowed(): void;
    get uplinkTeamingOverrideAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _vlanId?;
    get vlanId(): number;
    set vlanId(value: number);
    resetVlanId(): void;
    get vlanIdInput(): number | undefined;
    private _vlanOverrideAllowed?;
    get vlanOverrideAllowed(): boolean | cdktf.IResolvable;
    set vlanOverrideAllowed(value: boolean | cdktf.IResolvable);
    resetVlanOverrideAllowed(): void;
    get vlanOverrideAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _vlanRange;
    get vlanRange(): DistributedPortGroupVlanRangeList;
    putVlanRange(value: DistributedPortGroupVlanRange[] | cdktf.IResolvable): void;
    resetVlanRange(): void;
    get vlanRangeInput(): cdktf.IResolvable | DistributedPortGroupVlanRange[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
