import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereFolderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/folder#id DataVsphereFolder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The absolute path of the folder.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/folder#path DataVsphereFolder#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/folder vsphere_folder}
*/
export declare class DataVsphereFolder extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_folder";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/folder vsphere_folder} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereFolderConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereFolderConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
