# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: onos/e2t/e2/e2.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterable, AsyncIterator, Iterable, Optional, Union

import betterproto
import grpclib


class EncodingType(betterproto.Enum):
    """EncodingType determines encoding type for the response messages"""

    PROTO = 0
    ASN1_PER = 1
    ASN1_XER = 2


class ResponseStatus(betterproto.Enum):
    """ResponseStatus"""

    FAILED = 0
    SUCCEEDED = 1
    REJECTED = 2


class Cause(betterproto.Enum):
    """Cause is a failure cause"""

    CAUSE_UNKNOWN = 0
    CAUSE_MISC_CONTROL_PROCESSING_OVERLOAD = 1
    CAUSE_MISC_HARDWARE_FAILURE = 2
    CAUSE_MISC_OM_INTERVENTION = 3
    CAUSE_MISC_UNSPECIFIED = 4
    CAUSE_PROTOCOL_TRANSFER_SYNTAX_ERROR = 5
    CAUSE_PROTOCOL_ABSTRACT_SYNTAX_ERROR_REJECT = 6
    CAUSE_PROTOCOL_ABSTRACT_SYNTAX_ERROR_IGNORE_AND_NOTIFY = 7
    CAUSE_PROTOCOL_MESSAGE_NOT_COMPATIBLE_WITH_RECEIVER_STATE = 8
    CAUSE_PROTOCOL_SEMANTIC_ERROR = 9
    CAUSE_PROTOCOL_ABSTRACT_SYNTAX_ERROR_FALSELY_CONSTRUCTED_MESSAGE = 10
    CAUSE_PROTOCOL_UNSPECIFIED = 11
    CAUSE_RIC_RAN_FUNCTION_ID_INVALID = 12
    CAUSE_RIC_ACTION_NOT_SUPPORTED = 13
    CAUSE_RIC_EXCESSIVE_ACTIONS = 14
    CAUSE_RIC_DUPLICATE_ACTION = 15
    CAUSE_RIC_DUPLICATE_EVENT = 16
    CAUSE_RIC_FUNCTION_RESOURCE_LIMIT = 17
    CAUSE_RIC_REQUEST_ID_UNKNOWN = 18
    CAUSE_RIC_INCONSISTENT_ACTION_SUBSEQUENT_ACTION_SEQUENCE = 19
    CAUSE_RIC_CONTROL_MESSAGE_INVALID = 20
    CAUSE_RIC_CALL_PROCESS_ID_INVALID = 21
    CAUSE_RIC_UNSPECIFIED = 22
    CAUSE_RICSERVICE_FUNCTION_NOT_REQUIRED = 23
    CAUSE_RICSERVICE_EXCESSIVE_FUNCTIONS = 24
    CAUSE_RICSERVICE_RIC_RESOURCE_LIMIT = 25
    CAUSE_TRANSPORT_UNSPECIFIED = 26
    CAUSE_TRANSPORT_TRANSPORT_RESOURCE_UNAVAILABLE = 27


class ControlAckRequest(betterproto.Enum):
    # Optional RIC Control Acknowledgement is required
    ACK = 0
    # Optional RIC Control Acknowledgement is not required
    NO_ACK = 1
    # Optional RIC Control Acknowledgement is only required to report failure
    NACK = 2


@dataclass(eq=False, repr=False)
class ServiceModel(betterproto.Message):
    """ServiceModelInfo E2 service model information"""

    name: str = betterproto.string_field(1)
    version: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RequestHeader(betterproto.Message):
    """
    RequestHeader a common request header for all requests including encoding
    type, client/xApp/session info, ordering info, etc
    """

    encoding_type: "EncodingType" = betterproto.enum_field(1)
    service_model: "ServiceModel" = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ResponseHeader(betterproto.Message):
    """
    ResponseHeader a common response header for all responses including
    encoding type, client/xApp/session info, ordering info, etc
    """

    encoding_type: "EncodingType" = betterproto.enum_field(1)
    service_model: "ServiceModel" = betterproto.message_field(2)
    response_status: "ResponseStatus" = betterproto.enum_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class StreamRequest(betterproto.Message):
    """StreamRequest"""

    header: "RequestHeader" = betterproto.message_field(1)
    app_id: str = betterproto.string_field(2)
    instance_id: str = betterproto.string_field(3)
    subscription_id: str = betterproto.string_field(4)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class StreamResponse(betterproto.Message):
    """StreamResponse"""

    header: "ResponseHeader" = betterproto.message_field(1)
    indication_header: bytes = betterproto.bytes_field(2)
    indication_message: bytes = betterproto.bytes_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ControlRequest(betterproto.Message):
    """ControlRequest E2 control request"""

    header: "RequestHeader" = betterproto.message_field(1)
    e2_node_id: str = betterproto.string_field(2)
    control_header: bytes = betterproto.bytes_field(3)
    control_message: bytes = betterproto.bytes_field(4)
    control_ack_request: "ControlAckRequest" = betterproto.enum_field(5)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ControlResponse(betterproto.Message):
    """ControlResponse E2 control response"""

    header: "ResponseHeader" = betterproto.message_field(1)
    control_acknowledge: "ControlAcknowledge" = betterproto.message_field(
        2, group="response"
    )
    control_failure: "ControlFailure" = betterproto.message_field(3, group="response")

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ControlAcknowledge(betterproto.Message):
    """ControlAcknowledge control acknowledgement"""

    control_outcome: bytes = betterproto.bytes_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ControlFailure(betterproto.Message):
    """ControlFailure control failure message"""

    cause: "Cause" = betterproto.enum_field(1)
    control_outcome: bytes = betterproto.bytes_field(2)
    message: str = betterproto.string_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


class E2TServiceStub(betterproto.ServiceStub):
    """
    E2TService provides means for enhanced interactions with the ONOS RIC E2
    Termination service.
    """

    async def stream(
        self,
        request_iterator: Union[
            AsyncIterable["StreamRequest"], Iterable["StreamRequest"]
        ],
    ) -> AsyncIterator["StreamResponse"]:
        """Stream opens an indications stream"""

        async for response in self._stream_stream(
            "/onos.e2t.e2.E2TService/Stream",
            request_iterator,
            StreamRequest,
            StreamResponse,
        ):
            yield response

    async def control(
        self,
        *,
        header: "RequestHeader" = None,
        e2_node_id: str = "",
        control_header: bytes = b"",
        control_message: bytes = b"",
        control_ack_request: "ControlAckRequest" = None,
    ) -> "ControlResponse":
        """Control sends a E2 control request"""

        request = ControlRequest()
        if header is not None:
            request.header = header
        request.e2_node_id = e2_node_id
        request.control_header = control_header
        request.control_message = control_message
        request.control_ack_request = control_ack_request

        return await self._unary_unary(
            "/onos.e2t.e2.E2TService/Control", request, ControlResponse
        )
