/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.writer.AnnotationSection;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationElement;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypePool;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.builder.DexBuilder;

class BuilderAnnotationPool
extends BaseBuilderPool
implements AnnotationSection<BuilderStringReference, BuilderTypeReference, BuilderAnnotation, BuilderAnnotationElement, BuilderEncodedValues.BuilderEncodedValue> {
    private final ConcurrentMap<Annotation, BuilderAnnotation> internedItems = Maps.newConcurrentMap();

    public BuilderAnnotationPool(DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    public BuilderAnnotation internAnnotation(Annotation annotation) {
        BuilderAnnotation ret = (BuilderAnnotation)this.internedItems.get(annotation);
        if (ret != null) {
            return ret;
        }
        BuilderAnnotation dexBuilderAnnotation = new BuilderAnnotation(annotation.getVisibility(), ((BuilderTypePool)this.dexBuilder.typeSection).internType(annotation.getType()), this.dexBuilder.internAnnotationElements(annotation.getElements()));
        ret = this.internedItems.putIfAbsent(dexBuilderAnnotation, dexBuilderAnnotation);
        return ret == null ? dexBuilderAnnotation : ret;
    }

    @Override
    public int getVisibility(BuilderAnnotation key) {
        return key.visibility;
    }

    @Override
    public BuilderTypeReference getType(BuilderAnnotation key) {
        return key.type;
    }

    @Override
    public Collection<? extends BuilderAnnotationElement> getElements(BuilderAnnotation key) {
        return key.elements;
    }

    @Override
    public BuilderStringReference getElementName(BuilderAnnotationElement element) {
        return element.name;
    }

    @Override
    public BuilderEncodedValues.BuilderEncodedValue getElementValue(BuilderAnnotationElement element) {
        return element.value;
    }

    @Override
    public int getItemOffset(BuilderAnnotation key) {
        return key.offset;
    }

    @Override
    public Collection<? extends Map.Entry<? extends BuilderAnnotation, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderAnnotation>(this.internedItems.values()){

            @Override
            protected int getValue(BuilderAnnotation key) {
                return key.offset;
            }

            @Override
            protected int setValue(BuilderAnnotation key, int value) {
                int prev = key.offset;
                key.offset = value;
                return prev;
            }
        };
    }
}

