# Introduction 
This project makes it possible to easily interact with the objects in ZEVIT's Asset Integrity Hub.

Project is structured as follows:

```

AIH_SDK
├── AIHClient
├── Workitems
│   ├── Annotation
│   ├── Assessment
│   ├── AssignedElement
│   ├── Deviation
│   ├── Media
│   ├── MediaReference
│   ├── PanoramaImage
│   ├── PanoramicTour
│   └── WorkorderItem
├── Assets
│   ├── Equipment
│   └── MainSystem
├── DataProcessing
│   ├── Job
│   └── JobConfiguration
├── DataUpload
│   ├── DataType
│   └── File
├── Designations
│   ├── Design
│   ├── Schema
│   └── Structure

```

# Getting Started
1.	Install by: pip install AIH_SDK
2.	Initialize AIHClient by: AIH_SDK.AIHClient.AIHClient(environment_to_connect_to, client_id, client_secret)
3.	Get objects from v1 and v2 APIs. Example of getting a main system: mainsystem = AIH_SDK.v2.MainSystem.MainSystem().get(guid)
4.	Objects support CRUD operation in form of post, get, put, and delete.

# Object design
Objects store the information fetch from the APIs in the self.value

self.value can either be a dict containing one instance or be a list containing multiple dicts, representing multiple objects.

Objects all contain following methods:
* get()
* put()
* post()
* delete()
* copy()
* get_value()
* set_value()
* update_values()
* to_dataframe()
* get_keys()
* filter()
* from_dataframe()
* from_dict()
* from_list()
* join()

Methods that modifies the object operates inplace, but also returns the obejct itself to allow chaining methods.