"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const cdk = require("aws-cdk-lib");
/**
 * @summary The ApiGatewayToSqs class.
 */
class ApiGatewayToSqs extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the ApiGatewayToSqs class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {ApiGatewayToSqsProps} props - user provided props for the construct.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.defaultCreateRequestTemplate = 'Action=SendMessage&MessageBody=$util.urlEncode(\"$input.body\")';
        this.defaultReadRequestTemplate = 'Action=ReceiveMessage';
        this.defaultDeleteRequestTemplate = "Action=DeleteMessage&ReceiptHandle=$util.urlEncode($input.params('receiptHandle'))";
        defaults.CheckSqsProps(props);
        if (this.CheckCreateRequestProps(props)) {
            throw new Error(`The 'allowCreateOperation' property must be set to true when setting any of the following: ` +
                `'createRequestTemplate', 'additionalCreateRequestTemplates', 'createIntegrationResponses'`);
        }
        if (this.CheckReadRequestProps(props)) {
            throw new Error(`The 'allowReadOperation' property must be set to true or undefined when setting any of the following: ` +
                `'readRequestTemplate', 'additionalReadRequestTemplates', 'readIntegrationResponses'`);
        }
        if (this.CheckDeleteRequestProps(props)) {
            throw new Error(`The 'allowDeleteOperation' property must be set to true when setting any of the following: ` +
                `'deleteRequestTemplate', 'additionalDeleteRequestTemplates', 'deleteIntegrationResponses'`);
        }
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        // Setup the queue
        const buildQueueResponse = defaults.buildQueue(this, 'queue', {
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            enableEncryptionWithCustomerManagedKey: props.enableEncryptionWithCustomerManagedKey,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        this.sqsQueue = buildQueueResponse.queue;
        // Setup the API Gateway
        const globalRestApiResponse = defaults.GlobalRestApi(this, props.apiGatewayProps, props.logGroupProps);
        this.apiGateway = globalRestApiResponse.api;
        this.apiGatewayCloudWatchRole = globalRestApiResponse.role;
        this.apiGatewayLogGroup = globalRestApiResponse.logGroup;
        // Setup the API Gateway role
        this.apiGatewayRole = new iam.Role(this, 'api-gateway-role', {
            assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com')
        });
        // Create
        const createRequestTemplate = props.createRequestTemplate ?? this.defaultCreateRequestTemplate;
        if (props.allowCreateOperation && props.allowCreateOperation === true) {
            this.addActionToPolicy("sqs:SendMessage");
            defaults.addProxyMethodToApiResource({
                service: "sqs",
                path: `${cdk.Aws.ACCOUNT_ID}/${this.sqsQueue.queueName}`,
                apiGatewayRole: this.apiGatewayRole,
                apiMethod: "POST",
                apiResource: this.apiGateway.root,
                requestTemplate: createRequestTemplate,
                additionalRequestTemplates: props.additionalCreateRequestTemplates,
                contentType: "'application/x-www-form-urlencoded'",
                integrationResponses: props.createIntegrationResponses
            });
        }
        // Read
        const readRequestTemplate = props.readRequestTemplate ?? this.defaultReadRequestTemplate;
        if (props.allowReadOperation === undefined || props.allowReadOperation === true) {
            this.addActionToPolicy("sqs:ReceiveMessage");
            defaults.addProxyMethodToApiResource({
                service: "sqs",
                path: `${cdk.Aws.ACCOUNT_ID}/${this.sqsQueue.queueName}`,
                apiGatewayRole: this.apiGatewayRole,
                apiMethod: "GET",
                apiResource: this.apiGateway.root,
                requestTemplate: readRequestTemplate,
                additionalRequestTemplates: props.additionalReadRequestTemplates,
                contentType: "'application/x-www-form-urlencoded'",
                integrationResponses: props.readIntegrationResponses
            });
        }
        // Delete
        const deleteRequestTemplate = props.deleteRequestTemplate ?? this.defaultDeleteRequestTemplate;
        if (props.allowDeleteOperation && props.allowDeleteOperation === true) {
            const apiGatewayResource = this.apiGateway.root.addResource('message');
            this.addActionToPolicy("sqs:DeleteMessage");
            defaults.addProxyMethodToApiResource({
                service: "sqs",
                path: `${cdk.Aws.ACCOUNT_ID}/${this.sqsQueue.queueName}`,
                apiGatewayRole: this.apiGatewayRole,
                apiMethod: "DELETE",
                apiResource: apiGatewayResource,
                requestTemplate: deleteRequestTemplate,
                additionalRequestTemplates: props.additionalDeleteRequestTemplates,
                contentType: "'application/x-www-form-urlencoded'",
                integrationResponses: props.deleteIntegrationResponses
            });
        }
    }
    CheckReadRequestProps(props) {
        if ((props.readRequestTemplate || props.additionalReadRequestTemplates || props.readIntegrationResponses)
            && props.allowReadOperation === false) {
            return true;
        }
        return false;
    }
    CheckDeleteRequestProps(props) {
        if ((props.deleteRequestTemplate || props.additionalDeleteRequestTemplates || props.deleteIntegrationResponses)
            && props.allowDeleteOperation !== true) {
            return true;
        }
        return false;
    }
    CheckCreateRequestProps(props) {
        if ((props.createRequestTemplate || props.additionalCreateRequestTemplates || props.createIntegrationResponses)
            && props.allowCreateOperation !== true) {
            return true;
        }
        return false;
    }
    addActionToPolicy(action) {
        this.apiGatewayRole.addToPolicy(new iam.PolicyStatement({
            resources: [
                this.sqsQueue.queueArn
            ],
            actions: [`${action}`]
        }));
    }
}
exports.ApiGatewayToSqs = ApiGatewayToSqs;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-apigateway-sqs.ApiGatewayToSqs", version: "2.58.0" };
//# sourceMappingURL=data:application/json;base64,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