# Generated by Django 4.2.9 on 2024-01-16 13:32

import django.db.models.deletion
from django.db import migrations, models

import django_slack_tools.utils.dict_template
import django_slack_tools.utils.slack.django


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="SlackMention",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, help_text="When instance created.", verbose_name="Created"),
                ),
                (
                    "last_modified",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="When instance modified recently.",
                        verbose_name="Last Modified",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[("U", "User"), ("G", "Group"), ("S", "Special"), ("?", "Unknown")],
                        help_text="Type of mentions.",
                        max_length=1,
                        verbose_name="Type",
                    ),
                ),
                (
                    "name",
                    models.CharField(help_text="Human-friendly mention name.", max_length=128, verbose_name="Name"),
                ),
                (
                    "mention_id",
                    models.CharField(
                        help_text="User or group ID, or raw mention itself.",
                        max_length=32,
                        verbose_name="Mention ID",
                    ),
                ),
            ],
            options={
                "verbose_name": "Mention",
                "verbose_name_plural": "Mentions",
            },
        ),
        migrations.CreateModel(
            name="SlackMessageRecipient",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, help_text="When instance created.", verbose_name="Created"),
                ),
                (
                    "last_modified",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="When instance modified recently.",
                        verbose_name="Last Modified",
                    ),
                ),
                (
                    "alias",
                    models.CharField(
                        help_text="Alias for this recipient.",
                        max_length=256,
                        unique=True,
                        verbose_name="Alias",
                    ),
                ),
                (
                    "channel",
                    models.CharField(
                        help_text="Slack channel ID where messages will be sent.",
                        max_length=128,
                        verbose_name="Channel",
                    ),
                ),
                (
                    "channel_name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Display name of channel.",
                        max_length=256,
                        verbose_name="Channel name",
                    ),
                ),
                (
                    "mentions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="List of mentions.",
                        to="slack_messages.slackmention",
                        verbose_name="Mentions",
                    ),
                ),
            ],
            options={
                "verbose_name": "Recipient",
                "verbose_name_plural": "Recipients",
            },
        ),
        migrations.CreateModel(
            name="SlackMessagingPolicy",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, help_text="When instance created.", verbose_name="Created"),
                ),
                (
                    "last_modified",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="When instance modified recently.",
                        verbose_name="Last Modified",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="Unique message code for lookup, mostly by human.",
                        max_length=32,
                        unique=True,
                        verbose_name="Code",
                    ),
                ),
                (
                    "enabled",
                    models.BooleanField(
                        default=True,
                        help_text="Turn on or off current messaging policy.",
                        verbose_name="Enabled",
                    ),
                ),
                (
                    "header_defaults",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Default header values applied to messages on creation.",
                        validators=[django_slack_tools.utils.slack.django.header_validator],
                        verbose_name="Default header",
                    ),
                ),
                (
                    "template",
                    models.JSONField(
                        blank=True,
                        help_text="Dictionary-based template object.",
                        null=True,
                        validators=[django_slack_tools.utils.dict_template.dict_template_validator],
                        verbose_name="Message template object",
                    ),
                ),
                (
                    "recipients",
                    models.ManyToManyField(
                        help_text="Those who will receive messages.",
                        to="slack_messages.slackmessagerecipient",
                        verbose_name="Message recipients",
                    ),
                ),
            ],
            options={
                "verbose_name": "Messaging Policy",
                "verbose_name_plural": "Messaging Policies",
            },
        ),
        migrations.CreateModel(
            name="SlackMessage",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, help_text="When instance created.", verbose_name="Created"),
                ),
                (
                    "last_modified",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="When instance modified recently.",
                        verbose_name="Last Modified",
                    ),
                ),
                (
                    "channel",
                    models.CharField(
                        help_text="ID of channel this message sent to.",
                        max_length=128,
                        verbose_name="Channel",
                    ),
                ),
                (
                    "header",
                    models.JSONField(
                        help_text="Slack control arguments. Allowed fields are `mrkdwn`, `parse`, `reply_broadcast`, `thread_ts`, `unfurl_links`, `unfurl_media`.",  # noqa: E501
                        validators=[django_slack_tools.utils.slack.django.header_validator],
                        verbose_name="Header",
                    ),
                ),
                (
                    "body",
                    models.JSONField(
                        help_text="Message body. Allowed fields are `attachments`, `body`, `text`, `icon_emoji`, `icon_url`, `metadata`, `username`.",  # noqa: E501
                        validators=[django_slack_tools.utils.slack.django.body_validator],
                        verbose_name="Body",
                    ),
                ),
                (
                    "ok",
                    models.BooleanField(
                        default=None,
                        help_text="Whether Slack API respond with OK. If never sent, will be `null`.",
                        null=True,
                        verbose_name="OK",
                    ),
                ),
                (
                    "permalink",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Permanent link for this message.",
                        max_length=256,
                        verbose_name="Permalink",
                    ),
                ),
                (
                    "ts",
                    models.CharField(
                        blank=True,
                        help_text="ID of an Slack message.",
                        max_length=32,
                        null=True,
                        unique=True,
                        verbose_name="Message ID",
                    ),
                ),
                (
                    "parent_ts",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="ID of current conversation thread.",
                        max_length=32,
                        verbose_name="Thread ID",
                    ),
                ),
                (
                    "request",
                    models.JSONField(
                        blank=True,
                        help_text="Dump of request content for debugging.",
                        null=True,
                        verbose_name="Request",
                    ),
                ),
                (
                    "response",
                    models.JSONField(
                        blank=True,
                        help_text="Dump of response content for debugging.",
                        null=True,
                        verbose_name="Response",
                    ),
                ),
                (
                    "exception",
                    models.TextField(blank=True, help_text="Exception message if any.", verbose_name="Exception"),
                ),
                (
                    "policy",
                    models.ForeignKey(
                        blank=True,
                        help_text="Messaging policy for this message.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="slack_messages.slackmessagingpolicy",
                        verbose_name="Messaging Policy",
                    ),
                ),
            ],
            options={
                "verbose_name": "Message",
                "verbose_name_plural": "Messages",
                "ordering": ("-created",),
            },
        ),
    ]
