import pytest

import vyper


def test_contract_size_exceeded():
    code = """
@external
def a() -> bool:
    q: Bytes[24577] = b"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"  # noqa: E501
    return True
"""
    with pytest.warns(vyper.warnings.ContractSizeLimitWarning):
        vyper.compile_code(code, ["bytecode_runtime"])
