# AUTOGENERATED! DO NOT EDIT! File to edit: 04_handy_dict.ipynb (unless otherwise specified).

__all__ = ['HandyDict']

# Internal Cell
from collections import UserDict

# Internal Cell
from .apply_keyed import apply_keyed
from .return_keyed import return_keyed
from .multi_get import multi_get

# Cell
class HandyDict(UserDict):

    def __getitem__(self, key):
        if isinstance(key, list):
            return return_keyed(self.data, key)
        else:
            return self.data[key]

    def apply(self, keys, action, ignore_non_existing=True):
        return HandyDict(apply_keyed(self.data, keys, action, ignore_non_existing))

    def multi_get(self, keys, default=None):
        if not isinstance(keys, list):
            keys = [keys]
        return multi_get(self.data, keys, default=default)