/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.tilings;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.tilings.Tiling;

public class TestTiling
extends TestCase {
    private final Tiling t1 = new Tiling(new DSymbol("1 3:1,1,1,1:4,3,4"));
    private final Tiling t2 = new Tiling(new DSymbol("2 3:2,1 2,1 2,2:6,3 2,6"));
    private final Tiling t3 = new Tiling(new DSymbol("1 2:1,1,1:4,4"));
    private final PeriodicGraph gr1 = PeriodicGraph.fromInvariantString("3   1 1 1 0 0   1 1 0 1 0   1 1 0 0 1");
    private final PeriodicGraph gr2 = PeriodicGraph.fromInvariantString("3   1 2 0 0 0   1 2 1 0 0   1 2 0 1 0   1 2 0 0 1");
    private final PeriodicGraph gr3 = PeriodicGraph.fromInvariantString("2   1 1 1 0   1 1 0 1");

    public void testSkeleton() {
        Tiling.Skeleton sk1 = this.t1.getSkeleton();
        Tiling.Skeleton sk2 = this.t2.getSkeleton();
        Tiling.Skeleton sk3 = this.t3.getSkeleton();
        TestTiling.assertEquals((Object)this.gr1, (Object)sk1);
        TestTiling.assertEquals((Object)this.gr2, (Object)sk2);
        TestTiling.assertEquals((Object)this.gr3, (Object)sk3);
        TestTiling.assertFalse((boolean)this.gr1.equals(sk2));
        TestTiling.assertFalse((boolean)this.gr2.equals(sk1));
    }

    public void testDualSkeleton() {
        Tiling.Skeleton sk1 = this.t1.getDualSkeleton();
        Tiling.Skeleton sk2 = this.t2.getDualSkeleton();
        Tiling.Skeleton sk3 = this.t3.getDualSkeleton();
        TestTiling.assertEquals((Object)this.gr1, (Object)sk1);
        TestTiling.assertEquals((Object)this.gr2, (Object)sk2);
        TestTiling.assertEquals((Object)this.gr3, (Object)sk3);
        TestTiling.assertFalse((boolean)this.gr1.equals(sk2));
        TestTiling.assertFalse((boolean)this.gr2.equals(sk1));
    }

    public void testCornerShifts() {
        this.testCornerShifts(this.t1);
        this.testCornerShifts(this.t2);
        this.testCornerShifts(this.t3);
    }

    public void testCornerShifts(Tiling til) {
        DSCover<Integer> cover = til.getCover();
        int dim = ((DelaneySymbol)cover).dim();
        Iterator iterator = ((DelaneySymbol)cover).elements().iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            int i = 0;
            while (i <= dim) {
                int Di = ((DelaneySymbol)cover).op(i, D);
                Vector t = til.edgeTranslation(i, D);
                if (i != ((DelaneySymbol)cover).dim()) {
                    TestTiling.assertEquals((Object)Vector.zero(dim), (Object)t);
                }
                int j = 0;
                while (j < dim) {
                    if (j != i) {
                        Vector p = til.cornerShift(j, D);
                        Vector q = til.cornerShift(j, Di);
                        TestTiling.assertEquals((Object)q, (Object)p.minus(t));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void testVertexBarycentricPositions() {
        this.testVertexBarycentricPositions(this.t1);
        this.testVertexBarycentricPositions(this.t2);
        this.testVertexBarycentricPositions(this.t3);
    }

    public void testVertexBarycentricPositions(Tiling til) {
        DSCover<Integer> cover = til.getCover();
        int dim = ((DelaneySymbol)cover).dim();
        Iterator iterator = ((DelaneySymbol)cover).elements().iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            int i = 0;
            while (i <= dim) {
                int Di = ((DelaneySymbol)cover).op(i, D);
                Vector t = til.edgeTranslation(i, D);
                if (i != ((DelaneySymbol)cover).dim()) {
                    TestTiling.assertEquals((Object)Vector.zero(dim), (Object)t);
                }
                int j = 0;
                while (j < dim) {
                    if (j != i) {
                        Point p = til.vertexBarycentricPosition(j, D);
                        Point q = til.vertexBarycentricPosition(j, Di);
                        TestTiling.assertEquals((Object)q, (Object)p.minus(t));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void testBodies() {
        this.testBodies(this.t1);
        this.testBodies(this.t2);
    }

    public void testBodies(Tiling til) {
        DSCover<Integer> cov = til.getCover();
        List<Tiling.Tile> bodies = til.getTiles();
        IndexList idcs = IndexList.except(cov, 3);
        int n = cov.numberOfOrbits(idcs);
        HashSet<Integer> seen = new HashSet<Integer>();
        TestTiling.assertEquals((int)n, (int)bodies.size());
        int m = 0;
        for (Tiling.Tile b : bodies) {
            seen.addAll(Iterators.asList(cov.orbit(idcs, b.getChamber())));
            m = Math.max(m, b.getKind());
        }
        TestTiling.assertEquals((int)til.getSymbol().numberOfOrbits(idcs), (int)(m + 1));
        TestTiling.assertEquals((int)((DelaneySymbol)cov).size(), (int)seen.size());
    }

    public void testSpaceGroup() {
        this.testSpaceGroup(this.t1, "Pm-3m");
        this.testSpaceGroup(this.t2, "Fd-3m");
        this.testSpaceGroup(this.t3, "p4mm");
    }

    public void testSpaceGroup(Tiling til, String name) {
        TestTiling.assertEquals((String)name, (String)til.getSpaceGroup().getName());
    }
}

