/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.CrystalSystem;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.SpaceGroup;
import org.gavrog.joss.geometry.SpaceGroupCatalogue;
import org.gavrog.joss.geometry.SpaceGroupFinder;

public class TestSpaceGroupFinder
extends TestCase {
    public void setUp() {
    }

    public void tearDown() {
    }

    public void testGetCrystalSystem() {
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.MONOCLINIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "A121")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.MONOCLINIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "B112")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.MONOCLINIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "C121")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.MONOCLINIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "I121")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.ORTHORHOMBIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "A222")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.ORTHORHOMBIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "B222")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.ORTHORHOMBIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "C222")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.ORTHORHOMBIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "F222")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.ORTHORHOMBIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "I222")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.TETRAGONAL, (Object)new SpaceGroupFinder(new SpaceGroup(3, "P4")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.TETRAGONAL, (Object)new SpaceGroupFinder(new SpaceGroup(3, "I-4")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.TRIGONAL, (Object)new SpaceGroupFinder(new SpaceGroup(3, "P-3")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.TRIGONAL, (Object)new SpaceGroupFinder(new SpaceGroup(3, "R-3")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.HEXAGONAL_3D, (Object)new SpaceGroupFinder(new SpaceGroup(3, "P6")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.HEXAGONAL_3D, (Object)new SpaceGroupFinder(new SpaceGroup(3, "P-62c")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.CUBIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "P23")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.CUBIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "F23")).getCrystalSystem());
        TestSpaceGroupFinder.assertEquals((Object)CrystalSystem.CUBIC, (Object)new SpaceGroupFinder(new SpaceGroup(3, "I23")).getCrystalSystem());
    }

    public void testSettings() {
        StringBuffer failed = new StringBuffer(100);
        int countFailed = 0;
        String canonicalName = null;
        Set<Operator> canonicalOps = null;
        Iterator<String> iter = SpaceGroupCatalogue.allKnownSettings(3);
        while (iter.hasNext()) {
            SpaceGroupFinder finder;
            String name = iter.next();
            List<Operator> ops = SpaceGroupCatalogue.operators(3, name);
            CoordinateChange trans = SpaceGroupCatalogue.transform(3, name);
            if (trans.isOne()) {
                canonicalName = name.split(":")[0];
                canonicalOps = new SpaceGroup(3, ops).primitiveOperators();
            }
            if (!canonicalName.equals((finder = new SpaceGroupFinder(new SpaceGroup(3, ops))).getGroupName())) {
                String text = String.valueOf(name) + " ==> " + finder.getGroupName() + " (should be " + canonicalName + ")\n";
                failed.append(text);
                ++countFailed;
                continue;
            }
            CoordinateChange c = finder.getToStd();
            List<Operator> transformedOps = c.applyTo(ops);
            Set<Operator> probes = new SpaceGroup(3, transformedOps).primitiveOperators();
            if (probes.equals(canonicalOps)) continue;
            String text = String.valueOf(name) + ": transformation to standard setting not correct\n";
            failed.append(text);
            ++countFailed;
        }
        if (countFailed > 0) {
            failed.append(String.valueOf(countFailed) + " groups were not recognized.\n");
        }
        TestSpaceGroupFinder.assertEquals((String)"", (String)failed.toString());
    }

    public void test_dme() {
        ArrayList<Operator> ops = new ArrayList<Operator>();
        ops.add(new Operator("-x+1,-x+y-z,-z+1"));
        ops.add(new Operator("-x+1,-y+1,-z+1"));
        SpaceGroup G = new SpaceGroup(3, ops, true, false);
        SpaceGroupFinder finder = new SpaceGroupFinder(G);
        TestSpaceGroupFinder.assertEquals((String)"C12/m1", (String)finder.getGroupName());
    }
}

