/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import junit.framework.TestCase;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;

public class TestPoint
extends TestCase {
    final Point p = new Point(new int[]{1, 2, 3});
    final Point q = new Point(new double[]{1.0, 2.0, 4.0});
    final Matrix M;

    public TestPoint() {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[]{1, 3, 2, 2};
        this.M = new Matrix(nArrayArray);
    }

    public void testHashCode() {
        Point a = new Point(new int[]{1, 2, 3});
        Point b = new Point(new int[]{1, 2, 4});
        TestPoint.assertEquals((int)this.p.hashCode(), (int)a.hashCode());
        TestPoint.assertFalse((this.p.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    public void testIsExact() {
        TestPoint.assertTrue((boolean)this.p.isExact());
        TestPoint.assertFalse((boolean)this.q.isExact());
    }

    public void testZero() {
        try {
            this.p.zero();
            TestPoint.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testOne() {
        try {
            this.p.one();
            TestPoint.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testNegative() {
        try {
            this.p.negative();
            TestPoint.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testInverse() {
        try {
            this.p.inverse();
            TestPoint.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testPlus() {
        Vector v = new Vector(new double[]{1.0, 2.0, 4.0});
        Point s = new Point(new double[]{2.0, 4.0, 7.0});
        TestPoint.assertEquals((Object)s, (Object)this.p.plus(v));
    }

    public void testMinus() {
        Vector v = new Vector(new double[]{0.0, 0.0, 1.0});
        TestPoint.assertEquals((Object)v, (Object)this.q.minus(this.p));
        TestPoint.assertEquals((Object)this.p, (Object)this.q.minus(v));
    }

    public void testTimes() {
        Point a = new Point(new int[]{2, 2, 2});
        TestPoint.assertEquals((Object)a, (Object)this.p.times(new Operator(this.M)));
    }

    public void testCompareTo() {
        Point a = new Point(new int[]{1, 2, 3});
        TestPoint.assertTrue((this.p.compareTo(this.q) < 0 ? 1 : 0) != 0);
        TestPoint.assertTrue((this.q.compareTo(this.p) > 0 ? 1 : 0) != 0);
        TestPoint.assertTrue((this.p.compareTo(a) == 0 ? 1 : 0) != 0);
    }

    public void testFloor() {
        try {
            this.p.floor();
            TestPoint.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testToString() {
        String s = "Point(1,2,3)";
        TestPoint.assertEquals((String)"Point(1,2,3)", (String)this.p.toString());
    }

    public void testPointMatrix() {
        Point a = new Point(new int[]{1, 2, 3});
        TestPoint.assertEquals((Object)this.p, (Object)a);
    }

    public void testPointIArithmeticArray() {
        Point a = new Point(new IArithmetic[]{new Whole(1L), new Whole(2L), new Whole(3L)});
        TestPoint.assertEquals((Object)this.p, (Object)a);
    }

    public void testPointIntArray() {
        Point a = new Point(new int[]{1, 2, 3});
        TestPoint.assertEquals((Object)this.p, (Object)a);
    }

    public void testPointDoubleArray() {
        Point a = new Point(new double[]{1.0, 2.0, 4.0});
        TestPoint.assertEquals((Object)this.q, (Object)a);
    }

    public void testPointPoint() {
        Point a = new Point(this.p);
        TestPoint.assertEquals((Object)this.p, (Object)a);
    }

    public void testGetDimension() {
        TestPoint.assertEquals((int)3, (int)this.p.getDimension());
    }

    public void testGet() {
        TestPoint.assertEquals((Object)new Whole(2L), (Object)this.p.get(1));
    }

    public void testGetCoordinates() {
        Matrix A = new Matrix(new int[][]{{1, 2, 3}});
        TestPoint.assertEquals((Object)A, (Object)this.p.getCoordinates());
    }

    public void testOrigin() {
        Point z = new Point(new int[3]);
        TestPoint.assertEquals((Object)z, (Object)Point.origin(3));
    }
}

