/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gavrog.box.simple.DataFormatException;
import org.gavrog.box.simple.Strings;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.CrystalSystem;
import org.gavrog.joss.geometry.Operator;

public class SpaceGroupCatalogue {
    private static boolean preferSecondOrigin = true;
    private static boolean preferHexagonal = true;
    private static Table[] groupTables = new Table[5];
    private static Map<String, String> aliases = new HashMap<String, String>();
    private static Map<String, Lookup> lookup = new HashMap<String, Lookup>();
    private static final String tablePath = "org/gavrog/joss/geometry/sgtable.data";

    private SpaceGroupCatalogue() {
    }

    private static void parseGroups(String string) {
        block27: {
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            Table table = null;
            String string2 = null;
            while (true) {
                Object object;
                String string3;
                try {
                    string3 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                if (string3 == null) break block27;
                if (string3.length() == 0 || string3.trim().charAt(0) == '#') continue;
                int n = string3.indexOf(32);
                if (n > 0) {
                    int n2;
                    Object object2;
                    object = string3.trim().split("\\s+");
                    if (object[0].equalsIgnoreCase("alias")) {
                        aliases.put(object[1], object[2]);
                        continue;
                    }
                    if (object[0].equalsIgnoreCase("lookup")) {
                        CrystalSystem crystalSystem;
                        object2 = object[1];
                        n2 = object[3].charAt(0);
                        CoordinateChange coordinateChange = new CoordinateChange(new Operator(object[4]));
                        int n3 = coordinateChange.getDimension();
                        if (object[2].equals("oblique")) {
                            crystalSystem = CrystalSystem.OBLIQUE;
                        } else if (object[2].equals("rectangular")) {
                            crystalSystem = CrystalSystem.RECTANGULAR;
                        } else if (object[2].equals("square")) {
                            crystalSystem = CrystalSystem.SQUARE;
                        } else if (object[2].equals("monoclinic")) {
                            crystalSystem = CrystalSystem.MONOCLINIC;
                        } else if (object[2].equals("triclinic")) {
                            crystalSystem = CrystalSystem.TRICLINIC;
                        } else if (object[2].equals("orthorhombic")) {
                            crystalSystem = CrystalSystem.ORTHORHOMBIC;
                        } else if (object[2].equals("trigonal")) {
                            crystalSystem = CrystalSystem.TRIGONAL;
                        } else if (object[2].equals("tetragonal")) {
                            crystalSystem = CrystalSystem.TETRAGONAL;
                        } else if (object[2].equals("hexagonal")) {
                            crystalSystem = n3 == 2 ? CrystalSystem.HEXAGONAL_2D : CrystalSystem.HEXAGONAL_3D;
                        } else if (object[2].equals("cubic")) {
                            crystalSystem = CrystalSystem.CUBIC;
                        } else {
                            throw new RuntimeException(object[2] + " system unknown");
                        }
                        lookup.put((String)object2, new Lookup((String)object2, crystalSystem, (char)n2, coordinateChange));
                        continue;
                    }
                    string2 = object[0];
                    object2 = new Operator(string3.substring(n + 1));
                    n2 = ((Operator)object2).getDimension();
                    if (groupTables[n2] == null) {
                        SpaceGroupCatalogue.groupTables[n2] = new Table(n2);
                    }
                    table = groupTables[n2];
                    table.nameToOps.put(string2, new LinkedList());
                    table.nameToTransform.put(string2, new CoordinateChange((Operator)object2));
                    table.namesInOrder.add(string2);
                    continue;
                }
                if (string2 == null) break;
                object = new Operator(string3).modZ();
                table.nameToOps.get(string2).add((Operator)object);
            }
            throw new DataFormatException("error in space group table file");
        }
    }

    public static Iterator<String> allKnownSettings(int n) {
        if (groupTables[3] == null) {
            SpaceGroupCatalogue.load();
        }
        return SpaceGroupCatalogue.groupTables[n].namesInOrder.iterator();
    }

    public static String normalizedName(String string) {
        String string2 = string.split(":")[0];
        if (aliases.containsKey(string2)) {
            return aliases.get(string2);
        }
        return string2;
    }

    private static Entry retrieve(int n, String string) {
        String string2;
        if (groupTables[3] == null) {
            SpaceGroupCatalogue.load();
        }
        Table table = groupTables[n];
        String[] stringArray = string.split(":");
        String string3 = SpaceGroupCatalogue.normalizedName(string);
        String string4 = string2 = stringArray.length > 1 ? Strings.capitalized(stringArray[1]) : "";
        String[] stringArray2 = string3.charAt(0) == 'R' ? (string2.equals("R") ? new String[]{string3 + ":R"} : (string2.equals("H") ? new String[]{string3 + ":H"} : (SpaceGroupCatalogue.getPreferHexagonal() ? new String[]{string3 + ":H", string3 + ":R"} : new String[]{string3 + ":R", string3 + ":H"}))) : (string2.equals("1") ? new String[]{string3 + ":1", string3} : (string2.equals("2") ? new String[]{string3 + ":2", string3} : (SpaceGroupCatalogue.getPreferSecondOrigin() ? new String[]{string3, string3 + ":2", string3 + ":1"} : new String[]{string3, string3 + ":1", string3 + ":2"})));
        for (int i = 0; i < stringArray2.length; ++i) {
            String string5 = stringArray2[i];
            if (!table.nameToOps.containsKey(string5)) continue;
            return new Entry(string5, table.nameToOps.get(string5), table.nameToTransform.get(string5));
        }
        return null;
    }

    public static String listedName(int n, String string) {
        Entry entry = SpaceGroupCatalogue.retrieve(n, string);
        if (entry == null) {
            return null;
        }
        return entry.key;
    }

    public static List<Operator> operators(int n, String string) {
        Entry entry = SpaceGroupCatalogue.retrieve(n, string);
        if (entry == null) {
            return null;
        }
        return entry.ops;
    }

    public static CoordinateChange transform(int n, String string) {
        Entry entry = SpaceGroupCatalogue.retrieve(n, string);
        if (entry == null) {
            return null;
        }
        return entry.transform;
    }

    public static void load() {
        SpaceGroupCatalogue.parseGroups(tablePath);
    }

    public static Iterator<Lookup> lookupInfo() {
        if (groupTables[3] == null) {
            SpaceGroupCatalogue.load();
        }
        return lookup.values().iterator();
    }

    public static boolean getPreferHexagonal() {
        return preferHexagonal;
    }

    public static void setPreferHexagonal(boolean bl) {
        preferHexagonal = bl;
    }

    public static boolean getPreferSecondOrigin() {
        return preferSecondOrigin;
    }

    public static void setPreferSecondOrigin(boolean bl) {
        preferSecondOrigin = bl;
    }

    private static class Entry {
        public final String key;
        public final List<Operator> ops;
        public final CoordinateChange transform;

        public Entry(String string, List<Operator> list, CoordinateChange coordinateChange) {
            this.key = string;
            this.ops = list;
            this.transform = coordinateChange;
        }
    }

    static class Lookup {
        public final String name;
        public final CrystalSystem system;
        public final char centering;
        public final CoordinateChange fromStd;

        public Lookup(String string, CrystalSystem crystalSystem, char c, CoordinateChange coordinateChange) {
            this.name = string;
            this.system = crystalSystem;
            this.centering = c;
            this.fromStd = coordinateChange;
        }
    }

    private static class Table {
        public final Map<String, List<Operator>> nameToOps = new HashMap<String, List<Operator>>();
        public final Map<String, CoordinateChange> nameToTransform = new HashMap<String, CoordinateChange>();
        public final List<String> namesInOrder = new ArrayList<String>();

        public Table(int n) {
        }
    }
}

