/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.HashMapWithDefault;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.Rational;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.OperatorType;
import org.gavrog.joss.geometry.SpaceGroupCatalogue;
import org.gavrog.joss.geometry.SpaceGroupFinder;
import org.gavrog.joss.geometry.Vector;

public class SpaceGroup {
    private final int dimension;
    private final Set<Operator> operators;

    /*
     * WARNING - void declaration
     */
    public SpaceGroup(int n, Collection<Operator> collection, boolean bl, boolean bl2) {
        this.dimension = n;
        int n2 = n;
        for (Operator object32 : collection) {
            void var8_16;
            void var8_14;
            if (object32.getDimension() != n2) {
                throw new IllegalArgumentException("wrong dimension for operator " + object32);
            }
            boolean bl3 = false;
            while (var8_14 < n2) {
                for (int i = 0; i < n2; ++i) {
                    if (object32.get((int)var8_14, i) instanceof Whole) continue;
                    String string = "bad linear part for operator " + object32;
                    throw new IllegalArgumentException(string);
                }
                if (!object32.get((int)var8_14, n2).isZero()) {
                    String string = "bad last column for operator " + object32;
                    throw new IllegalArgumentException(string);
                }
                ++var8_14;
            }
            boolean bl4 = false;
            while (var8_16 < n2) {
                if (!(object32.get(n2, (int)var8_16) instanceof Rational)) {
                    String string = "bad translational part for operator " + object32;
                    throw new IllegalArgumentException(string);
                }
                ++var8_16;
            }
            if (!object32.get(n2, n2).isOne()) {
                String string = "bad last column for operator " + object32;
                throw new IllegalArgumentException(string);
            }
            Operator operator = object32.linearPart();
            if (operator.getCoordinates().determinant().abs().isOne()) continue;
            String string = "linear part of operator " + object32 + " is not unimodular";
            throw new IllegalArgumentException(string);
        }
        HashSet hashSet = new HashSet();
        for (Operator operator : collection) {
            hashSet.add(operator.modZ());
        }
        if (bl) {
            HashSet hashSet2 = new HashSet(hashSet);
            hashSet.clear();
            LinkedList<Operator> linkedList = new LinkedList<Operator>(hashSet2);
            while (linkedList.size() > 0) {
                Operator operator = (Operator)linkedList.removeFirst();
                for (Operator operator2 : hashSet2) {
                    Operator operator3 = ((Operator)operator.times(operator2)).modZ();
                    if (hashSet.contains(operator3)) continue;
                    hashSet.add(operator3);
                    linkedList.addLast(operator3);
                }
            }
        }
        if (bl2) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Operator operator = (Operator)iterator.next();
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    Operator operator2;
                    Operator operator4 = (Operator)iterator2.next();
                    operator2 = (Operator)operator.times(operator4.inverse());
                    if (hashSet.contains(operator2.modZ())) continue;
                    throw new IllegalArgumentException("operators form no group");
                }
            }
        }
        this.operators = Collections.unmodifiableSet(hashSet);
    }

    public SpaceGroup(int n, String string) {
        this(n, SpaceGroupCatalogue.operators(n, string), false, false);
    }

    public SpaceGroup(int n, Collection<Operator> collection) {
        this(n, collection, true, false);
    }

    public int getDimension() {
        return this.dimension;
    }

    public Set<Operator> getOperators() {
        return this.operators;
    }

    public String getName() {
        return new SpaceGroupFinder(this).getGroupName();
    }

    public Matrix primitiveCell() {
        int n = this.getDimension();
        Operator operator = Operator.identity(n);
        ArrayList<Matrix> arrayList = new ArrayList<Matrix>();
        for (Operator operator2 : this.operators) {
            Operator operator3 = operator2.linearPart();
            if (!operator3.equals(operator)) continue;
            arrayList.add(operator2.translationalPart().getCoordinates());
        }
        Matrix matrix = new Matrix(arrayList.size() + n, n);
        matrix.setSubMatrix(0, 0, Matrix.one(n));
        for (int i = 0; i < arrayList.size(); ++i) {
            matrix.setRow(i + n, (Matrix)arrayList.get(i));
        }
        Matrix.triangulate(matrix, null, true, true);
        if (matrix.rank() != n) {
            throw new RuntimeException("sorry, encountered a program bug");
        }
        return matrix.getSubMatrix(0, 0, n, n);
    }

    public Operator transformationToPrimitive() {
        Matrix matrix = Matrix.one(this.getDimension() + 1).mutableClone();
        matrix.setSubMatrix(0, 0, this.primitiveCell());
        return (Operator)new Operator(matrix).inverse();
    }

    public Set<Operator> primitiveOperators() {
        HashSet<Operator> hashSet = new HashSet<Operator>();
        Operator operator = this.transformationToPrimitive();
        Operator operator2 = (Operator)operator.inverse();
        for (Operator operator3 : this.getOperators()) {
            Operator operator4 = ((Operator)operator2.times(operator3).times(operator)).modZ();
            Operator operator5 = ((Operator)operator.times(operator4).times(operator2)).modZ();
            hashSet.add(operator5);
        }
        return hashSet;
    }

    public List<Operator> primitiveOperatorsSorted() {
        ArrayList<Operator> arrayList = new ArrayList<Operator>(this.primitiveOperators());
        Collections.sort(arrayList);
        return arrayList;
    }

    public Map<OperatorType, Set<Operator>> primitiveOperatorsByType() {
        HashMapWithDefault<OperatorType, Set<Operator>> hashMapWithDefault = new HashMapWithDefault<OperatorType, Set<Operator>>(){
            private static final long serialVersionUID = -4407523262570166538L;

            @Override
            public Set<Operator> makeDefault() {
                return new HashSet<Operator>();
            }
        };
        for (Operator operator : this.primitiveOperators()) {
            ((Set)hashMapWithDefault.get(new OperatorType(operator))).add(operator);
        }
        return hashMapWithDefault;
    }

    /*
     * WARNING - void declaration
     */
    public Matrix configurationSpaceForGramMatrix() {
        void var7_13;
        int n = this.getDimension();
        int n2 = n * (n + 1) / 2;
        Matrix matrix = new Matrix(n, n);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                Vector arithmeticBase = Vector.unit(n2, n3++);
                matrix.set(i, j, arithmeticBase);
                matrix.set(j, i, arithmeticBase);
            }
        }
        matrix.makeImmutable();
        ArrayList<Matrix> arrayList = new ArrayList<Matrix>();
        for (Operator operator : this.getOperators()) {
            Matrix matrix2 = operator.linearPartAsMatrix();
            Matrix matrix3 = (Matrix)matrix2.times(matrix).times(matrix2.transposed()).minus(matrix);
            for (int i = 0; i < n; ++i) {
                for (int j = i; j < n; ++j) {
                    arrayList.add(((Vector)matrix3.get(i, j)).getCoordinates());
                }
            }
        }
        Matrix matrix4 = new Matrix(arrayList.size(), n2);
        boolean bl = false;
        while (var7_13 < arrayList.size()) {
            matrix4.setRow((int)var7_13, (Matrix)arrayList.get((int)var7_13));
            ++var7_13;
        }
        Matrix.triangulate(matrix4, null, false, true);
        return LinearAlgebra.columnNullSpace(matrix4, true).transposed();
    }

    public Vector[] shiftSpace() {
        int n = this.getDimension();
        Set<Operator> set = this.primitiveOperators();
        Matrix matrix = new Matrix(n, n * set.size());
        Matrix matrix2 = Matrix.one(n);
        int n2 = 0;
        for (Operator operator : set) {
            Matrix matrix3 = (Matrix)operator.getCoordinates().getSubMatrix(0, 0, n, n).minus(matrix2);
            matrix.setSubMatrix(0, n2, matrix3);
            n2 += n;
        }
        return Vector.fromMatrix(LinearAlgebra.rowNullSpace(matrix, false));
    }
}

