/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.CrystalSystem;
import org.gavrog.joss.geometry.Lattices;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.SpaceGroupFinder;
import org.gavrog.joss.geometry.Vector;

public class CellCorrection {
    private final CoordinateChange coordinateChange;
    private final String groupName;

    public CellCorrection(SpaceGroupFinder spaceGroupFinder, Matrix matrix) {
        int n = matrix.numberOfRows();
        String string = spaceGroupFinder.getGroupName();
        CrystalSystem crystalSystem = spaceGroupFinder.getCrystalSystem();
        if (n != 3) {
            throw new UnsupportedOperationException("dimension must be 3");
        }
        if (crystalSystem != CrystalSystem.MONOCLINIC && crystalSystem != CrystalSystem.TRICLINIC) {
            this.coordinateChange = new CoordinateChange(Operator.identity(n));
        } else {
            Object object;
            Vector[] vectorArray;
            Vector[] vectorArray2;
            CoordinateChange coordinateChange = (CoordinateChange)spaceGroupFinder.getToStd().inverse();
            Vector vector = (Vector)Vector.unit(3, 0).times(coordinateChange);
            Vector vector2 = (Vector)Vector.unit(3, 1).times(coordinateChange);
            Vector vector3 = (Vector)Vector.unit(3, 2).times(coordinateChange);
            Vector[] vectorArray3 = new Vector[]{vector, vector2, vector3};
            if (crystalSystem == CrystalSystem.TRICLINIC) {
                vectorArray2 = Lattices.reducedLatticeBasis(vectorArray3, matrix);
            } else {
                vectorArray = new Vector[]{vector, vector3};
                object = Lattices.reducedLatticeBasis(vectorArray, matrix);
                vectorArray2 = new Vector[]{object[0], vector2, object[1]};
                if (Vector.dot(vectorArray2[0], vectorArray2[2], matrix).isPositive()) {
                    vectorArray2[2] = (Vector)vectorArray2[2].negative();
                }
                CoordinateChange coordinateChange2 = new CoordinateChange(Vector.toMatrix(vectorArray3));
                CoordinateChange coordinateChange3 = new CoordinateChange(Vector.toMatrix(vectorArray2));
                CoordinateChange coordinateChange4 = (CoordinateChange)coordinateChange2.inverse().times(coordinateChange3);
                Vector vector4 = ((Vector)new Vector(0, 0, 1).dividedBy(new Whole(2L)).times(coordinateChange4)).modZ();
                int n2 = vector4.get(0).isZero() ? 99 : (vector4.get(2).isZero() ? 97 : 110);
                Vector vector5 = ((Vector)new Vector(1, 0, 0).dividedBy(new Whole(2L)).times(coordinateChange4)).modZ();
                int n3 = vector5.get(0).isZero() ? 65 : (vector5.get(2).isZero() ? 67 : 73);
                boolean bl = string.contains("c");
                boolean bl2 = string.contains("C");
                boolean bl3 = false;
                if (bl2 && bl) {
                    switch (n3) {
                        case 73: {
                            string = string.replace('C', 'I').replace('c', 'a');
                            bl3 = n2 == 99;
                            break;
                        }
                        case 65: {
                            if (n2 == 110) {
                                string = string.replace('C', 'A').replace('c', 'n');
                                break;
                            }
                            bl3 = true;
                            break;
                        }
                        case 67: {
                            if (n2 != 110) break;
                            string = string.replace('C', 'A').replace('c', 'n');
                            bl3 = true;
                        }
                    }
                } else if (bl) {
                    switch (n2) {
                        case 110: {
                            string = string.replace('c', 'n');
                            break;
                        }
                        case 97: {
                            bl3 = true;
                        }
                    }
                } else if (bl2) {
                    switch (n3) {
                        case 73: {
                            string = string.replace('C', 'I');
                            break;
                        }
                        case 65: {
                            bl3 = true;
                        }
                    }
                }
                if (bl3) {
                    Vector vector6 = vectorArray2[0];
                    vectorArray2[0] = vectorArray2[2];
                    vectorArray2[2] = vector6;
                    vectorArray2[1] = (Vector)vectorArray2[1].negative();
                }
                if (Vector.volume3D(vectorArray2[0], vectorArray2[1], vectorArray2[2]).isNegative()) {
                    vectorArray2[1] = (Vector)vectorArray2[1].negative();
                }
            }
            vectorArray = new CoordinateChange(Vector.toMatrix(vectorArray3));
            object = new CoordinateChange(Vector.toMatrix(vectorArray2));
            this.coordinateChange = (CoordinateChange)vectorArray.inverse().times(object);
        }
        this.groupName = string;
    }

    public CoordinateChange getCoordinateChange() {
        return this.coordinateChange;
    }

    public String getGroupName() {
        return this.groupName;
    }
}

