/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static <T> boolean mayBecomeSpherical2D(DelaneySymbol<T> symbol) {
        int b;
        int a;
        if (symbol.dim() != 2) {
            throw new IllegalArgumentException("symbol must be 2-dimensional");
        }
        DSymbol ds = new DSymbol(symbol.orientedCover());
        ds.setVDefaultToOne(true);
        if (!ds.curvature2D().isPositive()) {
            return false;
        }
        ArrayList<Integer> degrees = new ArrayList<Integer>();
        int undefined = 0;
        int i = 0;
        while (i < 2) {
            int j = i + 1;
            while (j <= 2) {
                IndexList idcs = new IndexList(i, j);
                Iterator iterator = ds.orbitReps(idcs).iterator();
                while (iterator.hasNext()) {
                    int D = (Integer)iterator.next();
                    if (ds.definesV(i, j, D)) {
                        int v = ds.v(i, j, D);
                        if (v <= 1) continue;
                        degrees.add(v);
                        continue;
                    }
                    ++undefined;
                }
                ++j;
            }
            ++i;
        }
        int n = degrees.size();
        return !(n == 2 ? (a = ((Integer)Collections.max(degrees)).intValue()) != (b = ((Integer)Collections.min(degrees)).intValue()) && (a > 5 && b > 2 || b > 3 || undefined == 0) : n == 1 && undefined == 0);
    }

    public static <T> boolean mayBecomeLocallyEuclidean3D(DelaneySymbol<T> symbol) {
        if (symbol.dim() != 3) {
            throw new IllegalArgumentException("symbol must be 3-dimensional");
        }
        DSymbol ds = new DSymbol(symbol);
        int k = 0;
        while (k <= ds.dim()) {
            IndexList idcs = new IndexList(ds);
            idcs.remove(k);
            Iterator iterator = ds.orbitReps(idcs).iterator();
            while (iterator.hasNext()) {
                int D = (Integer)iterator.next();
                Subsymbol<Integer> sub = new Subsymbol<Integer>(ds, idcs, D);
                if (Utils.mayBecomeSpherical2D(sub)) continue;
                return false;
            }
            ++k;
        }
        return true;
    }
}

