/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SplitEdges2d
extends IteratorAdapter<DSymbol> {
    private static final IndexList idcsEdge2d = new IndexList(0, 2);
    private final DSymbol base;
    private final int targetSize;
    final int[] orbRep;
    final int[] orbSize;
    final int[] orbAdded;
    int currentSize;
    final Set<NiftyList<Integer>> results = new HashSet<NiftyList<Integer>>();

    public SplitEdges2d(DSymbol base, int size) {
        this.base = base;
        this.targetSize = size;
        this.currentSize = base.size();
        ArrayList<List<Integer>> orbits = new ArrayList<List<Integer>>();
        Iterator iterator = base.orbitReps(idcsEdge2d).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            List<Integer> orbit = Iterators.asList(base.orbit(idcsEdge2d, D));
            orbits.add(orbit);
        }
        Collections.sort(orbits, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> l0, List<?> l1) {
                return l1.size() - l0.size();
            }
        });
        int n = orbits.size();
        this.orbRep = new int[n];
        this.orbSize = new int[n];
        this.orbAdded = new int[n];
        int i = 0;
        while (i < n) {
            List orb = (List)orbits.get(i);
            this.orbRep[i] = (Integer)orb.get(0);
            this.orbSize[i] = orb.size();
            this.orbAdded[i] = 0;
            ++i;
        }
        if (this.currentSize == this.targetSize) {
            this.orbAdded[n - 1] = -this.orbSize[n - 1];
            this.currentSize -= this.orbSize[n - 1];
        }
    }

    @Override
    protected DSymbol findNext() throws NoSuchElementException {
        DSymbol ds;
        NiftyList<Integer> invariant;
        do {
            int target = this.targetSize;
            int i = this.orbRep.length - 1;
            while (i >= 0 && this.currentSize + this.orbSize[i] > target) {
                this.currentSize -= this.orbAdded[i];
                this.orbAdded[i] = 0;
                --i;
            }
            if (i < 0) {
                throw new NoSuchElementException("at end");
            }
            int n = i;
            this.orbAdded[n] = this.orbAdded[n] + this.orbSize[i];
            this.currentSize += this.orbSize[i];
        } while (this.currentSize != this.targetSize || this.results.contains(invariant = (ds = this.augmented()).invariant()));
        this.results.add(invariant);
        return ds;
    }

    private DSymbol augmented() {
        DynamicDSymbol ds = new DynamicDSymbol(this.base);
        int i = 0;
        while (i < this.orbRep.length) {
            int size = this.orbSize[i];
            int added = this.orbAdded[i];
            if (added != 0) {
                int[] op2;
                int[] op0;
                int[] D = new int[size + added];
                D[0] = this.orbRep[i];
                switch (size) {
                    case 1: {
                        op0 = new int[1];
                        op2 = new int[1];
                        break;
                    }
                    case 2: {
                        if (ds.op(0, D[0]).equals(D[0])) {
                            D[1] = ds.op(2, D[0]);
                            int[] nArray = new int[2];
                            nArray[1] = 1;
                            op0 = nArray;
                        } else {
                            D[1] = ds.op(0, D[0]);
                            int[] nArray = new int[2];
                            nArray[0] = 1;
                            op0 = nArray;
                        }
                        if (ds.op(2, D[0]).equals(D[0])) {
                            int[] nArray = new int[2];
                            nArray[1] = 1;
                            op2 = nArray;
                            break;
                        }
                        int[] nArray = new int[2];
                        nArray[0] = 1;
                        op2 = nArray;
                        break;
                    }
                    case 4: {
                        D[1] = ds.op(0, D[0]);
                        D[2] = ds.op(2, D[1]);
                        D[3] = ds.op(0, D[2]);
                        int[] nArray = new int[4];
                        nArray[0] = 1;
                        nArray[2] = 3;
                        nArray[3] = 2;
                        op0 = nArray;
                        int[] nArray2 = new int[4];
                        nArray2[0] = 3;
                        nArray2[1] = 2;
                        nArray2[2] = 1;
                        op2 = nArray2;
                        break;
                    }
                    default: {
                        throw new RuntimeException("this should not happen");
                    }
                }
                int[] v = new int[size];
                int k = 0;
                while (k < size) {
                    int E = D[k];
                    v[k] = ds.v(0, 1, E);
                    ds.undefineOp(0, E);
                    ++k;
                }
                List<Integer> newElements = ds.grow(added);
                int k2 = 0;
                while (k2 < added) {
                    D[size + k2] = newElements.get(k2);
                    ++k2;
                }
                int n = added / size;
                int k3 = 1;
                while (k3 <= n) {
                    int m = 0;
                    while (m < size) {
                        ds.redefineV(0, 1, D[k3 * size + m], v[m]);
                        ++m;
                    }
                    ++k3;
                }
                int idx = 0;
                int k4 = 0;
                while (k4 <= n) {
                    int m = 0;
                    while (m < size) {
                        int E = D[k4 * size + m];
                        int E2 = D[k4 * size + op2[m]];
                        ds.redefineOp(2, E, E2);
                        int Ei = k4 < n ? D[(k4 + 1) * size + m] : D[k4 * size + op0[m]];
                        ds.redefineOp(idx, E, Ei);
                        ++m;
                    }
                    idx = 1 - idx;
                    ++k4;
                }
                k4 = size;
                while (k4 < D.length) {
                    int E = D[k4];
                    ds.redefineV(1, 2, E, 2 / ds.r(1, 2, E));
                    ++k4;
                }
            }
            ++i;
        }
        return new DSymbol(ds);
    }
}

