/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.dsyms.basic.DSMorphism;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.derived.EuclidicityTester;
import org.gavrog.joss.dsyms.generators.InputIterator;
import org.gavrog.joss.dsyms.generators.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineBranching3d
extends IteratorAdapter<DSymbol> {
    private static final boolean LOGGING = false;
    private final List<Integer> acceptedValues;
    private final boolean allowEdgeDegreeTwo;
    private final int size;
    private final int dim;
    private final Map<Integer, Integer> nextValue;
    private final List<DSMorphism<Integer, Integer>> inputAutomorphisms;
    boolean immediate = false;
    private final DynamicDSymbol current;
    private final LinkedList<Move> stack;
    int countNonSpherical = 0;
    private static final List<Integer> standardValues = Collections.unmodifiableList(Arrays.asList(1, 2, 3, 4, 6));

    public <T> DefineBranching3d(DelaneySymbol<T> ds) {
        this(ds, standardValues, false);
    }

    public <T> DefineBranching3d(DelaneySymbol<T> ds, boolean allowEdgeDegreeTwo) {
        this(ds, standardValues, allowEdgeDegreeTwo);
    }

    public <T> DefineBranching3d(DelaneySymbol<T> ds, List<Integer> acceptedValues) {
        this(ds, acceptedValues, false);
    }

    public <T> DefineBranching3d(DelaneySymbol<T> ds, List<Integer> acceptedValues, boolean allowEdgeDegreeTwo) {
        this.check(ds, acceptedValues);
        this.acceptedValues = acceptedValues;
        this.allowEdgeDegreeTwo = allowEdgeDegreeTwo;
        this.nextValue = new HashMap<Integer, Integer>();
        HashSet<Integer> seen = new HashSet<Integer>();
        seen.add(null);
        int previous = 0;
        for (int v : this.acceptedValues) {
            if (seen.contains(v)) continue;
            this.nextValue.put(previous, v);
            seen.add(v);
            previous = v;
        }
        this.size = ds.size();
        this.dim = ds.dim();
        this.stack = new LinkedList();
        this.current = new DynamicDSymbol(new DSymbol(ds.canonical()));
        this.inputAutomorphisms = DSMorphism.automorphisms(this.current);
        int i = 0;
        while (i < this.dim) {
            int j = i + 1;
            IndexList idcs = new IndexList(i, j);
            Iterator iterator = this.current.orbitReps(idcs).iterator();
            while (iterator.hasNext()) {
                int D = (Integer)iterator.next();
                if (!this.current.definesV(i, j, D)) continue;
                boolean success = this.performMove(new Move(i, D, this.current.v(i, j, D), true));
                this.stack.clear();
                if (success) continue;
                return;
            }
            ++i;
        }
        Move choice = this.nextChoice(-1, 1);
        if (choice == null) {
            this.immediate = true;
        } else {
            this.stack.addLast(choice);
        }
    }

    private <T> void check(DelaneySymbol<T> ds, List<Integer> acceptedValues) {
        if (ds == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (ds.dim() != 3) {
            throw new IllegalArgumentException("dimension must be 3");
        }
        try {
            ds.size();
        }
        catch (UnsupportedOperationException ex) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        if (!ds.isConnected()) {
            throw new UnsupportedOperationException("symbol must be connected");
        }
        for (T D : ds.elements()) {
            for (int i : ds.indices()) {
                if (ds.definesOp(i, D)) continue;
                throw new UnsupportedOperationException("symbol must define all ops");
            }
        }
        if (!acceptedValues.contains(new Integer(1))) {
            throw new UnsupportedOperationException("1 must be an accepted branching value.");
        }
        if (!acceptedValues.contains(new Integer(2))) {
            throw new UnsupportedOperationException("2 must be an accepted branching value.");
        }
        if (!Utils.mayBecomeLocallyEuclidean3D(ds)) {
            throw new IllegalArgumentException("symbol must have positive local curvatures");
        }
    }

    @Override
    protected DSymbol findNext() throws NoSuchElementException {
        if (this.immediate) {
            this.immediate = false;
            return new DSymbol(this.current);
        }
        while (true) {
            Move choice;
            if ((choice = this.undoLastChoice()) == null) {
                throw new NoSuchElementException();
            }
            Move move = this.nextMove(choice);
            if (move == null || !this.performMove(move) || !this.isCanonical()) continue;
            Move next = this.nextChoice(choice.index, choice.element);
            if (next == null) {
                return new DSymbol(this.current);
            }
            this.stack.addLast(next);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Move nextChoice(int lastIndex, int lastElement) {
        D = lastElement;
        i = lastIndex;
        ** GOTO lbl10
        {
            if (!this.current.definesV(++i, i + 1, D)) {
                return new Move(i, D, 0, true);
            }
            do {
                if (i < this.dim - 1) continue block0;
                ++D;
                i = -1;
lbl10:
                // 2 sources

            } while (D <= this.size);
        }
        return null;
    }

    private Move undoLastChoice() {
        Move last;
        do {
            if (this.stack.size() == 0) {
                return null;
            }
            last = this.stack.removeLast();
            this.current.undefineV(last.index, last.index + 1, last.element);
        } while (!last.isChoice);
        return last;
    }

    private Move nextMove(Move choice) {
        Integer next = this.nextValue.get(choice.value);
        if (next == null) {
            return null;
        }
        return new Move(choice.index, choice.element, next, true);
    }

    private boolean performMove(Move initial) {
        DynamicDSymbol ds = this.current;
        LinkedList<Move> queue = new LinkedList<Move>();
        queue.addLast(initial);
        boolean firstMove = true;
        while (queue.size() > 0) {
            int k;
            Move move = (Move)queue.removeFirst();
            int i = move.index;
            int D = move.element;
            if (ds.definesV(i, i + 1, D)) {
                if (ds.v(i, i + 1, D) == move.value) {
                    if (!firstMove) {
                        continue;
                    }
                } else {
                    if (move == initial) {
                        throw new IllegalArgumentException("Internal error: received illegal move.");
                    }
                    return false;
                }
            }
            firstMove = false;
            ds.redefineV(i, i + 1, D, move.value);
            this.stack.addLast(move);
            if (i == 0 && ds.m(i, i + 1, D) < 3) {
                return false;
            }
            if (i == 2 && ds.m(i, i + 1, D) < (this.allowEdgeDegreeTwo ? 2 : 3)) {
                return false;
            }
            List<Move> extraDeductions = this.getExtraDeductions(ds, move);
            if (extraDeductions == null) {
                return false;
            }
            queue.addAll(extraDeductions);
            int j = 0;
            while (j <= this.dim) {
                if (j == i - 1 || j == i + 2) {
                    IndexList idcs = new IndexList(i, i + 1, j);
                    Subsymbol<Integer> sub = new Subsymbol<Integer>(ds, idcs, D);
                    List<Move> deductions = this.getDeductions(sub);
                    if (deductions == null) {
                        ++this.countNonSpherical;
                        return false;
                    }
                    queue.addAll(deductions);
                }
                ++j;
            }
            if (i == 0) {
                k = 3;
            } else {
                if (i != 2) continue;
                k = 0;
            }
            Integer Dk = this.current.op(k, D);
            Move deduction = new Move(i, Dk, move.value, false);
            if (ds.definesV(i, i + 1, Dk)) {
                if (ds.v(i, i + 1, Dk) == move.value) continue;
                return false;
            }
            queue.addLast(deduction);
        }
        return true;
    }

    private boolean isCanonical() {
        for (DSMorphism<Integer, Integer> map : this.inputAutomorphisms) {
            if (DefineBranching3d.compareWithPermuted(this.current, map) <= 0) continue;
            return false;
        }
        return true;
    }

    private static <T> int compareWithPermuted(DelaneySymbol<T> ds, DSMorphism<T, T> map) {
        for (T D1 : ds.elements()) {
            T D2 = map.getASource(D1);
            int i = 0;
            while (i < ds.dim()) {
                int v2;
                int v1 = ds.definesV(i, i + 1, D1) ? ds.v(i, i + 1, D1) : 0;
                int n = v2 = ds.definesV(i, i + 1, D2) ? ds.v(i, i + 1, D2) : 0;
                if (v1 != v2) {
                    if (v1 == 0) {
                        return 1;
                    }
                    if (v2 == 0) {
                        return -1;
                    }
                    return v1 - v2;
                }
                ++i;
            }
        }
        return 0;
    }

    private List<Move> getDeductions(DelaneySymbol<Integer> ds) {
        int a;
        if (ds.dim() != 2) {
            throw new IllegalArgumentException("symbol must be 2-dimensional");
        }
        ds.setVDefaultToOne(true);
        if (!ds.curvature2D().isPositive()) {
            return null;
        }
        IndexList allIndices = new IndexList(ds);
        boolean oriented = ds.isOriented();
        LinkedList<Move> result = new LinkedList<Move>();
        ArrayList<Integer> degrees = new ArrayList<Integer>();
        class Undefined {
            public final int i;
            public final int D;
            public final boolean twice;

            public Undefined(int i, int D, boolean twice) {
                this.i = i;
                this.D = D;
                this.twice = twice;
            }
        }
        ArrayList<Undefined> undefined = new ArrayList<Undefined>();
        boolean singleUndefinedExists = false;
        int ii = 0;
        while (ii < 2) {
            int i = (Integer)allIndices.get(ii);
            int jj = ii + 1;
            while (jj <= 2) {
                int j = (Integer)allIndices.get(jj);
                IndexList idcs = new IndexList(i, j);
                for (int D : ds.orbitReps(idcs)) {
                    boolean twice;
                    boolean bl = twice = !oriented && ds.orbitIsOriented(idcs, D);
                    if (ds.definesV(i, j, D)) {
                        int v = ds.v(i, j, D);
                        if (v <= 1) continue;
                        degrees.add(v);
                        if (!twice) continue;
                        degrees.add(v);
                        continue;
                    }
                    if (j != i + 1) {
                        throw new RuntimeException("this should not happen");
                    }
                    undefined.add(new Undefined(i, D, twice));
                    if (twice) continue;
                    singleUndefinedExists = true;
                }
                ++jj;
            }
            ++ii;
        }
        int n = degrees.size();
        if (n == 3) {
            for (Undefined orb : undefined) {
                result.add(new Move(orb.i, orb.D, 1, false));
            }
        } else if (n == 2) {
            int b;
            a = (Integer)Collections.max(degrees);
            if (a != (b = ((Integer)Collections.min(degrees)).intValue())) {
                if (a > 5 && b > 2 || b > 3 || undefined.size() == 0 || !singleUndefinedExists) {
                    return null;
                }
                if (undefined.size() == 1) {
                    Undefined orb = (Undefined)undefined.get(0);
                    if (!orb.twice && (a <= 5 && b == 3 || a >= 5 && b == 2)) {
                        result.add(new Move(orb.i, orb.D, 2, false));
                    }
                }
            } else if (a >= 4 || !singleUndefinedExists) {
                for (Undefined orb : undefined) {
                    result.add(new Move(orb.i, orb.D, 1, false));
                }
            }
        } else if (n == 1) {
            a = (Integer)degrees.get(0);
            if (undefined.size() == 0) {
                return null;
            }
            if (undefined.size() == 1) {
                Undefined orb = (Undefined)undefined.get(0);
                if (orb.twice) {
                    if (a != 2) {
                        result.add(new Move(orb.i, orb.D, 2, false));
                    }
                } else {
                    result.add(new Move(orb.i, orb.D, (Integer)degrees.get(0), false));
                }
            }
        } else if (n == 0 && undefined.size() == 1) {
            Undefined orb = (Undefined)undefined.get(0);
            if (!orb.twice) {
                result.add(new Move(orb.i, orb.D, 1, false));
            }
        }
        return result;
    }

    protected List<Move> getExtraDeductions(DelaneySymbol<Integer> ds, Move move) {
        return new ArrayList<Move>();
    }

    public static void main(String[] args) {
        boolean verbose = false;
        boolean check = true;
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            if (args[i].equals("-v")) {
                verbose = !verbose;
            } else if (args[i].equals("-e")) {
                check = !check;
            } else {
                System.err.println("Unknown option '" + args[i] + "'");
            }
            ++i;
        }
        InputIterator syms = args.length > i ? Iterators.singleton(new DSymbol(args[i])) : new InputIterator(new BufferedReader(new InputStreamReader(System.in)));
        int inCount = 0;
        int outCount = 0;
        int countGood = 0;
        int countAmbiguous = 0;
        while (syms.hasNext()) {
            DSymbol ds = (DSymbol)syms.next();
            DefineBranching3d iter = new DefineBranching3d(ds);
            ++inCount;
            try {
                while (iter.hasNext()) {
                    DSymbol out = (DSymbol)iter.next();
                    ++outCount;
                    if (check) {
                        EuclidicityTester tester = new EuclidicityTester(out);
                        if (tester.isAmbiguous()) {
                            System.out.println("??? " + out);
                            ++countAmbiguous;
                            continue;
                        }
                        if (!tester.isGood()) continue;
                        System.out.println(out);
                        ++countGood;
                        continue;
                    }
                    System.out.println(out);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        System.err.println("Processed " + inCount + " input symbols.");
        System.err.println("Produced " + outCount + " output symbols.");
        if (check) {
            System.err.println("Of the latter, " + countGood + " were found euclidean.");
            if (countAmbiguous > 0) {
                System.err.println("For " + countAmbiguous + " symbols, euclidicity could not yet be decided.");
            }
        }
        System.err.println("Options: " + (check ? "" : "no") + " euclidicity check, " + (verbose ? "verbose" : "quiet") + ".");
    }

    protected class Move {
        public final int index;
        public final int element;
        public final int value;
        public final boolean isChoice;

        public Move(int index, int element, int value, boolean isChoice) {
            this.index = index;
            this.element = element;
            this.value = value;
            this.isChoice = isChoice;
        }

        public String toString() {
            return "Move(" + this.index + ", " + this.element + ", " + this.value + ", " + this.isChoice + ")";
        }
    }
}

