/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;

public class Boundary<T> {
    private DelaneySymbol<T> ds;
    private HashSet<Face<T>> onBoundary;
    private HashMap<Face<T>, Face<T>> neighbor;
    private HashMap<Face<T>, Integer> count;

    public Boundary(DelaneySymbol<T> delaneySymbol) {
        this.ds = delaneySymbol;
        this.onBoundary = new HashSet();
        this.neighbor = new HashMap();
        this.count = new HashMap();
        for (int n : delaneySymbol.indices()) {
            for (T t : delaneySymbol.elements()) {
                this.onBoundary.add(new Face<T>(n, t));
                for (int n2 : delaneySymbol.indices()) {
                    this.count.put(new Face<T>(n, t, n2), 1);
                    this.neighbor.put(new Face<T>(n, t, n2), new Face<T>(n2, t));
                }
            }
        }
    }

    public boolean isOnBoundary(int n, T t) {
        return this.onBoundary.contains(new Face<T>(n, t));
    }

    public Face<T> neighbor(int n, T t, int n2) {
        if (!this.isOnBoundary(n, t)) {
            String string = "(" + n + "," + t + ") not on boundary.";
            throw new IllegalArgumentException(string);
        }
        return this.neighbor.get(new Face<T>(n, t, n2));
    }

    public int glueCountAtRidge(int n, T t, int n2) {
        if (!this.isOnBoundary(n, t)) {
            String string = "(" + n + "," + t + ") must be on boundary.";
            throw new UnsupportedOperationException(string);
        }
        return this.count.get(new Face<T>(n, t, n2));
    }

    public void glue(DSPair<T> dSPair) {
        this.glue(dSPair.getIndex(), dSPair.getElement());
    }

    public void glue(int n, T t) {
        T t2 = this.ds.op(n, t);
        Face<T> face = new Face<T>(n, t);
        Face<T> face2 = new Face<T>(n, t2);
        if (!this.onBoundary.contains(face)) {
            String string = "(" + n + "," + t + ") not on boundary.";
            throw new IllegalArgumentException(string);
        }
        for (int n2 : this.ds.indices()) {
            if (n2 == n) continue;
            Face<T> face3 = this.neighbor.get(new Face<T>(n, t, n2));
            Face<T> face4 = this.neighbor.get(new Face<T>(n, t2, n2));
            int n3 = this.glueCountAtRidge(n, t, n2) + this.glueCountAtRidge(n, t2, n2);
            Face<T> face5 = new Face<T>(face3, n + n2 - face3.getFirstIndex());
            this.neighbor.put(face5, face4);
            this.count.put(face5, n3);
            Face<T> face6 = new Face<T>(face4, n + n2 - face4.getFirstIndex());
            this.neighbor.put(face6, face3);
            this.count.put(face6, n3);
        }
        this.onBoundary.remove(face);
        this.onBoundary.remove(face2);
    }

    public void glueAndEnqueue(int n, T t, LinkedList<Face<T>> linkedList) {
        for (int n2 : this.ds.indices()) {
            if (n2 == n) continue;
            Face<T> face = this.neighbor(n, t, n2);
            T t2 = face.getElement();
            int n3 = face.getFirstIndex();
            int n4 = n + n2 - n3;
            linkedList.addLast(new Face<T>(n3, t2, n4));
        }
        this.glue(n, t);
    }

    static class Face<T> {
        int i;
        int j;
        T D;

        public Face(int n, T t, int n2) {
            this.i = n;
            this.D = t;
            this.j = n2;
        }

        public Face(int n, T t) {
            this(n, t, -1);
        }

        public Face(Face<T> face, int n) {
            this(face.i, face.D, n);
        }

        public int getFirstIndex() {
            return this.i;
        }

        public T getElement() {
            return this.D;
        }

        public int getSecondIndex() {
            return this.j;
        }

        public int hashCode() {
            return (this.i * 37 + this.D.hashCode()) * 37 + this.j;
        }

        public boolean equals(Object object) {
            if (object instanceof Face) {
                Face face = (Face)object;
                return this.D.equals(face.D) && this.i == face.i && this.j == face.j;
            }
            return false;
        }
    }
}

