/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.HashSet;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.NonSphericalException;
import org.gavrog.joss.dsyms.basic.Subsymbol;

public class TestDelaneySymbol
extends TestCase {
    private String code;
    private DelaneySymbol ds1;
    private DelaneySymbol ds2;
    private DelaneySymbol ds3;
    private DelaneySymbol ds4;
    private DelaneySymbol sub1;
    private DelaneySymbol sub2;

    protected void setUp() throws Exception {
        super.setUp();
        this.code = "<1.1:8 3:2 8 7 6,3 4 5 6 8,1 2 8 5 7,2 4 6 8:3 4,5 3,4 3>";
        this.ds1 = new DSymbol(this.code);
        this.ds2 = new DSymbol("8:2 4 6 8,8 3 5 7,6 5 8 7:4,4");
        this.ds3 = new DSymbol("8:2 4 6 8,8 3 5 7,6 5 7 8:4,4");
        this.ds4 = new DSymbol("<1.1:1:1,1,1:4,3>");
        this.sub1 = new Subsymbol<Integer>(this.ds1, new IndexList(1, 2), new Integer(1));
        this.sub2 = new Subsymbol<Integer>(this.ds1, new IndexList(0, 1, 2), new Integer(1));
    }

    protected void tearDown() throws Exception {
        this.code = null;
        this.ds1 = null;
        this.ds2 = null;
        this.ds3 = null;
        this.ds4 = null;
        this.sub1 = null;
        this.sub2 = null;
        super.tearDown();
    }

    public void testTabularDisplay() {
        String out1 = "   D |  op0  op1  op2  op3 |  v01  v12  v23\n-----+---------------------+----------------\n   1 |    2    3    1    2 |    1    1    2\n   2 |    1    4    2    1 |    1    1    2\n   3 |    8    1    8    4 |    1    1    1\n   4 |    7    2    5    3 |    1    1    1\n   5 |    6    5    4    6 |    2    1    1\n   6 |    5    6    7    5 |    2    1    1\n   7 |    4    8    6    8 |    1    1    1\n   8 |    3    7    3    7 |    1    1    1\n";
        Assert.assertEquals((String)out1, (String)this.ds1.tabularDisplay());
        String out2 = "   D |  op1  op2 |  v12\n-----+-----------+------\n   1 |    3    1 |    1\n   3 |    1    8 |    1\n   6 |    6    7 |    1\n   7 |    8    6 |    1\n   8 |    7    3 |    1\n";
        Assert.assertEquals((String)out2, (String)this.sub1.tabularDisplay());
    }

    public void testHasStandardIndexSet() {
        Assert.assertTrue((boolean)this.ds1.hasStandardIndexSet());
        Assert.assertFalse((boolean)this.sub1.hasStandardIndexSet());
    }

    public void testIsComplete() {
        TestDelaneySymbol.assertTrue((boolean)this.ds1.isComplete());
        TestDelaneySymbol.assertTrue((boolean)this.sub1.isComplete());
        TestDelaneySymbol.assertFalse((boolean)new DSymbol("2:1 0,2,2:4,4").isComplete());
        TestDelaneySymbol.assertFalse((boolean)new DSymbol("2:1 2,2,2:4,0").isComplete());
    }

    public void testR() {
        Assert.assertEquals((int)3, (int)this.ds1.r(0, 1, new Integer(1)));
        Assert.assertEquals((int)1, (int)this.ds1.r(0, 3, new Integer(1)));
    }

    public void testM() {
        Assert.assertEquals((int)3, (int)this.ds1.m(0, 1, new Integer(1)));
        Assert.assertEquals((int)2, (int)this.ds1.m(0, 2, new Integer(1)));
        Assert.assertEquals((int)2, (int)this.sub2.m(0, 2, new Integer(3)));
    }

    public void testNumberOfOrbits() {
        Assert.assertEquals((int)2, (int)this.ds1.numberOfOrbits(new IndexList(0, 1)));
        Assert.assertEquals((int)2, (int)this.ds1.numberOfOrbits(new IndexList(1, 2)));
    }

    public void testIsConnected() {
        Assert.assertTrue((boolean)this.ds1.isConnected());
        Assert.assertFalse((boolean)new DSymbol("2:1 2,1 2,1 2:3 4, 5 6").isConnected());
        Assert.assertTrue((boolean)new DSymbol("0").isConnected());
    }

    public void testOrbitRepresentatives() {
        IteratorAdapter iter = this.ds1.orbitReps(new IndexList(0, 1));
        HashSet reps = new HashSet();
        while (iter.hasNext()) {
            Object x = iter.next();
            Assert.assertFalse((boolean)reps.contains(x));
            reps.add(x);
        }
        Assert.assertEquals((int)2, (int)reps.size());
        Assert.assertTrue((boolean)reps.contains(new Integer(1)));
        Assert.assertTrue((boolean)reps.contains(new Integer(5)));
    }

    public void testElementsOfOrbit() {
        Integer seed = new Integer(2);
        IteratorAdapter<Integer> iter = this.ds1.orbit(new IndexList(0, 2), seed);
        HashSet reps = new HashSet();
        while (iter.hasNext()) {
            Object x = iter.next();
            Assert.assertFalse((boolean)reps.contains(x));
            reps.add(x);
        }
        Assert.assertEquals((int)2, (int)reps.size());
        Assert.assertTrue((boolean)reps.contains(new Integer(1)));
        Assert.assertTrue((boolean)reps.contains(new Integer(2)));
    }

    public void testIsOriented() {
        Assert.assertFalse((boolean)this.ds1.isOriented());
        Assert.assertTrue((boolean)this.ds2.isOriented());
        Assert.assertFalse((boolean)this.ds3.isOriented());
    }

    public void testIsLoopless() {
        Assert.assertFalse((boolean)this.ds1.isLoopless());
        Assert.assertTrue((boolean)this.ds2.isLoopless());
        Assert.assertTrue((boolean)this.ds3.isLoopless());
    }

    public void testIsWeaklyOriented() {
        Assert.assertTrue((boolean)this.ds1.isWeaklyOriented());
        Assert.assertTrue((boolean)this.ds2.isWeaklyOriented());
        Assert.assertFalse((boolean)this.ds3.isWeaklyOriented());
    }

    public void testCanonical() {
        String out = "<1.1:8 3:2 4 6 8,6 3 5 7 8,2 7 8 5 6,4 3 6 8:3 4,5 3,3 4>";
        Assert.assertEquals((String)out, (String)this.ds1.canonical().toString());
        DSymbol ds2 = new DSymbol("8:6 8 5 7,7 3 6 5 8,6 8 5 7:4 4,4 4");
        out = "<1.1:8:2 4 6 8,3 2 4 8 7,2 4 6 8:4 4,4 4>";
        Assert.assertEquals((String)out, (String)ds2.canonical().toString());
        TestDelaneySymbol.assertTrue((this.ds1.compareTo(ds2) > 0 ? 1 : 0) != 0);
    }

    public void testGetMapToCanonical() {
        Map map = this.ds1.getMapToCanonical();
        Assert.assertEquals((Object)new Integer(6), (Object)map.get(new Integer(1)));
        Assert.assertEquals((Object)new Integer(5), (Object)map.get(new Integer(2)));
        Assert.assertEquals((Object)new Integer(1), (Object)map.get(new Integer(3)));
        Assert.assertEquals((Object)new Integer(4), (Object)map.get(new Integer(4)));
        Assert.assertEquals((Object)new Integer(8), (Object)map.get(new Integer(5)));
        Assert.assertEquals((Object)new Integer(7), (Object)map.get(new Integer(6)));
        Assert.assertEquals((Object)new Integer(3), (Object)map.get(new Integer(7)));
        Assert.assertEquals((Object)new Integer(2), (Object)map.get(new Integer(8)));
    }

    public void testIsMinimal() {
        TestDelaneySymbol.assertTrue((boolean)this.ds1.isMinimal());
        TestDelaneySymbol.assertFalse((boolean)this.ds2.isMinimal());
        TestDelaneySymbol.assertFalse((boolean)this.ds3.isMinimal());
    }

    public void testMinimal() {
        DSymbol tiny = new DSymbol("<1.1:1:1,1,1:4,4>");
        Assert.assertEquals((Object)this.ds1, this.ds1.minimal());
        Assert.assertEquals((Object)tiny, this.ds2.minimal());
        Assert.assertEquals((Object)tiny, this.ds3.minimal());
    }

    public void testFlat() {
        String out = "   D |  op0  op1 |  v01\n-----+-----------+------\n   1 |    2    1 |    1\n   2 |    1    5 |    1\n   3 |    3    4 |    1\n   4 |    5    3 |    1\n   5 |    4    2 |    1\n";
        Assert.assertEquals((String)"   D |  op0  op1 |  v01\n-----+-----------+------\n   1 |    2    1 |    1\n   2 |    1    5 |    1\n   3 |    3    4 |    1\n   4 |    5    3 |    1\n   5 |    4    2 |    1\n", (String)this.sub1.flat().tabularDisplay());
    }

    public void testCurvature2D() {
        try {
            this.ds1.curvature2D();
            TestDelaneySymbol.fail((String)"should raise a UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.ds2.curvature2D().equals(new Whole(0L)));
        Assert.assertTrue((boolean)this.ds4.curvature2D().equals(new Fraction(1L, 12L)));
    }

    public void testSphericalGroupSize2D() {
        Assert.assertEquals((int)48, (int)this.ds4.sphericalGroupSize2D());
        try {
            this.ds2.sphericalGroupSize2D();
            TestDelaneySymbol.fail((String)"should raise a NonSphericalException");
        }
        catch (NonSphericalException nonSphericalException) {
            // empty catch block
        }
    }

    public void testIsSpherical2D() {
        try {
            this.ds1.isSpherical2D();
            TestDelaneySymbol.fail((String)"should raise a IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.ds3.isSpherical2D());
        Assert.assertTrue((boolean)this.ds4.isSpherical2D());
        TestDelaneySymbol.assertFalse((boolean)new DSymbol("1:1,1,1:4,1").isSpherical2D());
        TestDelaneySymbol.assertFalse((boolean)new DSymbol("1:1,1,1:6,1").isSpherical2D());
        TestDelaneySymbol.assertTrue((boolean)new DSymbol("1:1,1,1:6,2").isSpherical2D());
    }

    public void testIsLocallyEuclidean3D() {
        Assert.assertTrue((boolean)this.ds1.isLocallyEuclidean3D());
        try {
            this.ds2.isLocallyEuclidean3D();
            TestDelaneySymbol.fail((String)"should raise a UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testOrientedCover() {
        String in = "16:2 4 6 8 10 12 14 16, 8 3 5 7 16 11 13 15, 6 5 15 16 11 12 14 13:4 4,4 4";
        DSymbol expected = new DSymbol(in);
        DelaneySymbol<Integer> found = this.ds3.orientedCover();
        Assert.assertEquals((Object)expected, found);
        Assert.assertEquals(found, found.orientedCover());
    }
}

