/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.algorithms;

import buoy.event.EventProcessor;
import java.util.List;
import org.gavrog.joss.algorithms.BranchAndCut;
import org.gavrog.joss.algorithms.CheckpointEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Permutations
extends BranchAndCut<String> {
    final int degree;
    final int[] map;
    final int[] inv;

    public Permutations(int degree) {
        if (degree < 1 || degree > 9) {
            throw new IllegalArgumentException("degree must be between 1 and 9");
        }
        this.degree = degree;
        this.map = new int[degree + 1];
        this.inv = new int[degree + 1];
    }

    @Override
    protected BranchAndCut.Move nextChoice(BranchAndCut.Move previous) {
        int n = 1;
        if (previous != null) {
            n = ((PMove)previous).from;
            while (n <= this.degree && this.map[n] != 0) {
                ++n;
            }
        }
        if (n > this.degree) {
            return null;
        }
        return new PMove(n, 0);
    }

    @Override
    protected BranchAndCut.Move nextDecision(BranchAndCut.Move previous) {
        int from = ((PMove)previous).from;
        int to = ((PMove)previous).to + 1;
        while (to <= this.degree && this.inv[to] != 0) {
            ++to;
        }
        if (to > this.degree) {
            return null;
        }
        return new PMove(from, to);
    }

    @Override
    protected BranchAndCut.Status checkMove(BranchAndCut.Move move) {
        int from = ((PMove)move).from;
        int to = ((PMove)move).to;
        if (this.map[from] == to) {
            return BranchAndCut.Status.VOID;
        }
        if (this.map[from] != 0 || this.inv[to] != 0) {
            return BranchAndCut.Status.ILLEGAL;
        }
        return BranchAndCut.Status.OK;
    }

    @Override
    protected void performMove(BranchAndCut.Move move) {
        int to;
        int from = ((PMove)move).from;
        this.map[from] = to = ((PMove)move).to;
        this.inv[to] = from;
    }

    @Override
    protected void undoMove(BranchAndCut.Move move) {
        int from = ((PMove)move).from;
        int to = ((PMove)move).to;
        this.map[from] = 0;
        this.inv[to] = 0;
    }

    @Override
    protected List<BranchAndCut.Move> deductions(BranchAndCut.Move move) {
        return null;
    }

    @Override
    protected boolean isValid() {
        return true;
    }

    @Override
    protected boolean isComplete() {
        int i = 1;
        while (i <= this.degree) {
            int k = this.map[i];
            if (k == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected String makeResult() {
        StringBuffer tmp = new StringBuffer(10);
        int i = 1;
        while (i <= this.degree) {
            tmp.append(this.map[i]);
            ++i;
        }
        return tmp.toString();
    }

    public static void main(String[] args) {
        int n = args.length == 0 ? 4 : Integer.parseInt(args[0]);
        Permutations gen = new Permutations(n);
        if (args.length > 1) {
            gen.setResumePoint(args[1]);
        }
        gen.addEventLink(CheckpointEvent.class, new EventProcessor(){

            public void handleEvent(Object event) {
                System.out.println(event);
                System.out.flush();
            }
        });
        int count = 0;
        for (String p : gen) {
            System.out.println(p);
            System.out.flush();
            ++count;
        }
        System.out.println("# Generated " + count + " permutations.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PMove
    implements BranchAndCut.Move {
        public int from;
        public int to;

        public PMove(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return String.format("(%d => %d)", this.from, this.to);
        }
    }
}

