/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.jane.fpgroups.CosetAction;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.fpgroups.Stabilizer;

public class TestStabilizer
extends TestCase {
    private FiniteAlphabet A;
    private FpGroup G;
    private CosetAction TG;
    private Stabilizer S;

    protected void setUp() throws Exception {
        super.setUp();
        this.A = new FiniteAlphabet<String>(new String[]{"a", "b"});
        this.G = new FpGroup(this.A, new String[]{"a*b*a^-1*b^-1"});
        LinkedList sgens = new LinkedList();
        sgens.add(FreeWord.parsedWord(this.A, "a^2"));
        sgens.add(FreeWord.parsedWord(this.A, "b^3"));
        this.TG = new CosetAction(this.G, sgens);
        this.S = new Stabilizer(this.TG, this.TG.getTrivialCoset());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.A = null;
        this.G = null;
        this.TG = null;
        this.S = null;
    }

    public void testGetAction() {
        Assert.assertEquals((Object)this.TG, this.S.getAction());
    }

    public void testGetBasepoint() {
        Assert.assertEquals(this.TG.getTrivialCoset(), this.S.getBasepoint());
    }

    public void testGetEdgeLabelling() {
        Assert.assertNotNull(this.S.getEdgeLabelling());
    }

    public void testGetGenerators() {
        Assert.assertNotNull(this.S.getGenerators());
        Object x = this.S.getBasepoint();
        for (FreeWord w : this.S.getGenerators()) {
            Assert.assertEquals(x, (Object)this.TG.apply(x, w));
        }
    }

    public void testGetPresentation() {
        FpGroup<String> pres = this.S.getPresentation();
        FpGroup test = new FpGroup(pres.getAlphabet(), new String[]{"s_1*s_2*s_1^-1*s_2^-1"});
        Assert.assertEquals((String)test.toString(), (String)pres.toString());
    }
}

