/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.jane.fpgroups.ChoiceLimitExceededException;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.fpgroups.GroupAction;

public class SmallActionsIterator<E>
extends IteratorAdapter<GroupAction<E, Integer>> {
    private static final boolean LOGGING = false;
    private final FpGroup<E> group;
    private final int maxSize;
    private final boolean normalOnly;
    private final int ngens;
    private final Map<FreeWord<E>, Integer> gen2idx;
    private final int[] idx2invidx;
    private final List<Set<int[]>> relatorsByStartGen;
    private final int[][] table;
    private final LinkedList<Move> stack;
    private int currentNumberOfRows;
    private long startTime;
    private long choicesSoFar = 0L;
    private long choiceLimit = Long.MAX_VALUE;

    public SmallActionsIterator(FpGroup<E> fpGroup, int n, boolean bl) {
        this.group = fpGroup;
        this.maxSize = n;
        this.normalOnly = bl;
        List<FreeWord<E>> list = fpGroup.getGenerators();
        List<FreeWord<E>> list2 = fpGroup.getRelators();
        this.ngens = 2 * list.size();
        this.gen2idx = new HashMap<FreeWord<E>, Integer>();
        this.idx2invidx = new int[this.ngens];
        int n2 = 0;
        for (FreeWord<E> freeWord : list) {
            this.gen2idx.put(freeWord, new Integer(n2));
            this.gen2idx.put(freeWord.inverse(), new Integer(n2 + 1));
            this.idx2invidx[n2] = n2 + 1;
            this.idx2invidx[n2 + 1] = n2;
            n2 += 2;
        }
        this.relatorsByStartGen = new LinkedList<Set<int[]>>();
        for (int i = 0; i <= this.ngens; ++i) {
            this.relatorsByStartGen.add(new HashSet());
        }
        for (FreeWord<E> freeWord : list2) {
            for (int i = -1; i <= 1; i += 2) {
                FreeWord<E> freeWord2 = freeWord.raisedTo(i);
                int n3 = freeWord2.length();
                for (int j = 0; j < n3; ++j) {
                    FreeWord<E> freeWord3 = freeWord2.subword(j, n3).times(freeWord2.subword(0, j));
                    FreeWord<E> freeWord4 = freeWord3.subword(0, 1);
                    int n4 = this.gen2idx.get(freeWord4);
                    this.relatorsByStartGen.get(n4).add(this.translateWord(freeWord3));
                }
            }
        }
        this.table = new int[n + 1][this.ngens];
        this.stack = new LinkedList();
        this.currentNumberOfRows = 1;
        this.stack.addLast(new Move(1, 0, 0, false, true));
        this.startTime = System.currentTimeMillis();
        this.choicesSoFar = 0L;
    }

    public void setMaximalNumberOfChoices(long l) {
        this.choiceLimit = l;
    }

    @Override
    protected GroupAction<E, Integer> findNext() throws NoSuchElementException {
        Move move;
        int n;
        int n2;
        do {
            if ((move = this.undoLastChoice()) == null) {
                throw new NoSuchElementException("At end.");
            }
            int n3 = this.idx2invidx[move.column];
            n = this.currentNumberOfRows;
            for (n2 = move.value + 1; n2 <= n && this.table[n2][n3] != 0; ++n2) {
            }
        } while (n2 > n && (move.startsRow || n2 > this.maxSize) || !this.performMove(move.row, move.column, n2) || !this.tableIsCanonical() || this.findNextChoice(move.row, move.column) || this.normalOnly && !this.isNormal());
        return this.constructAction();
    }

    private boolean performMove(int n, int n2, int n3) {
        if (++this.choicesSoFar >= this.choiceLimit) {
            throw new ChoiceLimitExceededException("too many choices made");
        }
        boolean bl = n3 > this.currentNumberOfRows;
        LinkedList<Move> linkedList = new LinkedList<Move>();
        linkedList.addLast(new Move(n, n2, n3, bl, true));
        while (linkedList.size() > 0) {
            Move move = (Move)linkedList.removeFirst();
            this.stack.addLast(move);
            this.table[move.row][move.column] = move.value;
            this.table[move.value][this.idx2invidx[move.column]] = move.row;
            if (move.startsRow) {
                ++this.currentNumberOfRows;
            }
            Set<int[]> set = this.relatorsByStartGen.get(move.column);
            for (int[] nArray : set) {
                Move move2 = this.scanRelation(nArray, move.row);
                if (move2 == null) continue;
                if (move2.isChoice) {
                    return false;
                }
                linkedList.addLast(move2);
            }
        }
        return true;
    }

    private Move scanRelation(int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n;
        for (n5 = 0; n5 < nArray.length && (n4 = this.table[n6][nArray[n5]]) != 0; ++n5) {
            n6 = n4;
        }
        n4 = n;
        for (n3 = nArray.length - 1; n3 >= n5 && (n2 = this.table[n4][this.idx2invidx[nArray[n3]]]) != 0; --n3) {
            n4 = n2;
        }
        if (n3 == n5) {
            return new Move(n6, nArray[n5], n4, false, false);
        }
        if (n3 < n5 && n6 != n4) {
            return new Move(n6, 0, n4, false, true);
        }
        return null;
    }

    private boolean tableIsCanonical() {
        int n = this.currentNumberOfRows;
        for (int i = 2; i <= n; ++i) {
            if (this.compareStart(i) >= 0) continue;
            return false;
        }
        return true;
    }

    private boolean isNormal() {
        int n = this.currentNumberOfRows;
        for (int i = 2; i <= n; ++i) {
            if (this.compareStart(i) == 0) continue;
            return false;
        }
        return true;
    }

    private int compareStart(int n) {
        int n2 = this.currentNumberOfRows;
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        int n3 = 1;
        nArray[n] = 1;
        nArray2[1] = n;
        for (int i = 1; i <= n2; ++i) {
            assert (i <= n3) : "the current action is not transitive";
            for (int j = 0; j < this.ngens; ++j) {
                int n4 = this.table[i][j];
                int n5 = this.table[nArray2[i]][j];
                if (n5 != 0 && nArray[n5] == 0) {
                    nArray[n5] = ++n3;
                    nArray2[n3] = n5;
                }
                if ((n5 = nArray[n5]) == n4) continue;
                if (n4 == 0) {
                    return -1;
                }
                if (n5 == 0) {
                    return 1;
                }
                return n5 - n4;
            }
        }
        return 0;
    }

    private boolean findNextChoice(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        do {
            if (++n4 < this.ngens) continue;
            n4 = 0;
            if (++n3 <= this.currentNumberOfRows) continue;
            return false;
        } while (this.table[n3][n4] != 0);
        this.stack.addLast(new Move(n3, n4, 0, false, true));
        return true;
    }

    private Move undoLastChoice() {
        Move move;
        do {
            if (this.stack.size() == 0) {
                return null;
            }
            move = this.stack.removeLast();
            this.table[move.row][move.column] = 0;
            this.table[move.value][this.idx2invidx[move.column]] = 0;
            if (!move.startsRow) continue;
            --this.currentNumberOfRows;
        } while (!move.isChoice);
        return move;
    }

    private int[] translateWord(FreeWord<E> freeWord) {
        int[] nArray = new int[freeWord.size()];
        for (int i = 0; i < freeWord.size(); ++i) {
            FreeWord<E> freeWord2 = freeWord.subword(i, i + 1);
            Integer n = this.gen2idx.get(freeWord2);
            nArray[i] = n;
        }
        return nArray;
    }

    private GroupAction<E, Integer> constructAction() {
        final int n = this.currentNumberOfRows;
        final int[][] nArray = new int[n + 1][this.ngens];
        for (int i = 0; i <= n; ++i) {
            nArray[i] = (int[])this.table[i].clone();
        }
        return new GroupAction<E, Integer>(){

            @Override
            public FpGroup<E> getGroup() {
                return SmallActionsIterator.this.group;
            }

            @Override
            public Iterator<Integer> domain() {
                return Iterators.range(1, n + 1);
            }

            @Override
            public Integer apply(Integer n4, FreeWord<E> freeWord) {
                int n2 = n4;
                if (n2 < 1 || n2 > n) {
                    return null;
                }
                for (int i = 0; i < freeWord.length(); ++i) {
                    FreeWord freeWord2 = freeWord.subword(i, i + 1);
                    Integer n3 = (Integer)SmallActionsIterator.this.gen2idx.get(freeWord2);
                    if (n3 == null) {
                        return null;
                    }
                    n2 = nArray[n2][n3];
                }
                return n2;
            }

            @Override
            public boolean isDefinedOn(Integer n2) {
                return n2 >= 1 && n2 <= n;
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    private void dumpTable() {
        StringBuffer stringBuffer = new StringBuffer(500);
        for (int i = 1; i < this.table.length; ++i) {
            int[] nArray = this.table[i];
            for (int j = 0; j < this.ngens; ++j) {
                stringBuffer.append(" ");
                stringBuffer.append(nArray[j]);
            }
            stringBuffer.append("\n");
        }
        System.out.println(stringBuffer);
    }

    private String dumpRelation(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public long getChoicesSoFar() {
        return this.choicesSoFar;
    }

    public long getTimeElapsed() {
        return System.currentTimeMillis() - this.startTime;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        FiniteAlphabet<String> finiteAlphabet = new FiniteAlphabet<String>(new String[]{"a", "b", "c"});
        FpGroup fpGroup = new FpGroup(finiteAlphabet, new String[]{"[a,b]", "[a,c]", "[b,c]"});
        SmallActionsIterator smallActionsIterator = new SmallActionsIterator(fpGroup, n, false);
        int n2 = 0;
        while (smallActionsIterator.hasNext()) {
            smallActionsIterator.next();
            ++n2;
        }
        System.out.println(n2 + " subgroup classes found in " + (double)smallActionsIterator.getTimeElapsed() / 1000.0 + " second.");
    }

    private class Move {
        public final int row;
        public final int column;
        public final int value;
        public final boolean startsRow;
        public final boolean isChoice;

        public Move(int n, int n2, int n3, boolean bl, boolean bl2) {
            this.row = n;
            this.column = n2;
            this.value = n3;
            this.startsRow = bl;
            this.isChoice = bl2;
        }

        public String toString() {
            return "Move(" + this.row + ", " + this.column + ", " + this.value + ", " + this.startsRow + ", " + this.isChoice + ")";
        }
    }
}

