/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import org.gavrog.jane.fpgroups.Alphabet;

public class FreeWord<E>
implements Comparable<FreeWord<E>> {
    private final Alphabet<E> alphabet;
    private final int[] data;

    public FreeWord(FreeWord<? extends E> freeWord) {
        this(freeWord.getAlphabet(), freeWord.data, false);
    }

    public FreeWord(Alphabet<? extends E> alphabet, FreeWord<?> freeWord) {
        this(alphabet, freeWord.data, true);
    }

    public FreeWord(Alphabet<? extends E> alphabet) {
        this(alphabet, null, false);
    }

    public FreeWord(Alphabet<? extends E> alphabet, int n) {
        this(alphabet, new int[]{n});
    }

    public FreeWord(Alphabet<? extends E> alphabet, int[] nArray) {
        this(alphabet, nArray, true);
    }

    public static <X> FreeWord<X> parsedWord(Alphabet<X> alphabet, String string) {
        return new Parser<X>(alphabet, string).getWord();
    }

    protected <X extends E> FreeWord(Alphabet<X> alphabet, int[] nArray, boolean bl) {
        Alphabet<X> alphabet2 = alphabet;
        this.alphabet = alphabet2;
        if (nArray == null) {
            this.data = new int[0];
        } else if (bl) {
            int n;
            int[] nArray2 = new int[nArray.length];
            int n2 = -1;
            for (n = 0; n < nArray.length; ++n) {
                int n3 = nArray[n];
                if (n2 >= 0 && n3 == -nArray2[n2]) {
                    --n2;
                    continue;
                }
                if (n3 == 0) continue;
                if (alphabet.letterToName(Math.abs(n3)) == null) {
                    throw new IllegalArgumentException("illegal entry " + n3);
                }
                nArray2[++n2] = n3;
            }
            this.data = new int[++n2];
            for (n = 0; n < n2; ++n) {
                this.data[n] = nArray2[n];
            }
        } else {
            this.data = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.data[i] = nArray[i];
            }
        }
    }

    protected static <X> int[] translate(Alphabet<X> alphabet, X[] XArray) {
        int[] nArray = new int[XArray.length];
        for (int i = 0; i < XArray.length; ++i) {
            nArray[i] = alphabet.nameToLetter(XArray[i]);
        }
        return nArray;
    }

    public int size() {
        return this.data.length;
    }

    public Alphabet<E> getAlphabet() {
        return this.alphabet;
    }

    public int length() {
        return this.data.length;
    }

    public int getLetter(int n) {
        return Math.abs(this.data[n]);
    }

    public Object getLetterName(int n) {
        return this.alphabet.letterToName(Math.abs(this.data[n]));
    }

    public int getSign(int n) {
        if (this.data[n] < 0) {
            return -1;
        }
        return 1;
    }

    public FreeWord<E> subword(int n, int n2) {
        if (n < 0 || n >= this.length()) {
            throw new IllegalArgumentException("start index out of bounds");
        }
        if (n2 < n || n2 > this.length()) {
            throw new IllegalArgumentException("end index out of bounds");
        }
        if (n2 == n) {
            return new FreeWord<E>(this.getAlphabet());
        }
        int n3 = n2 - n;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.data[i + n];
        }
        return new FreeWord<E>(this.getAlphabet(), nArray, false);
    }

    public FreeWord<E> times(FreeWord<? extends E> freeWord) {
        int n;
        int n2;
        if (!this.getAlphabet().equals(freeWord.getAlphabet())) {
            throw new IllegalArgumentException("must have equal alphabets");
        }
        int n3 = this.data.length;
        int n4 = freeWord.data.length;
        int n5 = Math.min(n3, n4);
        for (n2 = 0; n2 < n5 && freeWord.data[n2] == -this.data[n3 - 1 - n2]; ++n2) {
        }
        int[] nArray = new int[n3 + n4 - 2 * n2];
        for (n = 0; n < n3 - n2; ++n) {
            nArray[n] = this.data[n];
        }
        for (n = 0; n < n4 - n2; ++n) {
            nArray[n3 - n2 + n] = freeWord.data[n2 + n];
        }
        return new FreeWord<E>(this.getAlphabet(), nArray, false);
    }

    public FreeWord<E> inverse() {
        int n = this.length();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -this.data[n - 1 - i];
        }
        return new FreeWord<E>(this.getAlphabet(), nArray, false);
    }

    public FreeWord<E> raisedTo(int n) {
        int[] nArray;
        int n2 = this.size();
        if (n == 0 || n2 == 0) {
            nArray = null;
        } else if (n == 1) {
            nArray = (int[])this.data.clone();
        } else {
            int n3;
            int n4;
            if (n == -1) {
                return this.inverse();
            }
            if (n < 0) {
                return this.inverse().raisedTo(-n);
            }
            for (n4 = 0; n4 < n2 && this.data[n4] == -this.data[n2 - 1 - n4]; ++n4) {
            }
            int n5 = n * n2 - 2 * (n - 1) * n4;
            nArray = new int[n5];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = this.data[n3];
                nArray[n5 - 1 - n3] = this.data[n2 - 1 - n3];
            }
            for (n3 = 0; n3 < n; ++n3) {
                for (int i = n4; i < n2 - n4; ++i) {
                    nArray[n3 * (n2 - 2 * n4) + i] = this.data[i];
                }
            }
        }
        return new FreeWord<E>(this.getAlphabet(), nArray, false);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.data.length == 0) {
            stringBuffer.append("*");
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("*");
                }
                stringBuffer.append(this.getLetterName(i));
                if (this.getSign(i) >= 0) continue;
                stringBuffer.append("^-1");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public int compareTo(FreeWord<E> freeWord) {
        int n = Math.min(this.length(), freeWord.length());
        for (int i = 0; i < n; ++i) {
            int n2 = freeWord.getSign(i) - this.getSign(i);
            if (n2 != 0) {
                return n2;
            }
            n2 = this.getLetter(i) - freeWord.getLetter(i);
            if (n2 == 0) continue;
            return n2;
        }
        return this.length() - freeWord.length();
    }

    public boolean equals(Object object) {
        if (object instanceof FreeWord) {
            FreeWord freeWord = (FreeWord)object;
            return this.getAlphabet().equals(freeWord.getAlphabet()) && this.compareTo(freeWord) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = this.getAlphabet().hashCode();
        for (int i = 0; i < this.length(); ++i) {
            n = n * 37 + this.data[i];
        }
        return n;
    }

    protected static class Parser<X> {
        private final Alphabet<X> alphabet;
        private final String wordAsString;
        private final int n;
        private int pos;
        private final FreeWord<X> word;

        public Parser(Alphabet<X> alphabet, String string) {
            if (alphabet == null) {
                throw new NullPointerException("null argument for aphabet");
            }
            if (string == null) {
                throw new NullPointerException("null argument for wordAsString");
            }
            this.alphabet = alphabet;
            this.wordAsString = string;
            this.n = string.length();
            if (this.n == 0 || string.equals("*")) {
                this.word = new FreeWord<X>(alphabet);
                this.pos = this.n;
            } else {
                this.pos = 0;
                this.word = this.parseWord();
                if (this.pos < this.n) {
                    throw new IllegalArgumentException("bad syntax in " + string);
                }
            }
        }

        public FreeWord<X> getWord() {
            return this.word;
        }

        protected boolean atEnd() {
            return this.pos >= this.n;
        }

        protected void skipBlanks() {
            while (!this.atEnd() && Character.isWhitespace(this.wordAsString.charAt(this.pos))) {
                this.advance();
            }
        }

        protected char nextChar() {
            if (this.atEnd()) {
                return '$';
            }
            return this.wordAsString.charAt(this.pos);
        }

        protected void advance() {
            ++this.pos;
        }

        protected FreeWord<X> parseWord() {
            FreeWord<X> freeWord = this.parseFactor();
            this.skipBlanks();
            while (this.nextChar() == '*') {
                this.advance();
                FreeWord<X> freeWord2 = this.parseFactor();
                freeWord = freeWord.times(freeWord2);
            }
            return freeWord;
        }

        protected FreeWord<X> parseFactor() {
            Comparable<FreeWord<Object>> comparable;
            FreeWord<X> freeWord;
            this.skipBlanks();
            if (this.nextChar() == '(') {
                this.advance();
                freeWord = this.parseWord();
                this.skipBlanks();
                if (this.nextChar() != ')') {
                    throw new IllegalArgumentException("unmatched parenthesis");
                }
                this.advance();
            } else if (this.nextChar() == '[') {
                this.advance();
                comparable = this.parseWord();
                this.skipBlanks();
                if (this.nextChar() != ',') {
                    throw new IllegalArgumentException("missing comma in commutator expression");
                }
                this.advance();
                FreeWord<X> freeWord2 = this.parseWord();
                this.skipBlanks();
                if (this.nextChar() != ']') {
                    throw new IllegalArgumentException("unmatched '['");
                }
                this.advance();
                freeWord = ((FreeWord)comparable).times(freeWord2).times(((FreeWord)comparable).inverse()).times(freeWord2.inverse());
            } else {
                freeWord = this.parseLetter();
            }
            this.skipBlanks();
            if (this.nextChar() == '^') {
                this.advance();
                this.skipBlanks();
                comparable = new StringBuffer(10);
                if (this.nextChar() == '-') {
                    ((StringBuffer)comparable).append('-');
                    this.advance();
                }
                while (Character.isDigit(this.nextChar())) {
                    ((StringBuffer)comparable).append(this.nextChar());
                    this.advance();
                }
                int n = Integer.parseInt(((StringBuffer)comparable).toString());
                return freeWord.raisedTo(n);
            }
            return freeWord;
        }

        protected FreeWord<X> parseLetter() {
            int n;
            this.skipBlanks();
            StringBuffer stringBuffer = new StringBuffer(10);
            while (Character.isLetterOrDigit(this.nextChar()) || this.nextChar() == '_') {
                stringBuffer.append(this.nextChar());
                this.advance();
            }
            try {
                String string = stringBuffer.toString();
                n = this.alphabet.nameToLetter(string);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
            return new FreeWord<X>(this.alphabet, n);
        }
    }
}

