/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gavrog.jane.fpgroups.Alphabet;

public class FiniteAlphabet<E>
implements Alphabet<E> {
    private final List<E> nameList;
    private final Map<E, Integer> nameSet;

    public FiniteAlphabet(List<E> list) {
        int n = list.size();
        HashMap<E, Integer> hashMap = new HashMap<E, Integer>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(list.get(i), i + 1);
        }
        this.nameList = Collections.unmodifiableList(list);
        this.nameSet = Collections.unmodifiableMap(hashMap);
    }

    public static FiniteAlphabet<String> fromPrefix(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= n; ++i) {
            arrayList.add(string + i);
        }
        return new FiniteAlphabet<String>(arrayList);
    }

    public FiniteAlphabet(E[] EArray) {
        this(Arrays.asList(EArray));
    }

    public List<E> getNameList() {
        return this.nameList;
    }

    public int size() {
        return this.nameList.size();
    }

    @Override
    public E letterToName(int n) {
        return this.nameList.get(n - 1);
    }

    @Override
    public int nameToLetter(E e) {
        return this.nameSet.get(e);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Alphabet({");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("\"");
            stringBuffer.append(this.nameList.get(i));
            stringBuffer.append("\"");
        }
        stringBuffer.append("})");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof FiniteAlphabet) {
            List<E> list = this.getNameList();
            List<E> list2 = ((FiniteAlphabet)object).getNameList();
            return list.equals(list2);
        }
        return false;
    }

    public int hashCode() {
        return this.getNameList().hashCode();
    }
}

