/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gavrog.box.collections.FilteredIterator;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.collections.Partition;
import org.gavrog.jane.fpgroups.Coset;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.fpgroups.GroupAction;

public class CosetAction<E, D>
implements GroupAction<E, Coset<E, D>> {
    private static final boolean LOGGING = false;
    public static final int DEFAULT_SiZE_LIMIT = 100000;
    private final FpGroup<E> group;
    private final List<FreeWord<E>> subgroupGenerators;
    private final int sizeLimit;
    private final List<FreeWord<E>> idx2gen;
    private final int[] idx2invidx;
    private final int ngens;
    private final Map<FreeWord<E>, Integer> gen2idx;
    private final List<int[]> table;
    private final int numberOfCosets;
    final FreeWord<E>[] cosetRepresentatives;

    public CosetAction(FpGroup<E> fpGroup) {
        this(fpGroup, new ArrayList<FreeWord<E>>(), 100000);
    }

    public CosetAction(FpGroup<E> fpGroup, int n) {
        this(fpGroup, new ArrayList<FreeWord<E>>(), n);
    }

    public CosetAction(FpGroup<E> fpGroup, List<FreeWord<E>> list) {
        this(fpGroup, list, 100000);
    }

    /*
     * WARNING - void declaration
     */
    public CosetAction(FpGroup<E> fpGroup, List<FreeWord<E>> list, int n) {
        void var9_14;
        Object object;
        int n2;
        this.group = fpGroup;
        this.subgroupGenerators = Collections.unmodifiableList(list);
        this.sizeLimit = n;
        List<FreeWord<E>> list2 = fpGroup.getGenerators();
        List<FreeWord<E>> list3 = fpGroup.getRelators();
        this.ngens = 2 * list2.size();
        this.idx2gen = new ArrayList<FreeWord<E>>();
        this.gen2idx = new HashMap<FreeWord<E>, Integer>();
        this.idx2invidx = new int[this.ngens];
        int n3 = 0;
        for (FreeWord<E> arrayList2 : list2) {
            this.idx2gen.add(arrayList2);
            this.gen2idx.put(arrayList2, n3);
            this.idx2gen.add(arrayList2.inverse());
            this.gen2idx.put(arrayList2.inverse(), n3 + 1);
            this.idx2invidx[n3] = n3 + 1;
            this.idx2invidx[n3 + 1] = n3;
            n3 += 2;
        }
        ArrayList arrayList3 = new ArrayList();
        for (FreeWord<E> freeWord : list3) {
            int n4 = freeWord.length();
            for (n2 = 0; n2 < n4; ++n2) {
                object = freeWord.subword(n2, n4).times(freeWord.subword(0, n2));
                arrayList3.add(this.translateWord((FreeWord<E>)object));
                arrayList3.add(this.translateWord(((FreeWord)object).inverse()));
            }
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (FreeWord<E> freeWord : list) {
            arrayList.add(this.translateWord(freeWord));
            arrayList.add(this.translateWord(freeWord.inverse()));
        }
        this.table = new ArrayList<int[]>();
        this.table.add(new int[this.ngens]);
        this.table.add(new int[this.ngens]);
        Partition partition = new Partition();
        boolean bl = false;
        n2 = 1;
        while (n2 < this.table.size()) {
            if (var9_14.find(n2) != n2) {
                ++n2;
                continue;
            }
            object = this.table.get(n2);
            for (int i = 0; i < this.ngens; ++i) {
                boolean bl2;
                Object object2;
                if (object[i] != false) continue;
                int[] nArray = new int[this.ngens];
                this.table.add(nArray);
                int n5 = this.table.size();
                object[i] = n5 - 1;
                nArray[this.idx2invidx[i]] = n2;
                LinkedList<Pair<Integer, Integer>> linkedList = new LinkedList<Pair<Integer, Integer>>();
                Iterator iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    object2 = (int[])iterator.next();
                    this.scanRelation((int[])object2, n5 - 1, linkedList);
                }
                int n6 = var9_14.find(1);
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    int[] nArray2 = (int[])object2.next();
                    this.scanRelation(nArray2, n6, linkedList);
                }
                if (this.sizeLimit > 0 && n5 - (bl2 += this.performIdentifications(linkedList, (Partition<Integer>)var9_14)) > this.sizeLimit) {
                    throw new RuntimeException("table limit reached");
                }
                if (bl2 <= n5 / 2) continue;
                object2 = this.compressTable((Partition<Integer>)var9_14);
                Partition partition2 = new Partition();
                n2 = object2[n2];
                bl2 = false;
            }
            ++n2;
        }
        this.compressTable((Partition<Integer>)var9_14);
        this.numberOfCosets = this.table.size() - 1;
        this.cosetRepresentatives = this.computeCosetRepresentatives();
    }

    private void dumpTable() {
        StringBuffer stringBuffer = new StringBuffer(500);
        for (int i = 1; i < this.table.size(); ++i) {
            int[] nArray = this.table.get(i);
            for (int j = 0; j < this.ngens; ++j) {
                stringBuffer.append(" ");
                stringBuffer.append(nArray[j]);
            }
            stringBuffer.append("\n");
        }
        System.out.println(stringBuffer);
    }

    private int[] translateWord(FreeWord<E> freeWord) {
        int[] nArray = new int[freeWord.size()];
        for (int i = 0; i < freeWord.size(); ++i) {
            FreeWord<E> freeWord2 = freeWord.subword(i, i + 1);
            Integer n = this.gen2idx.get(freeWord2);
            nArray[i] = n;
        }
        return nArray;
    }

    private void scanRelation(int[] nArray, int n, LinkedList<Pair<Integer, Integer>> linkedList) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n;
        for (n5 = 0; n5 < nArray.length; ++n5) {
            n4 = nArray[n5];
            n3 = this.table.get(n6)[n4];
            if (n3 == 0) break;
            n6 = n3;
        }
        n4 = n;
        for (n3 = nArray.length - 1; n3 >= n5; --n3) {
            n2 = this.idx2invidx[nArray[n3]];
            int n7 = this.table.get(n4)[n2];
            if (n7 == 0) break;
            n4 = n7;
        }
        if (n3 == n5) {
            n2 = nArray[n5];
            int[] nArray2 = this.table.get(n4);
            int[] nArray3 = this.table.get(n6);
            nArray3[n2] = n4;
            nArray2[this.idx2invidx[n2]] = n6;
        } else if (n3 < n5 && n6 != n4) {
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>(n6, n4);
            linkedList.addLast(pair);
        }
    }

    private int performIdentifications(LinkedList<Pair<Integer, Integer>> linkedList, Partition<Integer> partition) {
        int n = 0;
        while (linkedList.size() > 0) {
            int n2;
            Pair<Integer, Integer> pair = linkedList.removeFirst();
            int n3 = partition.find(pair.getFirst());
            if (n3 == (n2 = partition.find(pair.getSecond()).intValue())) continue;
            partition.unite(n3, n2);
            ++n;
            int[] nArray = this.table.get(n3);
            int[] nArray2 = this.table.get(n2);
            for (int i = 0; i < this.ngens; ++i) {
                int n4 = nArray[i];
                int n5 = nArray2[i];
                if (n4 == 0) {
                    nArray[i] = n5;
                    continue;
                }
                if (n5 == 0) {
                    nArray2[i] = n4;
                    continue;
                }
                if (partition.areEquivalent(n4, n5)) continue;
                linkedList.addLast(new Pair<Integer, Integer>(n4, n5));
            }
            this.table.set(n2, nArray);
        }
        return n;
    }

    private int[] compressTable(Partition<Integer> partition) {
        int n;
        int[] nArray = new int[this.table.size()];
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        linkedList.add(this.table.get(0));
        for (n = 1; n < this.table.size(); ++n) {
            int n2 = partition.find(n);
            if (nArray[n2] == 0) {
                nArray[n2] = linkedList.size();
                linkedList.add(this.table.get(n2));
            }
            nArray[n] = nArray[n2];
        }
        this.table.clear();
        while (linkedList.size() > 0) {
            this.table.add((int[])linkedList.removeFirst());
        }
        for (n = 1; n < this.table.size(); ++n) {
            int[] nArray2 = this.table.get(n);
            for (int i = 0; i < this.ngens; ++i) {
                nArray2[i] = nArray[nArray2[i]];
            }
        }
        return nArray;
    }

    private FreeWord<E>[] computeCosetRepresentatives() {
        int n = this.size();
        FreeWord[] freeWordArray = new FreeWord[n + 1];
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        freeWordArray[1] = new FreeWord<E>(this.getGroup().getAlphabet());
        linkedList.addLast(new Integer(1));
        while (linkedList.size() > 0) {
            int n2 = (Integer)linkedList.removeFirst();
            int[] nArray = this.table.get(n2);
            for (int i = 0; i < this.ngens; ++i) {
                int n3 = nArray[i];
                if (freeWordArray[n3] != null) continue;
                freeWordArray[n3] = freeWordArray[n2].times(this.idx2gen.get(i));
                linkedList.addLast(new Integer(n3));
            }
        }
        return freeWordArray;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public List<FreeWord<E>> getSubgroupGenerators() {
        return this.subgroupGenerators;
    }

    public Coset<E, D> getTrivialCoset() {
        return new Coset(this, 1);
    }

    public Coset<E, D> getCoset(FreeWord<E> freeWord) {
        return this.apply(this.getTrivialCoset(), freeWord);
    }

    public Coset<E, D> getCoset(String string) {
        return this.getCoset(FreeWord.parsedWord(this.getGroup().getAlphabet(), string));
    }

    @Override
    public FpGroup<E> getGroup() {
        return this.group;
    }

    @Override
    public Iterator<Coset<E, D>> domain() {
        return new FilteredIterator<Coset<E, D>, Integer>(Iterators.range(1, this.size() + 1)){

            @Override
            public Coset<E, D> filter(Integer n) {
                return new Coset(CosetAction.this, n);
            }
        };
    }

    @Override
    public Coset<E, D> apply(Coset<E, D> coset, FreeWord<E> freeWord) {
        if (coset.getAction() != this) {
            return null;
        }
        int n = coset.getIndex();
        if (n < 1 || n > this.size()) {
            return null;
        }
        for (int i = 0; i < freeWord.length(); ++i) {
            Integer n2 = this.gen2idx.get(freeWord.subword(i, i + 1));
            if (n2 == null) {
                return null;
            }
            int[] nArray = this.table.get(n);
            n = nArray[n2];
        }
        return new Coset(this, n);
    }

    @Override
    public boolean isDefinedOn(Coset<E, D> coset) {
        return coset.getAction() == this;
    }

    @Override
    public int size() {
        return this.numberOfCosets;
    }
}

