/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.gui;

import buoy.event.EventProcessor;
import buoy.event.EventSource;
import buoy.event.ValueChangedEvent;
import buoy.widget.BLabel;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import org.gavrog.box.gui.Slider;
import org.gavrog.box.simple.Strings;

public class OptionSliderBox
extends BorderContainer {
    private boolean eventsLocked = false;
    private final Slider slider;

    public OptionSliderBox(String label, final Object target, final String option, double min, double max, double major, double minor, double snap) throws Exception {
        Method t;
        this.setBackground(null);
        this.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(2, 8, 2, 8), null));
        this.slider = new Slider(min, min, max);
        this.slider.setBackground(null);
        this.slider.setShowTicks(true);
        this.slider.setShowValue(true);
        this.slider.setMajorTickSpacing(major);
        this.slider.setMinorTickSpacing(minor);
        this.slider.setSnapInterval(snap);
        this.add(this.slider, BorderContainer.WEST);
        this.add(new BLabel(label), BorderContainer.EAST, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(2, 10, 2, 10), null));
        Class<?> klazz = target instanceof Class ? (Class<?>)target : target.getClass();
        String optionCap = Strings.capitalized(option);
        Method getter = klazz.getMethod("get" + optionCap, new Class[0]);
        try {
            t = klazz.getMethod("set" + optionCap, Integer.TYPE);
        }
        catch (NoSuchMethodException ex) {
            t = klazz.getMethod("set" + optionCap, Double.TYPE);
        }
        final Method setter = t;
        this.updateValue(getter.invoke(target, new Object[0]));
        this.slider.addEventLink(ValueChangedEvent.class, new EventProcessor(){

            public void handleEvent(Object event) {
                if (OptionSliderBox.this.obtainLock()) {
                    try {
                        Number arg = OptionSliderBox.this.slider.getValue();
                        if (setter.getParameterTypes()[0].equals(Integer.TYPE)) {
                            arg = (int)Math.round(arg);
                        }
                        setter.invoke(target, arg);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    OptionSliderBox.this.releaseLock();
                }
            }
        });
        if (target instanceof EventSource) {
            EventSource s = (EventSource)target;
            s.addEventLink(PropertyChangeEvent.class, new EventProcessor(){

                public void handleEvent(Object event) {
                    if (OptionSliderBox.this.obtainLock()) {
                        PropertyChangeEvent e = (PropertyChangeEvent)event;
                        if (e.getPropertyName().equals(option)) {
                            OptionSliderBox.this.updateValue(e.getNewValue());
                        }
                        OptionSliderBox.this.releaseLock();
                    }
                }
            });
        }
    }

    private void updateValue(Object newValue) {
        this.slider.setValue(((Number)newValue).doubleValue());
    }

    private boolean obtainLock() {
        if (this.eventsLocked) {
            return false;
        }
        this.eventsLocked = true;
        return true;
    }

    private void releaseLock() {
        this.eventsLocked = false;
    }

    public void setShowValue(boolean show) {
        this.slider.setShowValue(show);
    }

    public void setShowTicks(boolean show) {
        this.slider.setShowTicks(show);
    }

    public void setSnapInterval(double snap) {
        this.slider.setSnapInterval(snap);
    }
}

