/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.gui;

import buoy.event.EventProcessor;
import buoy.event.EventSource;
import buoy.event.MousePressedEvent;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BorderContainer;
import buoy.widget.CustomWidget;
import buoy.widget.LayoutInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import org.gavrog.box.gui.Config;

public class OptionColorBox
extends BorderContainer {
    private boolean eventsLocked = false;
    private static Color currentColor = null;
    private static final JColorChooser chooser = new JColorChooser();
    private static final ActionListener onOk = new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            currentColor = chooser.getColor();
        }
    };
    private static final ActionListener onCancel = new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            currentColor = null;
        }
    };
    private static final JDialog dialog = JColorChooser.createDialog(null, "Choose a color", true, chooser, onOk, onCancel);

    public OptionColorBox(String label, final Object target, final String option) throws Exception {
        this.setBackground(null);
        this.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(2, 10, 2, 10), null));
        final CustomWidget color = new CustomWidget();
        color.setPreferredSize(new Dimension(30, 15));
        this.add(BOutline.createLineBorder(color, Color.GRAY, 1), BorderContainer.WEST);
        this.add(new BLabel(label), BorderContainer.EAST);
        PropertyDescriptor prop = Config.namedProperty(target, option);
        if (prop == null) {
            throw new IllegalArgumentException("Target class has no property " + option);
        }
        final Method getter = prop.getReadMethod();
        final Method setter = prop.getWriteMethod();
        color.setBackground((Color)getter.invoke(target, new Object[0]));
        color.addEventLink(MousePressedEvent.class, new EventProcessor(){

            public void handleEvent(Object event) {
                if (OptionColorBox.this.obtainLock()) {
                    try {
                        chooser.setColor((Color)getter.invoke(target, new Object[0]));
                        dialog.setVisible(true);
                        if (currentColor != null) {
                            color.setBackground(currentColor);
                            setter.invoke(target, currentColor);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    OptionColorBox.this.releaseLock();
                }
            }
        });
        if (target instanceof EventSource) {
            EventSource s = (EventSource)target;
            s.addEventLink(PropertyChangeEvent.class, new EventProcessor(){

                public void handleEvent(Object event) {
                    if (OptionColorBox.this.obtainLock()) {
                        PropertyChangeEvent e = (PropertyChangeEvent)event;
                        if (e.getPropertyName().equals(option)) {
                            color.setBackground((Color)e.getNewValue());
                        }
                        OptionColorBox.this.releaseLock();
                    }
                }
            });
        }
    }

    private boolean obtainLock() {
        if (this.eventsLocked) {
            return false;
        }
        this.eventsLocked = true;
        return true;
    }

    private void releaseLock() {
        this.eventsLocked = false;
    }
}

