/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.collections;

import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.FilteredIterator;
import org.gavrog.box.collections.Iterators;

public class TestFilteredIterator
extends TestCase {
    FilteredIterator<Float, Integer> iter;

    protected void setUp() throws Exception {
        super.setUp();
        this.iter = new FilteredIterator<Float, Integer>(Iterators.range(0, 7)){

            @Override
            public Float filter(Integer x) {
                if (x % 2 != 0) {
                    return Float.valueOf(x.floatValue());
                }
                return null;
            }
        };
    }

    protected void tearDown() throws Exception {
        this.iter = null;
        super.tearDown();
    }

    public void testFilteredIterator() {
        Assert.assertTrue((boolean)this.iter.hasNext());
        Assert.assertEquals(this.iter.next(), (Object)Float.valueOf(1.0f));
        Assert.assertTrue((boolean)this.iter.hasNext());
        Assert.assertEquals(this.iter.next(), (Object)Float.valueOf(3.0f));
        Assert.assertTrue((boolean)this.iter.hasNext());
        Assert.assertEquals(this.iter.next(), (Object)Float.valueOf(5.0f));
        Assert.assertFalse((boolean)this.iter.hasNext());
        try {
            this.iter.next();
            TestFilteredIterator.fail((String)"Should raise a NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        try {
            this.iter.remove();
            TestFilteredIterator.fail((String)"Should raise an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

