/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.apps._3dt;

import buoy.widget.BFileChooser;
import buoy.widget.BStandardDialog;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;

public class FileChooser
extends BFileChooser {
    private boolean append = false;
    private boolean appendEnabled = false;

    public FileChooser(BFileChooser.SelectionMode mode, String title) {
        super(mode, title);
    }

    public FileChooser(BFileChooser.SelectionMode mode) {
        super(mode, FileChooser.defaultTitle(mode));
    }

    private static String defaultTitle(BFileChooser.SelectionMode mode) {
        if (mode == OPEN_FILE) {
            return "Open File";
        }
        if (mode == SAVE_FILE) {
            return "Save File";
        }
        if (mode == SELECT_FOLDER) {
            return "Select Folder";
        }
        return "Select File";
    }

    public File pickFile(File path, String ext) {
        if (path.isDirectory()) {
            this.setDirectory(path);
        } else {
            this.setSelectedFile(path);
        }
        boolean success = this.showDialog(null);
        if (!success) {
            return null;
        }
        File selected = this.getSelectedFile();
        String filename = selected.getName();
        if (ext != null && !ext.equals("") && filename.indexOf(46) < 0) {
            selected = new File(String.valueOf(selected.getAbsolutePath()) + "." + ext);
        }
        this.append = false;
        if (this.getMode() == SAVE_FILE && selected.exists()) {
            if (this.appendEnabled) {
                int choice = this.showOverwriteDialog(selected, new String[]{"Overwrite", "Append", "Cancel"}, "Cancel");
                if (choice > 1) {
                    return null;
                }
                this.append = choice == 1;
            } else {
                int choice = this.showOverwriteDialog(selected, new String[]{"Overwrite", "Cancel"}, "Cancel");
                if (choice > 0) {
                    return null;
                }
            }
        }
        return selected;
    }

    private int showOverwriteDialog(File file, String[] choices, String defaultChoice) {
        return new BStandardDialog("3dt - File exists", "File \"" + file + "\" already exists. Overwrite?", BStandardDialog.QUESTION).showOptionDialog(null, choices, defaultChoice);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.getComponent().addChoosableFileFilter(filter);
    }

    public void setAccessory(JComponent accessory) {
        this.getComponent().setAccessory(accessory);
    }

    public boolean getAppend() {
        return this.append;
    }

    public boolean getAppendEnabled() {
        return this.appendEnabled;
    }

    public void setAppendEnabled(boolean appendEnabled) {
        this.appendEnabled = appendEnabled;
    }
}

