/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.apps._3dt;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import de.jreality.scene.Transformation;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.gavrog.apps._3dt.DisplayList;
import org.gavrog.apps._3dt.Document;
import org.gavrog.box.collections.Pair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.tilings.Tiling;

public class DocumentXStream
extends XStream {
    private static DocumentXStream _instance = null;

    public static DocumentXStream instance() {
        if (_instance == null) {
            _instance = new DocumentXStream();
        }
        return _instance;
    }

    private DocumentXStream() {
        this.setMode(1001);
        this.alias("scene", Document.class);
        this.alias("color", Color.class);
        this.registerDSymbolConverter();
        this.registerColorConverter();
        this.registerVectorConverter();
        this.registerTransformationConverter();
        this.registerPropertiesConverter();
        this.registerDocumentConverter();
    }

    private void registerDocumentConverter() {
        this.registerConverter(new Converter(){

            public boolean canConvert(Class clazz) {
                return clazz == Document.class;
            }

            public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
                Document doc = (Document)value;
                Tiling til = doc.getTiling();
                DSCover<Integer> cov = til.getCover();
                if (doc.getName() != null) {
                    writer.addAttribute("name", doc.getName());
                }
                writer.startNode("symbol");
                context.convertAnother(til.getSymbol().flat());
                writer.endNode();
                writer.startNode("cover");
                context.convertAnother(til.getCover().flat());
                writer.endNode();
                Iterator<Object> iterator = cov.indices().iterator();
                while (iterator.hasNext()) {
                    int i = iterator.next();
                    for (int D : cov.elements()) {
                        Vector s = til.edgeTranslation(i, D);
                        if (s.isZero()) continue;
                        writer.startNode("edgeShift");
                        writer.addAttribute("index", String.valueOf(i));
                        writer.addAttribute("element", String.valueOf(D));
                        context.convertAnother((Object)s);
                        writer.endNode();
                    }
                }
                writer.startNode("palette");
                context.convertAnother((Object)doc.getPalette());
                writer.endNode();
                for (DisplayList.Item item : doc) {
                    if (item.isTile()) {
                        writer.startNode("tile");
                        writer.addAttribute("templateNr", String.valueOf(item.getTile().getIndex()));
                    } else if (item.isFacet()) {
                        Tiling.Facet f = item.getFacet();
                        writer.startNode("facet");
                        writer.addAttribute("templateNr", String.valueOf(f.getTileIndex()));
                        writer.addAttribute("index", String.valueOf(f.getIndex()));
                    } else if (item.isNode()) {
                        writer.startNode("node");
                        writer.addAttribute("id", String.valueOf(item.getNode().id()));
                    } else if (item.isEdge()) {
                        IEdge e = item.getEdge();
                        writer.startNode("edge");
                        writer.addAttribute("source", String.valueOf(e.source().id()));
                        writer.addAttribute("target", String.valueOf(e.target().id()));
                        writer.startNode("label");
                        context.convertAnother((Object)((PeriodicGraph)e.owner()).getShift(e));
                        writer.endNode();
                    }
                    writer.startNode("shift");
                    context.convertAnother((Object)item.getShift());
                    writer.endNode();
                    if (doc.color(item) != null) {
                        writer.startNode("color");
                        context.convertAnother((Object)doc.color(item));
                        writer.endNode();
                    }
                    writer.endNode();
                }
                for (Tiling.Facet f : doc.getColoredFacetClasses()) {
                    Color c = doc.getFacetClassColor(f);
                    if (c == null) continue;
                    writer.startNode("facet");
                    writer.addAttribute("templateNr", String.valueOf(f.getTileIndex()));
                    writer.addAttribute("index", String.valueOf(f.getIndex()));
                    writer.startNode("color");
                    context.convertAnother((Object)c);
                    writer.endNode();
                    writer.endNode();
                }
                for (Tiling.Facet f : doc.getHiddenFacetClasses()) {
                    writer.startNode("facet");
                    writer.addAttribute("templateNr", String.valueOf(f.getTileIndex()));
                    writer.addAttribute("index", String.valueOf(f.getIndex()));
                    writer.addAttribute("hidden", "true");
                    writer.endNode();
                }
                writer.startNode("options");
                context.convertAnother((Object)doc.getProperties());
                writer.endNode();
                writer.startNode("transformation");
                context.convertAnother((Object)doc.getTransformation());
                writer.endNode();
            }

            /*
             * WARNING - void declaration
             */
            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                void var13_18;
                Document doc = null;
                String name = reader.getAttribute("name");
                DSymbol symbol = null;
                DSymbol cover = null;
                LinkedList<Color> palette = new LinkedList<Color>();
                LinkedList<Object[]> dlist = new LinkedList<Object[]>();
                HashMap<Pair<Integer, Integer>, Color> fcolors = new HashMap<Pair<Integer, Integer>, Color>();
                HashSet<Pair<Integer, Integer>> fhidden = new HashSet<Pair<Integer, Integer>>();
                Properties props = null;
                Transformation trans = null;
                while (reader.hasMoreChildren()) {
                    Color color;
                    Vector shift;
                    reader.moveDown();
                    if ("symbol".equals(reader.getNodeName())) {
                        symbol = (DSymbol)context.convertAnother(null, DSymbol.class);
                    } else if ("cover".equals(reader.getNodeName())) {
                        cover = (DSymbol)context.convertAnother(null, DSymbol.class);
                    } else if ("palette".equals(reader.getNodeName())) {
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            palette.add((Color)context.convertAnother(null, Color.class));
                            reader.moveUp();
                        }
                    } else if ("options".equals(reader.getNodeName())) {
                        props = (Properties)context.convertAnother(null, Properties.class);
                    } else if ("transformation".equals(reader.getNodeName())) {
                        trans = (Transformation)context.convertAnother(null, Transformation.class);
                    } else if ("tile".equals(reader.getNodeName())) {
                        Integer n = new Integer(reader.getAttribute("templateNr"));
                        Vector shift2 = null;
                        Color color2 = null;
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            if ("shift".equals(reader.getNodeName())) {
                                shift2 = (Vector)context.convertAnother(null, Vector.class);
                            } else if ("color".equals(reader.getNodeName())) {
                                color2 = (Color)context.convertAnother(null, Color.class);
                            }
                            reader.moveUp();
                        }
                        dlist.add(new Object[]{"tile", shift2, color2, n});
                    } else if ("node".equals(reader.getNodeName())) {
                        Long l = new Long(reader.getAttribute("id"));
                        Vector shift3 = null;
                        Color color2 = null;
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            if ("shift".equals(reader.getNodeName())) {
                                shift3 = (Vector)context.convertAnother(null, Vector.class);
                            } else if ("color".equals(reader.getNodeName())) {
                                color2 = (Color)context.convertAnother(null, Color.class);
                            }
                            reader.moveUp();
                        }
                        dlist.add(new Object[]{"node", shift3, color2, l});
                    } else if ("edge".equals(reader.getNodeName())) {
                        Long l = new Long(reader.getAttribute("source"));
                        Long target = new Long(reader.getAttribute("target"));
                        Vector label = null;
                        shift = null;
                        color = null;
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            if ("label".equals(reader.getNodeName())) {
                                label = (Vector)context.convertAnother(null, Vector.class);
                            } else if ("shift".equals(reader.getNodeName())) {
                                shift = (Vector)context.convertAnother(null, Vector.class);
                            } else if ("color".equals(reader.getNodeName())) {
                                color = (Color)context.convertAnother(null, Color.class);
                            }
                            reader.moveUp();
                        }
                        dlist.add(new Object[]{"edge", shift, color, l, target, label});
                    } else if ("facet".equals(reader.getNodeName())) {
                        int n = new Integer(reader.getAttribute("templateNr"));
                        int index = new Integer(reader.getAttribute("index"));
                        String hidden = reader.getAttribute("hidden");
                        if ("true".equalsIgnoreCase(hidden)) {
                            fhidden.add(new Pair<Integer, Integer>(n, index));
                        }
                        shift = null;
                        color = null;
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            if ("shift".equals(reader.getNodeName())) {
                                shift = (Vector)context.convertAnother(null, Vector.class);
                            } else if ("color".equals(reader.getNodeName())) {
                                color = (Color)context.convertAnother(null, Color.class);
                            }
                            reader.moveUp();
                        }
                        if (shift == null) {
                            fcolors.put(new Pair<Integer, Integer>(n, index), color);
                        } else {
                            dlist.add(new Object[]{"facet", shift, color, n, index});
                        }
                    }
                    reader.moveUp();
                }
                if (symbol == null) {
                    throw new RuntimeException("No D-Symbol on XML stream.");
                }
                doc = cover != null ? new Document(symbol, name, new DSCover<Integer>(cover, symbol, 1)) : new Document(symbol, name);
                doc.setProperties(props);
                boolean bl = false;
                while (var13_18 < palette.size()) {
                    doc.setTileClassColor((int)var13_18, (Color)palette.get((int)var13_18));
                    ++var13_18;
                }
                for (Object[] objectArray : dlist) {
                    Vector t;
                    INode w;
                    INode v;
                    Tiling.Skeleton net;
                    IEdge e;
                    String kind = (String)objectArray[0];
                    Vector s = (Vector)objectArray[1];
                    Color c = (Color)objectArray[2];
                    DisplayList.Item item = null;
                    if (kind.equals("tile")) {
                        int id = (Integer)objectArray[3];
                        item = doc.add(doc.getTile(id), s);
                    } else if (kind.equals("facet")) {
                        int tId = (Integer)objectArray[3];
                        int fId = (Integer)objectArray[4];
                        item = doc.add(doc.getTile(tId).facet(fId), s);
                    } else if (kind.equals("node")) {
                        INode v2 = doc.getNet().getNode((Long)objectArray[3]);
                        item = doc.add(v2, s);
                    } else if (kind.equals("edge") && (e = (net = doc.getNet()).getEdge(v = net.getNode((Long)objectArray[3]), w = net.getNode((Long)objectArray[4]), t = (Vector)objectArray[5])) != null) {
                        item = doc.add(e, s);
                    }
                    if (item == null) continue;
                    doc.recolor(item, c);
                }
                for (Pair pair : fcolors.keySet()) {
                    Color c = (Color)fcolors.get(pair);
                    if (c == null) continue;
                    int tile = (Integer)pair.getFirst();
                    int index = (Integer)pair.getSecond();
                    Tiling.Tile t = doc.getTiles().get(tile);
                    Tiling.Facet f = t.facet(index);
                    doc.setFacetClassColor(f, c);
                }
                for (Pair pair : fhidden) {
                    int tile = (Integer)pair.getFirst();
                    int index = (Integer)pair.getSecond();
                    Tiling.Tile t = doc.getTiles().get(tile);
                    Tiling.Facet f = t.facet(index);
                    doc.hideFacetClass(f);
                }
                doc.setTransformation(trans);
                return doc;
            }
        });
    }

    private void registerPropertiesConverter() {
        this.registerConverter(new Converter(){

            public boolean canConvert(Class clazz) {
                return clazz == Properties.class;
            }

            public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
                Properties props = (Properties)value;
                for (Object key : props.keySet()) {
                    writer.startNode("property");
                    writer.addAttribute("key", (String)key);
                    writer.setValue(props.getProperty((String)key));
                    writer.endNode();
                }
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                Properties props = new Properties();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String key = reader.getAttribute("key");
                    String val = reader.getValue();
                    props.setProperty(key, val);
                    reader.moveUp();
                }
                return props;
            }
        });
    }

    private void registerTransformationConverter() {
        this.registerConverter(new SingleValueConverter(){

            public boolean canConvert(Class clazz) {
                return clazz == Transformation.class;
            }

            public String toString(Object value) {
                double[] v = ((Transformation)value).getMatrix();
                StringBuffer buf = new StringBuffer(40);
                int i = 0;
                while (i < v.length) {
                    if (i > 0) {
                        buf.append(' ');
                    }
                    buf.append(v[i]);
                    ++i;
                }
                return buf.toString();
            }

            public Object fromString(String spec) {
                String[] fields = spec.trim().split("\\s+");
                double[] v = new double[fields.length];
                int i = 0;
                while (i < fields.length) {
                    v[i] = Double.parseDouble(fields[i]);
                    ++i;
                }
                return new Transformation(v);
            }
        });
    }

    private void registerVectorConverter() {
        this.registerConverter(new SingleValueConverter(){

            public boolean canConvert(Class clazz) {
                return clazz == Vector.class;
            }

            public String toString(Object value) {
                Vector v = (Vector)value;
                StringBuffer buf = new StringBuffer(12);
                int i = 0;
                while (i < v.getDimension()) {
                    if (i > 0) {
                        buf.append(' ');
                    }
                    buf.append(v.get(i).toString());
                    ++i;
                }
                return buf.toString();
            }

            public Object fromString(String spec) {
                String[] fields = spec.trim().split("\\s+");
                int[] a = new int[fields.length];
                int i = 0;
                while (i < fields.length) {
                    a[i] = Integer.parseInt(fields[i]);
                    ++i;
                }
                return new Vector(a);
            }
        });
    }

    private void registerColorConverter() {
        this.registerConverter(new Converter(){

            public boolean canConvert(Class clazz) {
                return clazz == Color.class;
            }

            public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
                Color c = (Color)value;
                writer.addAttribute("red", String.valueOf(c.getRed()));
                writer.addAttribute("green", String.valueOf(c.getGreen()));
                writer.addAttribute("blue", String.valueOf(c.getBlue()));
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                int red = Integer.parseInt(reader.getAttribute("red"));
                int green = Integer.parseInt(reader.getAttribute("green"));
                int blue = Integer.parseInt(reader.getAttribute("blue"));
                return new Color(red, green, blue);
            }
        });
    }

    private void registerDSymbolConverter() {
        this.registerConverter(new SingleValueConverter(){

            public boolean canConvert(Class clazz) {
                return clazz == DSymbol.class;
            }

            public String toString(Object obj) {
                String code = obj.toString();
                return code.substring(5, code.length() - 1);
            }

            public Object fromString(String spec) {
                return new DSymbol(spec);
            }
        });
    }
}

