/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.apps._3dt;

import de.jreality.scene.Transformation;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.gavrog.apps._3dt.DisplayList;
import org.gavrog.apps._3dt.DocumentXStream;
import org.gavrog.box.collections.Cache;
import org.gavrog.box.collections.CacheMissException;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.simple.NamedConstant;
import org.gavrog.box.simple.Tag;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.derived.Signature;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.SpaceGroupCatalogue;
import org.gavrog.joss.geometry.SpaceGroupFinder;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.Morphism;
import org.gavrog.joss.pgraphs.embed.Embedder;
import org.gavrog.joss.pgraphs.io.GenericParser;
import org.gavrog.joss.pgraphs.io.Net;
import org.gavrog.joss.pgraphs.io.NetParser;
import org.gavrog.joss.tilings.FaceList;
import org.gavrog.joss.tilings.Tiling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
extends DisplayList {
    protected static final Tag TILES = new Tag();
    protected static final Tag EMBEDDER = new Tag();
    protected static final Tag EMBEDDER_OUTPUT = new Tag();
    protected static final Tag FINDER = new Tag();
    protected static final Tag SIGNATURE = new Tag();
    protected static final Tag SPACEGROUP = new Tag();
    protected static final Tag TILING = new Tag();
    protected static final Tag CENTERING_VECTORS = new Tag();
    protected final Cache<Tag, Object> cache = new Cache();
    public static final Object TILING_3D = new Type("3d Tiling");
    public static final Object TILING_2D = new Type("2d Tiling");
    public static final Object NET = new Type("Net");
    private Object type;
    private final String name;
    private GenericParser.Block data = null;
    private DSymbol given_symbol = null;
    private DSymbol symbol = null;
    private DSymbol effective_symbol = null;
    private DSCover<Integer> given_cover = null;
    private Map<Integer, Point> given_positions = null;
    private Matrix given_gram_matrix = null;
    private Transformation transformation = null;
    private Color[] tileClassColor = null;
    private Map<Tiling.Facet, Color> facetClassColor = new HashMap<Tiling.Facet, Color>();
    private Set<Tiling.Facet> hiddenFacetClasses = new HashSet<Tiling.Facet>();
    private int equalEdgePriority = 3;
    private int embedderStepLimit = 10000;
    private boolean ignoreInputCell = false;
    private boolean ignoreInputCoordinates = false;
    private boolean relaxCoordinates = true;
    private boolean useMaximalSymmetry = false;
    private boolean usePrimitiveCell = false;
    private Properties properties = new Properties();
    private File saveSceneFile;
    private static final Random random = new Random();

    private <T> DSymbol extrusion(DelaneySymbol<T> ds) {
        T D;
        int Dc;
        int Db;
        int Da;
        if (ds.dim() != 2) {
            throw new UnsupportedOperationException("dimension must be 2");
        }
        int s = ds.size();
        DynamicDSymbol tmp = new DynamicDSymbol(3);
        List<Integer> elms_new = tmp.grow(s * 3);
        List<T> elms_old = Iterators.asList(ds.elements());
        int i = 0;
        while (i < ds.size()) {
            Da = elms_new.get(i);
            Db = elms_new.get(i + s);
            Dc = elms_new.get(i + s + s);
            D = elms_old.get(i);
            int i0 = elms_old.indexOf(ds.op(0, D));
            int i1 = elms_old.indexOf(ds.op(1, D));
            int i2 = elms_old.indexOf(ds.op(2, D));
            tmp.redefineOp(0, Da, elms_new.get(i0));
            tmp.redefineOp(1, Da, elms_new.get(i1));
            tmp.redefineOp(2, Da, Db);
            tmp.redefineOp(3, Da, Da);
            tmp.redefineOp(0, Db, elms_new.get(i0 + s));
            tmp.redefineOp(1, Db, Dc);
            tmp.redefineOp(2, Db, Da);
            tmp.redefineOp(3, Db, elms_new.get(i2 + s));
            tmp.redefineOp(0, Dc, Dc);
            tmp.redefineOp(1, Dc, Db);
            tmp.redefineOp(2, Dc, elms_new.get(i1 + s + s));
            tmp.redefineOp(3, Dc, elms_new.get(i2 + s + s));
            ++i;
        }
        i = 0;
        while (i < ds.size()) {
            Da = elms_new.get(i);
            Db = elms_new.get(i + s);
            Dc = elms_new.get(i + s + s);
            D = elms_old.get(i);
            tmp.redefineV(0, 1, Da, ds.v(0, 1, D));
            if (D.equals(ds.op(0, D))) {
                tmp.redefineV(0, 1, Db, 2);
            } else {
                tmp.redefineV(0, 1, Db, 1);
            }
            tmp.redefineV(1, 2, Da, 1);
            if (D.equals(ds.op(2, D))) {
                tmp.redefineV(2, 3, Da, 2);
            } else {
                tmp.redefineV(2, 3, Da, 1);
            }
            tmp.redefineV(2, 3, Dc, ds.v(1, 2, D));
            ++i;
        }
        return new DSymbol(tmp);
    }

    public static DSymbol symbolForNet(Net net) {
        if (net.getDimension() != 2) {
            throw new UnsupportedOperationException("Only nets of dimension 2 are supported");
        }
        HashMap<IEdge, Integer> edge2chamber = new HashMap<IEdge, Integer>();
        DynamicDSymbol ds = new DynamicDSymbol(2);
        for (IEdge e : net.edges()) {
            List<Integer> elms = ds.grow(4);
            edge2chamber.put(e.oriented(), elms.get(0));
            edge2chamber.put(e.oriented().reverse(), elms.get(2));
            ds.redefineOp(2, elms.get(0), elms.get(1));
            ds.redefineOp(2, elms.get(2), elms.get(3));
            ds.redefineOp(0, elms.get(0), elms.get(3));
            ds.redefineOp(0, elms.get(1), elms.get(2));
        }
        Map<INode, Point> pos = net.barycentricPlacement();
        for (INode v : net.nodes()) {
            List<IEdge> incidences = net.allIncidences(v);
            if (!net.goodCombinations(incidences, pos).hasNext()) {
                throw new UnsupportedOperationException("Only convex tilings are currently supported");
            }
            Point p = pos.get(v);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Neighbor
            implements Comparable<Neighbor> {
                private final IEdge edge;
                private final double angle;

                public Neighbor(IEdge e, double a) {
                    this.edge = e;
                    this.angle = a;
                }

                @Override
                public int compareTo(Neighbor other) {
                    if (this.angle < other.angle) {
                        return -1;
                    }
                    if (this.angle > other.angle) {
                        return 1;
                    }
                    return 0;
                }
            }
            ArrayList<Neighbor> neighbors = new ArrayList<Neighbor>();
            for (IEdge e : incidences) {
                Vector d = (Vector)net.getShift(e).plus(pos.get(e.target())).minus(p);
                double[] a = d.getCoordinates().asDoubleArray()[0];
                neighbors.add(new Neighbor(e, Math.atan2(a[1], a[0])));
            }
            Collections.sort(neighbors);
            neighbors.add((Neighbor)neighbors.get(0));
            int i = 0;
            while (i < neighbors.size() - 1) {
                IEdge e = ((Neighbor)neighbors.get(i)).edge;
                IEdge f = ((Neighbor)neighbors.get(i + 1)).edge;
                ds.redefineOp(1, ds.op(2, (Integer)edge2chamber.get(e)), (Integer)edge2chamber.get(f));
                ++i;
            }
        }
        Iterator<Object> iterator = ds.elements().iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            ds.redefineV(0, 1, D, 1);
            ds.redefineV(1, 2, D, 1);
        }
        return new DSymbol(ds);
    }

    public Document(DSymbol ds, String name) {
        this(ds, name, null);
    }

    public Document(DSymbol ds, String name, DSCover<Integer> cov) {
        this.given_symbol = ds;
        this.name = name;
        this.given_cover = cov;
        if (ds.dim() == 2) {
            this.type = TILING_2D;
        } else if (ds.dim() == 3) {
            this.type = TILING_3D;
        } else {
            String msg = "only dimensions 2 and 3 supported";
            throw new UnsupportedOperationException("only dimensions 2 and 3 supported");
        }
    }

    public Document(GenericParser.Block block, String defaultName) {
        String type = block.getType().toLowerCase();
        this.type = type.equals("tiling") ? TILING_3D : NET;
        String name = block.getEntriesAsString("name");
        this.name = name == null || name.length() == 0 ? defaultName : name;
        this.data = block;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public boolean isUnprocessed() {
        return this.symbol == null;
    }

    public Document cleanCopy() {
        if (this.data != null) {
            return new Document(this.data, this.name);
        }
        return new Document(this.given_symbol, this.name, this.given_cover);
    }

    public String getName() {
        return this.name;
    }

    public Object getType() {
        return this.type;
    }

    public DSymbol getSymbol() {
        if (this.symbol == null) {
            if (this.data != null) {
                if (this.type == TILING_3D) {
                    this.extractFromFaceList(this.data);
                } else {
                    this.extractFromNet(this.data);
                }
            } else if (this.given_symbol != null) {
                this.extractFromDSymbol(this.given_symbol);
            }
        }
        return this.symbol;
    }

    private void extractFromDSymbol(DSymbol ds) {
        this.symbol = this.useMaximalSymmetry ? new DSymbol(this.given_symbol.minimal()) : this.given_symbol;
        this.effective_symbol = this.type == TILING_2D ? this.extrusion(ds) : ds;
    }

    private void extractFromFaceList(GenericParser.Block data) {
        FaceList fl = new FaceList(data);
        DSymbol raw = fl.getSymbol();
        DSCover<Integer> cov = fl.getCover();
        if (this.useMaximalSymmetry) {
            DSymbol ds = this.symbol = new DSymbol(raw.minimal());
            if (cov.size() == Covers.pseudoToroidalCover3D(ds).size()) {
                this.given_cover = new DSCover<Integer>(fl.getCover(), ds, 1);
                this.given_positions = fl.getPositions();
                this.given_gram_matrix = fl.getGramMatrix();
            }
        } else {
            this.symbol = raw;
            this.given_cover = cov;
            this.given_positions = fl.getPositions();
            this.given_gram_matrix = fl.getGramMatrix();
        }
    }

    private void extractFromNet(GenericParser.Block data) {
        Net net = new NetParser(null).parseNet(data);
        if (net.getDimension() != 2) {
            throw new UnsupportedOperationException("Only nets of dimension 2 are supported.");
        }
        DSymbol ds = this.symbol = Document.symbolForNet(net);
        this.effective_symbol = this.extrusion(ds);
        this.type = TILING_2D;
    }

    private DSymbol getEffectiveSymbol() {
        this.getSymbol();
        if (this.effective_symbol == null) {
            this.effective_symbol = this.symbol;
        }
        return this.effective_symbol;
    }

    public Tiling getTiling() {
        try {
            return (Tiling)this.cache.get(TILING);
        }
        catch (CacheMissException ex) {
            return (Tiling)this.cache.put(TILING, new Tiling(this.getEffectiveSymbol(), this.given_cover));
        }
    }

    public Tiling.Skeleton getNet() {
        return this.getTiling().getSkeleton();
    }

    public List<Tiling.Tile> getTiles() {
        try {
            return (List)this.cache.get(TILES);
        }
        catch (CacheMissException ex) {
            return this.cache.put(TILES, this.getTiling().getTiles());
        }
    }

    public Tiling.Tile getTile(int k) {
        return this.getTiles().get(k);
    }

    private SpaceGroupFinder getFinder() {
        try {
            return (SpaceGroupFinder)this.cache.get(FINDER);
        }
        catch (CacheMissException ex) {
            return (SpaceGroupFinder)this.cache.put(FINDER, new SpaceGroupFinder(this.getTiling().getSpaceGroup()));
        }
    }

    private Map<INode, Point> getNodePositions() {
        Tiling.Skeleton skel = this.getNet();
        if (this.given_positions == null || this.getIgnoreInputCoordinates()) {
            return skel.barycentricPlacement();
        }
        HashMap<INode, Point> pos = new HashMap<INode, Point>();
        for (int D : this.given_positions.keySet()) {
            pos.put(skel.nodeForChamber(D), this.given_positions.get(D));
        }
        Point p0 = (Point)pos.get(skel.nodes().next());
        Point origin = Point.origin(p0.getDimension());
        Vector shift = (Vector)p0.minus(origin);
        for (INode v : skel.nodes()) {
            pos.put(v, (Point)((Point)pos.get(v)).minus(shift));
        }
        for (INode v : skel.nodes()) {
            Point p = skel.barycentricPlacement().get(v);
            int dim = p.getDimension();
            Matrix s = Matrix.zero(dim + 1, dim + 1);
            for (Morphism phi : skel.nodeStabilizer(v)) {
                Operator a = phi.getAffineOperator();
                Vector d = (Vector)p.minus(p.times(a));
                Operator ad = (Operator)a.times(d);
                s = (Matrix)s.plus(ad.getCoordinates());
            }
            pos.put(v, (Point)((Point)pos.get(v)).times(new Operator(s)));
        }
        return pos;
    }

    private Embedder getEmbedder() {
        try {
            return (Embedder)this.cache.get(EMBEDDER);
        }
        catch (CacheMissException ex) {
            return (Embedder)this.cache.put(EMBEDDER, new Embedder(this.getNet(), this.getNodePositions(), false));
        }
    }

    public void initializeEmbedder() {
        this.getEmbedder();
    }

    public void invalidateEmbedding() {
        this.cache.remove(EMBEDDER_OUTPUT);
    }

    public void invalidateTiling() {
        this.removeAll();
        this.cache.clear();
        this.symbol = null;
        this.effective_symbol = null;
        this.given_cover = null;
        this.given_positions = null;
        this.given_gram_matrix = null;
        this.transformation = null;
        this.tileClassColor = null;
        this.facetClassColor.clear();
        this.hiddenFacetClasses.clear();
    }

    private EmbedderOutput getEmbedderOutput() {
        try {
            return (EmbedderOutput)this.cache.get(EMBEDDER_OUTPUT);
        }
        catch (CacheMissException ex) {
            Embedder embedder = this.getEmbedder();
            embedder.reset();
            embedder.setPositions(this.getNodePositions());
            embedder.setPasses(this.getEqualEdgePriority());
            embedder.setGramMatrix(this.given_gram_matrix);
            if (!(this.given_gram_matrix != null && !this.getIgnoreInputCell() || !embedder.getGraph().isStable() && this.getRelaxCoordinates())) {
                embedder.setRelaxPositions(false);
                embedder.go(500);
            }
            if (this.getRelaxCoordinates()) {
                embedder.setRelaxPositions(true);
                embedder.go(this.getEmbedderStepLimit());
            }
            embedder.normalize();
            Matrix G = embedder.getGramMatrix();
            if (!G.equals(G.transposed())) {
                throw new RuntimeException("asymmetric Gram matrix:\n" + G);
            }
            CoordinateChange change = new CoordinateChange(LinearAlgebra.orthonormalRowBasis(G));
            Map<DSPair<Integer>, Point> pos = this.getTiling().cornerPositions(embedder.getPositions());
            return (EmbedderOutput)this.cache.put(EMBEDDER_OUTPUT, new EmbedderOutput(pos, change));
        }
    }

    private Map<DSPair<Integer>, Point> getPositions() {
        return this.getEmbedderOutput().positions;
    }

    public CoordinateChange getEmbedderToWorld() {
        return this.getEmbedderOutput().change;
    }

    public double[] cornerPosition(int i, int D) {
        Point p0 = this.getPositions().get(new DSPair<Integer>(i, D));
        Point p = (Point)p0.times(this.getEmbedderToWorld());
        return p.getCoordinates().asDoubleArray()[0];
    }

    public double volume() {
        double vol = 0.0;
        for (int D : this.getTiling().getCover().elements()) {
            double[][] p = new double[4][];
            int i = 0;
            while (i < 4) {
                p[i] = this.cornerPosition(i, D);
                ++i;
            }
            i = 1;
            while (i < 4) {
                int j = 0;
                while (j < 3) {
                    double[] dArray = p[i];
                    int n = j;
                    dArray[n] = dArray[n] - p[0][j];
                    ++j;
                }
                ++i;
            }
            double or = this.getTiling().coverOrientation(D);
            vol -= or * p[1][0] * p[2][1] * p[3][2];
            vol -= or * p[1][1] * p[2][2] * p[3][0];
            vol -= or * p[1][2] * p[2][0] * p[3][1];
            vol += or * p[1][2] * p[2][1] * p[3][0];
            vol += or * p[1][1] * p[2][0] * p[3][2];
            vol += or * p[1][0] * p[2][2] * p[3][1];
        }
        return vol / 6.0;
    }

    public Point nodePoint(INode v) {
        int D = this.getNet().chamberAtNode(v);
        Point p = this.getPositions().get(new DSPair<Integer>(0, D));
        return (Point)p.times(this.getEmbedderToWorld());
    }

    public Point edgeSourcePoint(IEdge e) {
        int D = this.getNet().chamberAtNode(e.source());
        Point p = this.getPositions().get(new DSPair<Integer>(0, D));
        return (Point)p.times(this.getEmbedderToWorld());
    }

    public Point edgeTargetPoint(IEdge e) {
        int D = this.getNet().chamberAtNode(e.target());
        Vector s = this.getNet().getShift(e);
        Point q0 = (Point)this.getPositions().get(new DSPair<Integer>(0, D)).plus(s);
        return (Point)q0.times(this.getEmbedderToWorld());
    }

    public List<Vector> centerIntoUnitCell(Tiling.Tile t) {
        int dim = this.getEffectiveSymbol().dim();
        DSPair<Integer> c = new DSPair<Integer>(dim, t.getChamber());
        return this.pointIntoUnitCell(this.getPositions().get(c));
    }

    public List<Vector> centerIntoUnitCell(IEdge e) {
        Tiling.Skeleton net = this.getNet();
        int C = net.chamberAtNode(e.source());
        int D = net.chamberAtNode(e.target());
        Vector s = net.getShift(e);
        Point p = this.getPositions().get(new DSPair<Integer>(0, C));
        Point q = (Point)this.getPositions().get(new DSPair<Integer>(0, D)).plus(s);
        return this.pointIntoUnitCell((Point)p.plus(((Vector)q.minus(p)).times(0.5)));
    }

    public List<Vector> centerIntoUnitCell(INode v) {
        int D = this.getNet().chamberAtNode(v);
        return this.pointIntoUnitCell(this.getPositions().get(new DSPair<Integer>(0, D)));
    }

    private Vector shifted(Point p0, Vector s, CoordinateChange c) {
        int dim = p0.getDimension();
        Point p = (Point)p0.plus(s).times(c);
        IArithmetic[] a = new Real[dim];
        int i = 0;
        while (i < dim) {
            a[i] = (Real)p.get(i).plus(0.001).mod(Whole.ONE);
            ++i;
        }
        Vector v = (Vector)new Point(a).minus(p).times(c.inverse());
        IArithmetic[] b = new Whole[dim];
        int i2 = 0;
        while (i2 < dim) {
            b[i2] = (Whole)v.get(i2).round();
            ++i2;
        }
        return (Vector)new Vector(b).plus(s);
    }

    public List<Vector> pointIntoUnitCell(Point p) {
        int dim = p.getDimension();
        CoordinateChange toStd = this.getUsePrimitiveCell() ? new CoordinateChange(Operator.identity(dim)) : this.getFinder().getToStd();
        ArrayList<Vector> result = new ArrayList<Vector>();
        for (Vector s : this.getCenteringVectors()) {
            Vector v = this.shifted(p, s, toStd);
            if (this.getUsePrimitiveCell()) {
                v = (Vector)v.plus(this.originShiftForPrimitive());
            }
            result.add(v);
        }
        return result;
    }

    public Color[] getPalette() {
        if (this.tileClassColor == null) {
            int n = this.getEffectiveSymbol().numberOfOrbits(new IndexList(0, 1, 2));
            this.tileClassColor = new Color[n];
            this.fillPalette(this.tileClassColor);
        }
        return this.tileClassColor;
    }

    private void fillPalette(Color[] palette) {
        int n = palette.length;
        int[] map = this.randomPermutation(n);
        float offset = random.nextFloat();
        float s = 0.6f;
        float b = 1.0f;
        int i = 0;
        while (i < n) {
            float h = ((float)i / (float)n + offset) % 1.0f;
            palette[map[i]] = Color.getHSBColor(h, 0.6f, 1.0f);
            ++i;
        }
    }

    private int[] randomPermutation(int n) {
        int[] result = new int[n];
        ArrayList<Integer> free = new ArrayList<Integer>();
        int i = 0;
        while (i < n) {
            free.add(i);
            ++i;
        }
        i = 0;
        while (i < n) {
            int j = random.nextInt(n - i);
            result[i] = (Integer)free.remove(j);
            ++i;
        }
        return result;
    }

    public Color getEfffectiveColor(DisplayList.Item item) {
        Color c = this.color(item);
        if (c == null && item.isFacet() && (c = this.getFacetClassColor(item.getFacet())) == null) {
            c = this.getDefaultTileColor(item.getFacet().getTile());
        }
        if (c == null && item.isTile()) {
            c = this.getDefaultTileColor(item.getTile());
        }
        return c;
    }

    public Color getTileClassColor(int i) {
        return this.getPalette()[i];
    }

    public Color getDefaultTileColor(Tiling.Tile t) {
        return this.getTileClassColor(t.getKind());
    }

    public Color getDefaultTileColor(int i) {
        return this.getDefaultTileColor(this.getTile(i));
    }

    public void setTileClassColor(int i, Color c) {
        this.getPalette()[i] = c;
    }

    public Color getFacetClassColor(Tiling.Facet f) {
        return this.facetClassColor.get(f);
    }

    public Collection<Tiling.Facet> getColoredFacetClasses() {
        return Collections.unmodifiableSet(this.facetClassColor.keySet());
    }

    public void setFacetClassColor(Tiling.Facet f, Color c) {
        this.facetClassColor.put(f, c);
    }

    public void removeFacetClassColor(Tiling.Facet f) {
        this.facetClassColor.remove(f);
    }

    public boolean isHiddenFacetClass(Tiling.Facet f) {
        return this.hiddenFacetClasses.contains(f);
    }

    public Collection<Tiling.Facet> getHiddenFacetClasses() {
        return Collections.unmodifiableSet(this.hiddenFacetClasses);
    }

    public void hideFacetClass(Tiling.Facet f) {
        this.hiddenFacetClasses.add(f);
    }

    public void showFacetClass(Tiling.Facet f) {
        this.hiddenFacetClasses.remove(f);
    }

    public void randomlyRecolorTiles() {
        this.fillPalette(this.getPalette());
    }

    public String getSignature() {
        try {
            return (String)this.cache.get(SIGNATURE);
        }
        catch (CacheMissException ex) {
            int dim = this.getSymbol().dim();
            String sig = dim == 2 ? Signature.ofTiling(this.getSymbol()) : Signature.ofTiling(this.getTiling().getCover());
            return (String)this.cache.put(SIGNATURE, sig);
        }
    }

    public String getGroupName() {
        try {
            return (String)this.cache.get(SPACEGROUP);
        }
        catch (CacheMissException ex) {
            int dim = this.getSymbol().dim();
            SpaceGroupFinder finder = dim == 2 ? new SpaceGroupFinder(new Tiling(this.getSymbol()).getSpaceGroup()) : this.getFinder();
            return (String)this.cache.put(SPACEGROUP, finder.getGroupName());
        }
    }

    public CoordinateChange getCellToEmbedder() {
        return (CoordinateChange)this.getFinder().getToStd().inverse();
    }

    public CoordinateChange getCellToWorld() {
        return (CoordinateChange)this.getCellToEmbedder().times(this.getEmbedderToWorld());
    }

    public CoordinateChange getWorldToCell() {
        return (CoordinateChange)this.getCellToWorld().inverse();
    }

    public double[][] getUnitCellVectors() {
        int dim = this.getEffectiveSymbol().dim();
        CoordinateChange toStd = this.getFinder().getToStd();
        double[][] result = new double[dim][];
        int i = 0;
        while (i < dim) {
            Vector v = this.getUsePrimitiveCell() ? (Vector)Vector.unit(dim, i).times(toStd).times(this.getCellToWorld()) : (Vector)Vector.unit(dim, i).times(this.getCellToWorld());
            result[i] = v.getCoordinates().asDoubleArray()[0];
            ++i;
        }
        return result;
    }

    public Vector[] getUnitCellVectorsInEmbedderCoordinates() {
        int dim = this.getEffectiveSymbol().dim();
        CoordinateChange toStd = this.getFinder().getToStd();
        Vector[] result = new Vector[dim];
        int i = 0;
        while (i < dim) {
            Vector v = this.getUsePrimitiveCell() ? (Vector)Vector.unit(dim, i).times(toStd) : Vector.unit(dim, i);
            result[i] = (Vector)v.times(this.getCellToEmbedder());
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private List<Vector> getCenteringVectors() {
        block4: {
            try {
                return (List)this.cache.get(Document.CENTERING_VECTORS);
            }
            catch (CacheMissException ex) {
                result = new ArrayList<Vector>();
                fromStd = this.getFinder().getFromStd();
                dim = this.getEffectiveSymbol().dim();
                if (this.getUsePrimitiveCell()) {
                    result.add(Vector.zero(dim));
                    break block4;
                }
                ** for (op : SpaceGroupCatalogue.operators((int)dim, (String)this.getFinder().getExtendedGroupName()))
            }
lbl-1000:
            // 1 sources

            {
                if (!op.linearPart().isOne()) continue;
                result.add((Vector)op.translationalPart().times(fromStd));
                continue;
            }
        }
        return this.cache.put(Document.CENTERING_VECTORS, result);
    }

    private Vector originShiftForPrimitive() {
        int dim = this.getEffectiveSymbol().dim();
        Point p = Point.origin(dim);
        Vector[] vectorArray = this.getUnitCellVectorsInEmbedderCoordinates();
        int n = vectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Vector v = vectorArray[n2];
            p = (Point)p.plus(v);
            ++n2;
        }
        p = (Point)p.dividedBy(2L);
        return this.shifted(p, Vector.zero(dim), this.getFinder().getToStd());
    }

    public double[] getOrigin() {
        Point o;
        int dim = this.getEffectiveSymbol().dim();
        CoordinateChange toStd = this.getFinder().getToStd();
        CoordinateChange id = new CoordinateChange(Operator.identity(dim));
        if (this.getUsePrimitiveCell()) {
            Point p = (Point)Point.origin(dim).times(toStd.inverse());
            o = (Point)p.plus(this.shifted(p, Vector.zero(dim), id)).plus(this.originShiftForPrimitive()).times(toStd).times(this.getCellToWorld());
        } else {
            o = (Point)Point.origin(dim).times(this.getCellToWorld());
        }
        return o.getCoordinates().asDoubleArray()[0];
    }

    private static void add(StringBuffer buf, String key, boolean val) {
        buf.append(key);
        buf.append(": ");
        buf.append(val);
        buf.append('\n');
    }

    private static void add(StringBuffer buf, String key, int val) {
        buf.append(key);
        buf.append(": ");
        buf.append(val);
        buf.append('\n');
    }

    private static <T> void add(StringBuffer buf, String key, T val) {
        buf.append(key);
        buf.append(": ");
        buf.append('\"');
        buf.append(val);
        buf.append('\"');
        buf.append('\n');
    }

    public String info() {
        DSymbol ds = this.getSymbol();
        StringBuffer buf = new StringBuffer(500);
        buf.append("---\n");
        if (this.getName() == null) {
            Document.add(buf, "name", "unnamed");
        } else {
            Document.add(buf, "name", this.getName().split("\\W+")[0]);
        }
        Document.add(buf, "full_name", this.getName());
        Document.add(buf, "dsymbol", this.getSymbol().canonical().toString());
        Document.add(buf, "symbol_size", ds.size());
        Document.add(buf, "dimension", ds.dim());
        Document.add(buf, "transitivity", this.getTransitivity());
        Document.add(buf, "minimal", ds.isMinimal());
        Document.add(buf, "self_dual", ds.equals(ds.dual()));
        Document.add(buf, "signature", this.getSignature());
        Document.add(buf, "spacegroup", this.getGroupName());
        return buf.toString();
    }

    public String getTransitivity() {
        StringBuffer buf = new StringBuffer(10);
        DSymbol ds = this.getSymbol();
        int i = 0;
        while (i <= ((DelaneySymbol)ds).dim()) {
            buf.append(Document.showNumber(ds.numberOfOrbits(IndexList.except(ds, i))));
            ++i;
        }
        return buf.toString();
    }

    private static String showNumber(int n) {
        if (n >= 0 && n < 10) {
            return String.valueOf(n);
        }
        return "(" + n + ")";
    }

    public static List<Document> load(String path) throws FileNotFoundException {
        String ext = path.substring(path.lastIndexOf(46) + 1).toLowerCase();
        return Document.load(new FileReader(path), ext);
    }

    public static List<Document> load(Reader input, String ext) {
        ArrayList<Document> result;
        block18: {
            BufferedReader reader = new BufferedReader(input);
            result = new ArrayList<Document>();
            if (ext.equals("cgd") || ext.equals("pgr")) {
                NetParser parser = new NetParser(reader);
                while (!parser.atEnd()) {
                    GenericParser.Block data = parser.parseDataBlock();
                    result.add(new Document(data, "#" + (result.size() + 1)));
                }
            } else {
                if (ext.equals("ds") || ext.equals("tgs")) {
                    StringBuffer buffer = new StringBuffer(200);
                    String name = null;
                    while (true) {
                        String line;
                        try {
                            line = reader.readLine();
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        if (line != null) {
                            if ((line = line.trim()).length() == 0) continue;
                            if (line.charAt(0) == '#') {
                                if (line.charAt(1) != '@' || !(line = line.substring(2).trim()).startsWith("name ")) continue;
                                name = line.substring(5);
                                continue;
                            }
                            int i = line.indexOf(35);
                            if (i >= 0) {
                                line = line.substring(0, i);
                            }
                            buffer.append(' ');
                            buffer.append(line);
                            if (!buffer.toString().trim().endsWith(">")) continue;
                            DSymbol ds = new DSymbol(buffer.toString().trim());
                            buffer.delete(0, buffer.length());
                            if (name == null) {
                                name = "#" + (result.size() + 1);
                            }
                            result.add(new Document(ds, name));
                            name = null;
                            continue;
                        }
                        break block18;
                        break;
                    }
                }
                if (ext.equals("gsl")) {
                    try {
                        ObjectInputStream ostream = DocumentXStream.instance().createObjectInputStream(reader);
                        while (true) {
                            Document doc;
                            if ((doc = (Document)ostream.readObject()) == null) {
                                continue;
                            }
                            result.add(doc);
                        }
                    }
                    catch (EOFException ostream) {
                    }
                    catch (ClassNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        return result;
    }

    public String toXML() {
        return "<object-stream>\n" + DocumentXStream.instance().toXML(this) + "\n</object-stream>\n";
    }

    public static void main(String[] args) {
        String path = args[0];
        try {
            List<Document> syms = Document.load(path);
            for (Document doc : syms) {
                if (doc.getName() != null) {
                    System.out.println("#@ name " + doc.getName());
                }
                System.out.println(doc.getSymbol().canonical());
                System.out.println(doc.info());
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public int getEmbedderStepLimit() {
        return this.embedderStepLimit;
    }

    public void setEmbedderStepLimit(int embedderStepLimit) {
        if (embedderStepLimit != this.embedderStepLimit) {
            this.invalidateEmbedding();
            this.embedderStepLimit = embedderStepLimit;
        }
    }

    public int getEqualEdgePriority() {
        return this.equalEdgePriority;
    }

    public void setEqualEdgePriority(int equalEdgePriority) {
        if (equalEdgePriority != this.equalEdgePriority) {
            this.invalidateEmbedding();
            this.equalEdgePriority = equalEdgePriority;
        }
    }

    public boolean getIgnoreInputCell() {
        return this.ignoreInputCell;
    }

    public void setIgnoreInputCell(boolean ignoreInputCell) {
        if (ignoreInputCell != this.ignoreInputCell) {
            this.invalidateEmbedding();
            this.ignoreInputCell = ignoreInputCell;
        }
    }

    public boolean getIgnoreInputCoordinates() {
        return this.ignoreInputCoordinates;
    }

    public void setIgnoreInputCoordinates(boolean ignoreInputCoordinates) {
        if (ignoreInputCoordinates != this.ignoreInputCoordinates) {
            this.invalidateEmbedding();
            this.ignoreInputCoordinates = ignoreInputCoordinates;
        }
    }

    public boolean getRelaxCoordinates() {
        return this.relaxCoordinates;
    }

    public void setRelaxCoordinates(boolean relaxCoordinates) {
        if (relaxCoordinates != this.relaxCoordinates) {
            this.invalidateEmbedding();
            this.relaxCoordinates = relaxCoordinates;
        }
    }

    public boolean getUseMaximalSymmetry() {
        return this.useMaximalSymmetry;
    }

    public void setUseMaximalSymmetry(boolean useMaximalSymmetry) {
        if (useMaximalSymmetry != this.useMaximalSymmetry) {
            this.invalidateTiling();
            this.useMaximalSymmetry = useMaximalSymmetry;
        }
    }

    public boolean getUsePrimitiveCell() {
        return this.usePrimitiveCell;
    }

    public void setUsePrimitiveCell(boolean value) {
        if (value != this.usePrimitiveCell) {
            this.cache.remove(CENTERING_VECTORS);
            this.usePrimitiveCell = value;
        }
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation;
    }

    public File getSaveSceneFile() {
        return this.saveSceneFile;
    }

    public void setSaveSceneFile(File file) {
        this.saveSceneFile = file;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmbedderOutput {
        private final Map<DSPair<Integer>, Point> positions;
        private final CoordinateChange change;

        private EmbedderOutput(Map<DSPair<Integer>, Point> pos, CoordinateChange change) {
            this.positions = pos;
            this.change = change;
        }
    }

    public static final class Type
    extends NamedConstant {
        public Type(String name) {
            super(name);
        }
    }
}

