/*
 * Decompiled with CFR 0.152.
 */
package buoy.xml;

import buoy.event.EventSource;
import buoy.widget.WindowWidget;
import buoy.xml.WidgetLocalization;
import buoy.xml.delegate.EventSourceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;

public class WidgetEncoder {
    private static HashMap delegateTable;
    private static EventSourceDelegate defaultDelegate;

    private WidgetEncoder() {
    }

    public static void writeObject(Object object, OutputStream outputStream) {
        WidgetEncoder.writeObject(object, outputStream, null);
    }

    public static void writeObject(Object object, OutputStream outputStream, ExceptionListener exceptionListener) {
        Object object2;
        ThreadLocal threadLocal = null;
        try {
            object2 = WindowWidget.class.getDeclaredField("encodingInProgress");
            ((Field)object2).setAccessible(true);
            threadLocal = (ThreadLocal)((Field)object2).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (threadLocal != null) {
            threadLocal.set(Boolean.TRUE);
        }
        object2 = new WidgetXMLEncoder(outputStream);
        if (exceptionListener != null) {
            ((Encoder)object2).setExceptionListener(exceptionListener);
        }
        ((XMLEncoder)object2).writeExpression(new Expression(Class.class, "forName", new Object[]{"buoy.xml.WidgetLocalization"}));
        String[] stringArray = WidgetLocalization.getAllLocalizedStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            ((XMLEncoder)object2).writeExpression(new Expression(stringArray[i], WidgetLocalization.class, "getLocalizedString", new Object[]{new String(stringArray[i])}));
        }
        ((XMLEncoder)object2).writeObject(object);
        ((XMLEncoder)object2).close();
        if (threadLocal != null) {
            threadLocal.set(Boolean.FALSE);
        }
    }

    public static void setPersistenceDelegate(Class clazz, PersistenceDelegate persistenceDelegate) {
        delegateTable.put(clazz, persistenceDelegate);
    }

    static {
        defaultDelegate = new EventSourceDelegate();
        delegateTable = new HashMap();
    }

    private static class WidgetXMLEncoder
    extends XMLEncoder {
        public WidgetXMLEncoder(OutputStream outputStream) {
            super(outputStream);
        }

        public PersistenceDelegate getPersistenceDelegate(Class clazz) {
            if (clazz != null) {
                PersistenceDelegate persistenceDelegate = (PersistenceDelegate)delegateTable.get(clazz);
                if (persistenceDelegate != null) {
                    return persistenceDelegate;
                }
                if (EventSource.class.isAssignableFrom(clazz)) {
                    return defaultDelegate;
                }
            }
            return super.getPersistenceDelegate(clazz);
        }
    }
}

