/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.FormContainerDelegate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormContainer
extends WidgetContainer {
    private double[] rowWeight;
    private double[] colWeight;
    private int[] minRowSize;
    private int[] prefRowSize;
    private int[] minColSize;
    private int[] prefColSize;
    private ArrayList<ChildInfo> child;
    private LayoutInfo defaultLayout;

    static {
        WidgetEncoder.setPersistenceDelegate(FormContainer.class, new FormContainerDelegate());
    }

    public FormContainer(double[] colWeight, double[] rowWeight) {
        this.colWeight = colWeight;
        this.rowWeight = rowWeight;
        this.component = new WidgetContainerPanel(this);
        this.child = new ArrayList();
        this.defaultLayout = new LayoutInfo();
    }

    @Override
    public JPanel getComponent() {
        return (JPanel)this.component;
    }

    public FormContainer(int numCols, int numRows) {
        this(new double[numCols], new double[numRows]);
        int i = 0;
        while (i < this.rowWeight.length) {
            this.rowWeight[i] = 1.0;
            ++i;
        }
        i = 0;
        while (i < this.colWeight.length) {
            this.colWeight[i] = 1.0;
            ++i;
        }
    }

    @Override
    public int getChildCount() {
        return this.child.size();
    }

    public Widget getChild(int i) {
        return this.child.get((int)i).widget;
    }

    @Override
    public Collection<Widget> getChildren() {
        ArrayList<Widget> list = new ArrayList<Widget>(this.child.size());
        int i = 0;
        while (i < this.child.size()) {
            list.add(this.child.get((int)i).widget);
            ++i;
        }
        return list;
    }

    public int getRowCount() {
        return this.rowWeight.length;
    }

    public int getColumnCount() {
        return this.colWeight.length;
    }

    public void setRowCount(int rows) {
        double[] newWeight = new double[rows];
        if (rows > this.rowWeight.length) {
            int i = 0;
            while (i < this.rowWeight.length) {
                newWeight[i] = this.rowWeight[i];
                ++i;
            }
            i = this.rowWeight.length;
            while (i < newWeight.length) {
                newWeight[i] = 1.0;
                ++i;
            }
        } else {
            int i = this.child.size() - 1;
            while (i >= 0) {
                ChildInfo info = this.child.get(i);
                if (info.y + info.height > rows) {
                    this.remove(i);
                }
                --i;
            }
            i = 0;
            while (i < newWeight.length) {
                newWeight[i] = this.rowWeight[i];
                ++i;
            }
        }
        this.rowWeight = newWeight;
    }

    public void setColumnCount(int columns) {
        double[] newWeight = new double[columns];
        if (columns > this.colWeight.length) {
            int i = 0;
            while (i < this.colWeight.length) {
                newWeight[i] = this.colWeight[i];
                ++i;
            }
            i = this.colWeight.length;
            while (i < newWeight.length) {
                newWeight[i] = 1.0;
                ++i;
            }
        } else {
            int i = this.child.size() - 1;
            while (i >= 0) {
                ChildInfo info = this.child.get(i);
                if (info.x + info.width > columns) {
                    this.remove(i);
                }
                --i;
            }
            i = 0;
            while (i < newWeight.length) {
                newWeight[i] = this.colWeight[i];
                ++i;
            }
        }
        this.colWeight = newWeight;
    }

    public double getRowWeight(int row) {
        return this.rowWeight[row];
    }

    public double getColumnWeight(int col) {
        return this.colWeight[col];
    }

    public void setRowWeight(int row, double weight) {
        this.rowWeight[row] = weight;
    }

    public void setColumnWeight(int col, double weight) {
        this.colWeight[col] = weight;
    }

    @Override
    public void layoutChildren() {
        if (this.minColSize == null) {
            this.calculateSizes();
        }
        Dimension size = this.getComponent().getSize();
        int[] rowPos = this.calculatePositions(this.minRowSize, this.prefRowSize, this.rowWeight, size.height);
        int[] colPos = this.calculatePositions(this.minColSize, this.prefColSize, this.colWeight, size.width);
        Rectangle cell = new Rectangle();
        int i = 0;
        while (i < this.child.size()) {
            ChildInfo info = this.child.get(i);
            LayoutInfo layout = info.layout == null ? this.defaultLayout : info.layout;
            cell.x = info.x == 0 ? 0 : colPos[info.x - 1];
            cell.y = info.y == 0 ? 0 : rowPos[info.y - 1];
            cell.width = colPos[info.x + info.width - 1] - cell.x;
            cell.height = rowPos[info.y + info.height - 1] - cell.y;
            info.widget.getComponent().setBounds(layout.getWidgetLayout(info.widget, cell));
            if (info.widget instanceof WidgetContainer) {
                ((WidgetContainer)info.widget).layoutChildren();
            }
            ++i;
        }
    }

    private int[] calculatePositions(int[] minSize, int[] prefSize, double[] weight, int totalSize) {
        int[] pos = new int[minSize.length];
        int totalMin = 0;
        int totalPref = 0;
        int i = 0;
        while (i < minSize.length) {
            totalMin += minSize[i];
            totalPref += prefSize[i];
            ++i;
        }
        if (totalMin > totalSize) {
            int current = 0;
            int i2 = 0;
            while (i2 < pos.length) {
                pos[i2] = current += minSize[i2];
                ++i2;
            }
        } else if (totalPref > totalSize) {
            double fract = (double)(totalSize - totalMin) / (double)(totalPref - totalMin);
            double current = 0.0;
            int i3 = 0;
            while (i3 < pos.length) {
                pos[i3] = (int)Math.round(current += (double)minSize[i3] + fract * (double)(prefSize[i3] - minSize[i3]));
                ++i3;
            }
        } else {
            double[] realWeight = new double[weight.length];
            double totalWeight = 0.0;
            int i4 = 0;
            while (i4 < weight.length) {
                totalWeight += weight[i4];
                ++i4;
            }
            if (totalWeight > 0.0) {
                i4 = 0;
                while (i4 < realWeight.length) {
                    realWeight[i4] = weight[i4] / totalWeight;
                    ++i4;
                }
            }
            double current = 0.0;
            int i5 = 0;
            while (i5 < pos.length) {
                pos[i5] = (int)Math.round(current += (double)prefSize[i5] + realWeight[i5] * (double)(totalSize - totalPref));
                ++i5;
            }
        }
        return pos;
    }

    public void add(Widget widget, int col, int row) {
        this.add(widget, col, row, null);
    }

    public void add(Widget widget, int col, int row, LayoutInfo layout) {
        this.add(widget, col, row, 1, 1, layout);
    }

    public void add(Widget widget, int col, int row, int width, int height) {
        this.add(widget, col, row, width, height, null);
    }

    public void add(Widget widget, int col, int row, int width, int height, LayoutInfo layout) {
        if (col < 0 || col + width > this.colWeight.length || row < 0 || row + height > this.rowWeight.length || width < 1 || height < 1) {
            throw new IllegalArgumentException();
        }
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child.add(new ChildInfo(widget, layout, col, row, width, height));
        this.getComponent().add(widget.getComponent());
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(int index) {
        return this.child.get((int)index).layout;
    }

    public void setChildLayout(int index, LayoutInfo layout) {
        this.child.get((int)index).layout = layout;
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Widget widget) {
        int index = this.getWidgetIndex(widget);
        if (index == -1) {
            return null;
        }
        return this.child.get((int)index).layout;
    }

    public void setChildLayout(Widget widget, LayoutInfo layout) {
        int index = this.getWidgetIndex(widget);
        if (index == -1) {
            return;
        }
        this.child.get((int)index).layout = layout;
        this.invalidateSize();
    }

    public LayoutInfo getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(LayoutInfo layout) {
        this.defaultLayout = layout;
        this.invalidateSize();
    }

    public Rectangle getChildCells(int index) {
        ChildInfo info = this.child.get(index);
        return new Rectangle(info.x, info.y, info.width, info.height);
    }

    public void setChildCells(int index, Rectangle cells) {
        ChildInfo info = this.child.get(index);
        info.x = cells.x;
        info.y = cells.y;
        info.width = cells.width;
        info.height = cells.height;
        this.invalidateSize();
    }

    public Rectangle getChildCells(Widget widget) {
        int index = this.getWidgetIndex(widget);
        if (index == -1) {
            return null;
        }
        return this.getChildCells(index);
    }

    public void setChildCells(Widget widget, Rectangle cells) {
        int index = this.getWidgetIndex(widget);
        if (index == -1) {
            return;
        }
        this.setChildCells(index, cells);
    }

    @Override
    public void remove(Widget widget) {
        int index = this.getWidgetIndex(widget);
        if (index > -1) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        Widget w = this.child.get((int)index).widget;
        this.getComponent().remove(w.getComponent());
        this.child.remove(index);
        this.removeAsParent(w);
        this.invalidateSize();
    }

    @Override
    public void removeAll() {
        this.getComponent().removeAll();
        int i = 0;
        while (i < this.child.size()) {
            this.removeAsParent(this.child.get((int)i).widget);
            ++i;
        }
        this.child.clear();
        this.invalidateSize();
    }

    public int getWidgetIndex(Widget widget) {
        int i = 0;
        while (i < this.child.size()) {
            if (this.child.get((int)i).widget == widget) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minColSize == null) {
            this.calculateSizes();
        }
        Dimension minSize = new Dimension(0, 0);
        int i = 0;
        while (i < this.minColSize.length) {
            minSize.width += this.minColSize[i];
            ++i;
        }
        i = 0;
        while (i < this.minRowSize.length) {
            minSize.height += this.minRowSize[i];
            ++i;
        }
        return minSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefColSize == null) {
            this.calculateSizes();
        }
        Dimension prefSize = new Dimension(0, 0);
        int i = 0;
        while (i < this.prefColSize.length) {
            prefSize.width += this.prefColSize[i];
            ++i;
        }
        i = 0;
        while (i < this.prefRowSize.length) {
            prefSize.height += this.prefRowSize[i];
            ++i;
        }
        return prefSize;
    }

    @Override
    protected void invalidateSize() {
        this.prefColSize = null;
        this.prefRowSize = null;
        this.minColSize = null;
        this.minRowSize = null;
        super.invalidateSize();
    }

    private void calculateSizes() {
        Dimension[] dim = new Dimension[this.child.size()];
        int i = 0;
        while (i < dim.length) {
            dim[i] = this.child.get((int)i).widget.getMinimumSize();
            ++i;
        }
        this.minRowSize = this.calculateRequiredSizes(dim, true);
        this.minColSize = this.calculateRequiredSizes(dim, false);
        i = 0;
        while (i < dim.length) {
            ChildInfo info = this.child.get(i);
            LayoutInfo layout = info.layout == null ? this.defaultLayout : info.layout;
            dim[i] = layout.getPreferredSize(info.widget);
            ++i;
        }
        this.prefRowSize = this.calculateRequiredSizes(dim, true);
        this.prefColSize = this.calculateRequiredSizes(dim, false);
    }

    private int[] calculateRequiredSizes(Dimension[] dim, boolean row) {
        LinkedList<int[]> requiredList = new LinkedList<int[]>();
        int i = 0;
        while (i < dim.length) {
            ChildInfo info = this.child.get(i);
            if (row) {
                requiredList.addLast(new int[]{info.y, info.height, dim[i].height});
            } else {
                requiredList.addLast(new int[]{info.x, info.width, dim[i].width});
            }
            ++i;
        }
        int[] width = new int[row ? this.rowWeight.length : this.colWeight.length];
        double[] weight = row ? this.rowWeight : this.colWeight;
        int currentWidth = 1;
        while (requiredList.size() > 0) {
            Iterator iter = requiredList.iterator();
            while (iter.hasNext()) {
                int[] req = (int[])iter.next();
                if (req[1] != currentWidth) continue;
                iter.remove();
                if (currentWidth == 1) {
                    width[req[0]] = Math.max(width[req[0]], req[2]);
                    continue;
                }
                int total = 0;
                int i2 = 0;
                while (i2 < currentWidth) {
                    total += width[req[0] + i2];
                    ++i2;
                }
                if (total >= req[2]) continue;
                double totalWeight = 0.0;
                int i3 = 0;
                while (i3 < currentWidth) {
                    totalWeight += weight[req[0] + i3];
                    ++i3;
                }
                int[] extra = new int[currentWidth];
                int totalExtra = 0;
                int i4 = 0;
                while (i4 < currentWidth - 1) {
                    double w = totalWeight > 0.0 ? weight[req[0] + i4] / totalWeight : 1.0 / (double)currentWidth;
                    int n = i4;
                    extra[n] = (int)((double)extra[n] + w * (double)(req[2] - total));
                    totalExtra += extra[i4];
                    ++i4;
                }
                extra[extra.length - 1] = req[2] - total - totalExtra;
                i4 = 0;
                while (i4 < currentWidth) {
                    int n = req[0] + i4;
                    width[n] = width[n] + extra[i4];
                    ++i4;
                }
            }
            ++currentWidth;
        }
        return width;
    }

    private class ChildInfo {
        public Widget widget;
        public LayoutInfo layout;
        public int x;
        public int y;
        public int width;
        public int height;

        public ChildInfo(Widget widget, LayoutInfo layout, int x, int y, int width, int height) {
            this.widget = widget;
            this.layout = layout;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

